/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.dataanalyzer;

import aglobe.agent.dataanalyzer.DiscreteFunction;
import aglobe.agent.dataanalyzer.Graph;
import aglobe.agent.dataanalyzer.GraphInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JPanel;

public class GraphComponent
extends JPanel {
    private GraphInfo window = new GraphInfo();
    private HashMap<DiscreteFunction, Graph> graphs = new HashMap();
    private boolean viewDescriptions = true;
    private boolean thickLines = true;
    public static final BasicStroke THICK_STROKE = new BasicStroke(3.0f);

    public void addGraph(DiscreteFunction df, String descr, Color color) {
        Graph gr = new Graph(df, descr, color);
        if (this.graphs.containsKey(df)) {
            this.graphs.remove(df);
        }
        this.graphs.put(df, gr);
        this.repaint();
    }

    public void removeGraph(DiscreteFunction df) {
        if (this.graphs.containsKey(df)) {
            this.graphs.remove(df);
            this.repaint();
        }
    }

    public void showDescriptions(boolean enabled) {
        if (this.viewDescriptions != enabled) {
            this.viewDescriptions = enabled;
            this.repaint();
        }
    }

    public boolean descriptionsVisible() {
        return this.viewDescriptions;
    }

    public void setThickLines(boolean enabled) {
        if (this.thickLines != enabled) {
            this.thickLines = enabled;
            this.repaint();
        }
    }

    public boolean useThickLines() {
        return this.thickLines;
    }

    public void setXRange(double minX, double maxX) {
        this.window.minX = minX;
        this.window.maxX = maxX;
        this.repaint();
    }

    public void setYRange(double minY, double maxY) {
        this.window.minY = minY;
        this.window.maxY = maxY;
        this.repaint();
    }

    public void setRanges(double minX, double maxX, double minY, double maxY) {
        this.window.minX = minX;
        this.window.maxX = maxX;
        this.window.minY = minY;
        this.window.maxY = maxY;
        this.repaint();
    }

    public final GraphInfo getRanges() {
        return this.window;
    }

    public final boolean hasData() {
        return !this.graphs.isEmpty();
    }

    public void drawAxes(Graphics g, Rectangle rect) {
        double lg;
        double step;
        double d;
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
        double min = this.window.minY;
        double max = this.window.maxY;
        if (Math.abs(max - min) < 1.0E-10) {
            min -= 1.0;
            max += 1.0;
        }
        if ((d = max - min) / (step = Math.pow(10.0, lg = Math.floor(Math.log10(d)))) < 3.0) {
            step /= 10.0;
        }
        int i = (int)Math.ceil(min / step);
        while (i <= (int)Math.floor(max / step)) {
            int yyy = rect.y + rect.height - (int)((double)rect.height * ((double)i * step - this.window.minY) / d);
            g.drawLine(rect.x - 3, yyy, rect.x + 3, yyy);
            g.drawString(String.format("%1$.2f", (double)i * step), rect.x - 32, yyy + 5);
            ++i;
        }
        d = this.window.maxX - this.window.minX;
        lg = Math.floor(Math.log10(d));
        step = Math.pow(10.0, lg);
        if (d / step < 2.0) {
            step /= 10.0;
        }
        i = (int)Math.ceil(this.window.minX / step);
        while (i <= (int)Math.floor(this.window.maxX / step)) {
            int xxx = (int)((double)rect.x + (double)rect.width * ((double)i * step - this.window.minX) / d);
            g.drawLine(xxx, rect.y + rect.height - 3, xxx, rect.y + rect.height + 3);
            g.drawString(String.format("%1$.2f", (double)i * step / 1000.0), xxx - 15, rect.y + rect.height + 15);
            ++i;
        }
    }

    public void drawStrings(Graphics g, Rectangle rect) {
        int y = rect.y;
        for (Graph gr : this.graphs.values()) {
            g.setColor(gr.getColor());
            g.drawString(gr.getDescription(), rect.x + 8, y + 18);
            y += 18;
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        g2.setBackground(Color.BLACK);
        g2.clearRect(0, 0, w, h);
        g.setColor(Color.WHITE);
        Rectangle rect = new Rectangle(35, 20, w - 55, h - 40);
        this.drawAxes(g, rect);
        if (this.thickLines) {
            ((Graphics2D)g).setStroke(THICK_STROKE);
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (Graph gr2 : this.graphs.values()) {
            if (gr2.getFunction().isEmpty()) continue;
            double mm = gr2.getFunction().minValue();
            double MM = gr2.getFunction().maxValue();
            if (mm < min) {
                min = mm;
            }
            if (!(MM > max)) continue;
            max = MM;
        }
        this.window.minY = min;
        this.window.maxY = max;
        if (min == Double.POSITIVE_INFINITY || max == Double.NEGATIVE_INFINITY) {
            return;
        }
        for (Graph gr : this.graphs.values()) {
            if (gr.getFunction().isEmpty()) continue;
            gr.draw(g2, this.window, rect);
        }
        if (this.viewDescriptions) {
            this.drawStrings(g, rect);
        }
    }
}

