/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.dataanalyzer;

import aglobe.agent.dataanalyzer.DiscreteFunction;
import aglobe.agent.dataanalyzer.GraphComponent;
import aglobe.agent.dataanalyzer.GraphInfo;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class Graph {
    private Color color;
    private String description;
    private DiscreteFunction df;
    private ArrayList<Point> pointBuffer = new ArrayList();
    private boolean visible = false;
    public static GraphComponent gc = null;

    public Graph(DiscreteFunction df, String description, Color color) {
        this.df = df;
        this.description = description;
        this.color = color;
    }

    public final Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.visible) {
            gc.removeGraph(this.df);
            gc.addGraph(this.df, this.description, color);
        }
    }

    public final String getDescription() {
        return this.description;
    }

    public final DiscreteFunction getFunction() {
        return this.df;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean enabled) {
        this.visible = enabled;
        if (this.visible) {
            gc.addGraph(this.df, this.description, this.color);
        } else {
            gc.removeGraph(this.df);
        }
    }

    public void draw(Graphics2D g, GraphInfo gi, Rectangle rect) {
        int yy;
        int xx2;
        int xx1;
        double y;
        double x;
        double dx = 1.0 / (gi.maxX - gi.minX);
        double dy = 1.0 / (gi.maxY - gi.minY);
        int n = this.df.size();
        if (n == 0) {
            return;
        }
        this.pointBuffer.clear();
        g.setColor(this.color);
        int ndx = this.df.getIndex(gi.minX);
        if (ndx < 0) {
            ndx = 0;
            x = this.df.getSample((int)ndx).x;
            if (x >= gi.maxX) {
                return;
            }
        } else {
            x = gi.minX;
        }
        while (x < gi.maxX && ndx < n - 1) {
            y = this.df.getSample((int)ndx).y;
            ++ndx;
            double x2 = this.df.getSample((int)ndx).x;
            if (x2 > gi.maxX) {
                x2 = gi.maxX;
            }
            xx1 = rect.x + (int)((double)rect.width * (x - gi.minX) * dx);
            xx2 = rect.x + (int)((double)rect.width * (x2 - gi.minX) * dx);
            yy = rect.height + rect.y - (int)((double)rect.height * (y - gi.minY) * dy);
            this.pointBuffer.add(new Point(xx1, yy));
            this.pointBuffer.add(new Point(xx2, yy));
            x = x2;
        }
        if (x < gi.maxX) {
            y = this.df.getSample((int)ndx).y;
            xx1 = rect.x + (int)((double)rect.width * (x - gi.minX) * dx);
            xx2 = rect.x + rect.width;
            yy = rect.height + rect.y - (int)((double)rect.height * (y - gi.minY) * dy);
            this.pointBuffer.add(new Point(xx1, yy));
            this.pointBuffer.add(new Point(xx2, yy));
        }
        n = this.pointBuffer.size();
        Point p1 = this.pointBuffer.get(0);
        int i = 1;
        while (i < n) {
            Point p2 = this.pointBuffer.get(i);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            p1 = p2;
            ++i;
        }
    }
}

