/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.dataanalyzer;

import aglobe.agent.dataanalyzer.AboutGUI;
import aglobe.agent.dataanalyzer.DataAnalyzerAgent;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_btnBack_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_btnEnd_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_btnForward_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_btnRun_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_btnStart_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_btnZoomIn_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_btnZoomOut_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemAbout_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemDefaultZoom_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemDescr_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemExit_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemGoBack_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemGoForward_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemGoToEnd_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemGoToStart_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemLines_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemLog_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemSaveAs_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemSelect_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemZoomIn_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_itemZoomOut_actionAdapter;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI_this_windowAdapter;
import aglobe.agent.dataanalyzer.Graph;
import aglobe.agent.dataanalyzer.GraphComponent;
import aglobe.agent.dataanalyzer.GraphSelectorGUI;
import aglobe.platform.thread.AglobeThreadPool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class DataAnalyzerGUI
extends JFrame {
    private double minX = -1.0;
    private double maxX = 2.0;
    private double currentX = 0.0;
    private double period = 1.0;
    private double relativeStep = 0.1;
    private double zoomFactor = 1.3;
    private boolean running = false;
    private boolean somethingIsVisible = false;
    private Refresh timer = null;
    private DataAnalyzerAgent owner;
    public GraphSelectorGUI graphSelector;
    BorderLayout borderLayout1 = new BorderLayout();
    GraphComponent canvas = new GraphComponent();
    JPanel jPanel2 = new JPanel();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu menuFile = new JMenu();
    JMenuItem itemSaveAs = new JMenuItem();
    JMenuItem itemExit = new JMenuItem();
    JButton btnRun = new JButton();
    JLabel staticText = new JLabel();
    JButton btnStart = new JButton();
    JButton btnEnd = new JButton();
    JButton btnBack = new JButton();
    JButton btnForward = new JButton();
    JButton btnZoomIn = new JButton();
    JButton btnZoomOut = new JButton();
    JMenu menuView = new JMenu();
    JMenu menuHelp = new JMenu();
    JMenuItem itemAbout = new JMenuItem();
    JMenuItem itemZoomIn = new JMenuItem();
    JMenuItem itemZoomOut = new JMenuItem();
    JMenuItem itemDefaultZoom = new JMenuItem();
    JMenuItem itemGoToStart = new JMenuItem();
    JMenuItem itemGoBack = new JMenuItem();
    JMenuItem itemGoForward = new JMenuItem();
    JMenuItem itemGoToEnd = new JMenuItem();
    JCheckBoxMenuItem itemSelect = new JCheckBoxMenuItem();
    JCheckBoxMenuItem itemLog = new JCheckBoxMenuItem();
    JCheckBoxMenuItem itemDescr = new JCheckBoxMenuItem();
    JCheckBoxMenuItem itemLines = new JCheckBoxMenuItem();

    public void updateUI() {
        this.somethingIsVisible = this.canvas.hasData();
        this.btnRun.setEnabled(this.somethingIsVisible);
        this.btnStart.setEnabled(this.somethingIsVisible && !this.running);
        this.btnEnd.setEnabled(this.somethingIsVisible && !this.running);
        this.btnBack.setEnabled(this.somethingIsVisible && !this.running);
        this.btnForward.setEnabled(this.somethingIsVisible && !this.running);
        this.btnZoomIn.setEnabled(this.somethingIsVisible && !this.running);
        this.btnZoomOut.setEnabled(this.somethingIsVisible && !this.running);
        this.staticText.setText("  " + String.format("%1$.1f", this.currentX) + " (" + String.format("%1$.1f", this.period) + ")  ");
    }

    public void setDefaultZoom() {
        this.currentX = 0.0;
        this.period = 1.0;
        this.canvas.setXRange(this.currentX, this.currentX + this.period);
        this.updateUI();
    }

    public void goToStart() {
        this.currentX = this.minX;
        this.canvas.setXRange(this.currentX, this.currentX + this.period);
        this.updateUI();
    }

    public void goToEnd() {
        this.currentX = this.maxX - this.period;
        if (this.currentX < this.minX) {
            this.currentX = this.minX;
        }
        this.canvas.setXRange(this.currentX, this.currentX + this.period);
        this.updateUI();
    }

    public void goForward() {
        this.currentX += this.relativeStep * this.period;
        if (this.currentX > this.maxX - this.period) {
            this.currentX = this.maxX - this.period;
        }
        if (this.currentX < this.minX) {
            this.currentX = this.minX;
        }
        this.canvas.setXRange(this.currentX, this.currentX + this.period);
        this.updateUI();
    }

    public void goBack() {
        this.currentX -= this.relativeStep * this.period;
        if (this.currentX < this.minX) {
            this.currentX = this.minX;
        }
        this.canvas.setXRange(this.currentX, this.currentX + this.period);
        this.updateUI();
    }

    public void goTo(double x) {
        this.currentX = x;
        if (this.maxX < this.currentX + this.period) {
            this.maxX = this.currentX + this.period;
        }
        this.canvas.setXRange(this.currentX, this.currentX + this.period);
        this.updateUI();
    }

    public void zoomIn() {
        this.period /= this.zoomFactor;
        this.canvas.setXRange(this.currentX, this.currentX + this.period);
        this.updateUI();
    }

    public void zoomOut() {
        this.period *= this.zoomFactor;
        if (this.currentX > this.maxX - this.period) {
            this.currentX = this.maxX - this.period;
        }
        if (this.currentX < this.minX) {
            this.currentX = this.minX;
        }
        this.canvas.setXRange(this.currentX, this.currentX + this.period);
        this.updateUI();
    }

    public void init() {
        this.minX = 0.0;
        this.maxX = 1.0;
        this.currentX = 0.0;
        this.period = 10000.0;
        this.relativeStep = 0.3;
        this.zoomFactor = 1.3;
        this.running = false;
        this.somethingIsVisible = false;
        Graph.gc = this.canvas;
        this.graphSelector = new GraphSelectorGUI(this.owner);
        this.graphSelector.showGUI();
        this.itemLines.setState(true);
        this.itemDescr.setState(true);
        this.itemSelect.setState(true);
        this.itemLog.setState(false);
        this.updateUI();
    }

    public DataAnalyzerGUI(DataAnalyzerAgent owner) {
        this.owner = owner;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.btnRun.setText("Run");
        this.btnRun.addActionListener(new DataAnalyzerGUI_btnRun_actionAdapter(this));
        this.staticText.setText("");
        this.btnStart.setText("|<");
        this.btnStart.addActionListener(new DataAnalyzerGUI_btnStart_actionAdapter(this));
        this.btnEnd.setText(">|");
        this.btnEnd.addActionListener(new DataAnalyzerGUI_btnEnd_actionAdapter(this));
        this.btnBack.setText("<");
        this.btnBack.addActionListener(new DataAnalyzerGUI_btnBack_actionAdapter(this));
        this.btnForward.setText(">");
        this.btnForward.addActionListener(new DataAnalyzerGUI_btnForward_actionAdapter(this));
        this.btnZoomIn.setText("+");
        this.btnZoomIn.addActionListener(new DataAnalyzerGUI_btnZoomIn_actionAdapter(this));
        this.btnZoomOut.setText("-");
        this.btnZoomOut.addActionListener(new DataAnalyzerGUI_btnZoomOut_actionAdapter(this));
        this.menuView.setText("View");
        this.menuHelp.setText("Help");
        this.itemAbout.setText("About...");
        this.itemAbout.addActionListener(new DataAnalyzerGUI_itemAbout_actionAdapter(this));
        this.itemZoomIn.setText("Zoom In");
        this.itemZoomIn.setAccelerator(KeyStroke.getKeyStroke(107, 0, false));
        this.itemZoomIn.addActionListener(new DataAnalyzerGUI_itemZoomIn_actionAdapter(this));
        this.itemZoomOut.setText("Zoom Out");
        this.itemZoomOut.setAccelerator(KeyStroke.getKeyStroke(109, 0, false));
        this.itemZoomOut.addActionListener(new DataAnalyzerGUI_itemZoomOut_actionAdapter(this));
        this.itemDefaultZoom.setText("Default zoom");
        this.itemDefaultZoom.setAccelerator(KeyStroke.getKeyStroke(96, 0, false));
        this.itemDefaultZoom.addActionListener(new DataAnalyzerGUI_itemDefaultZoom_actionAdapter(this));
        this.itemGoToStart.setText("Go to start");
        this.itemGoToStart.setAccelerator(KeyStroke.getKeyStroke(66, 2, false));
        this.itemGoToStart.addActionListener(new DataAnalyzerGUI_itemGoToStart_actionAdapter(this));
        this.itemGoBack.setText("Go back");
        this.itemGoBack.setAccelerator(KeyStroke.getKeyStroke(44, 0, false));
        this.itemGoBack.addActionListener(new DataAnalyzerGUI_itemGoBack_actionAdapter(this));
        this.itemGoForward.setText("Go forward");
        this.itemGoForward.setAccelerator(KeyStroke.getKeyStroke(46, 0, false));
        this.itemGoForward.addActionListener(new DataAnalyzerGUI_itemGoForward_actionAdapter(this));
        this.itemGoToEnd.setText("Go to end");
        this.itemGoToEnd.setAccelerator(KeyStroke.getKeyStroke(69, 2, false));
        this.itemGoToEnd.addActionListener(new DataAnalyzerGUI_itemGoToEnd_actionAdapter(this));
        this.itemSelect.setText("Select graphs");
        this.itemSelect.setAccelerator(KeyStroke.getKeyStroke(71, 2, false));
        this.itemSelect.addActionListener(new DataAnalyzerGUI_itemSelect_actionAdapter(this));
        this.itemLog.setText("System log");
        this.itemLog.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        this.itemLog.addActionListener(new DataAnalyzerGUI_itemLog_actionAdapter(this));
        this.itemDescr.setText("Show descriptions");
        this.itemDescr.setAccelerator(KeyStroke.getKeyStroke(68, 2, false));
        this.itemDescr.addActionListener(new DataAnalyzerGUI_itemDescr_actionAdapter(this));
        this.itemLines.setText("Thick lines");
        this.itemLines.setAccelerator(KeyStroke.getKeyStroke(76, 2, false));
        this.itemLines.addActionListener(new DataAnalyzerGUI_itemLines_actionAdapter(this));
        this.itemSaveAs.addActionListener(new DataAnalyzerGUI_itemSaveAs_actionAdapter(this));
        this.itemExit.addActionListener(new DataAnalyzerGUI_itemExit_actionAdapter(this));
        this.addWindowListener(new DataAnalyzerGUI_this_windowAdapter(this));
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add(this.btnRun);
        this.jPanel2.add(this.btnStart);
        this.jPanel2.add(this.btnBack);
        this.jPanel2.add(this.staticText);
        this.jPanel2.add(this.btnForward);
        this.jPanel2.add(this.btnEnd);
        this.jPanel2.add(this.btnZoomIn);
        this.jPanel2.add(this.btnZoomOut);
        this.setJMenuBar(this.jMenuBar1);
        this.getContentPane().add((Component)this.canvas, "Center");
        this.menuFile.setText("File");
        this.itemSaveAs.setText("Save As...");
        this.itemExit.setText("Exit");
        this.jMenuBar1.add(this.menuFile);
        this.jMenuBar1.add(this.menuView);
        this.jMenuBar1.add(this.menuHelp);
        this.menuFile.add(this.itemSaveAs);
        this.menuFile.addSeparator();
        this.menuFile.add(this.itemExit);
        this.menuHelp.add(this.itemAbout);
        this.menuView.add(this.itemZoomIn);
        this.menuView.add(this.itemZoomOut);
        this.menuView.add(this.itemDefaultZoom);
        this.menuView.addSeparator();
        this.menuView.add(this.itemGoToStart);
        this.menuView.add(this.itemGoBack);
        this.menuView.add(this.itemGoForward);
        this.menuView.add(this.itemGoToEnd);
        this.menuView.addSeparator();
        this.menuView.add(this.itemSelect);
        this.menuView.add(this.itemLog);
        this.menuView.addSeparator();
        this.menuView.add(this.itemDescr);
        this.menuView.add(this.itemLines);
    }

    public void btnStart_actionPerformed(ActionEvent e) {
        this.goToStart();
    }

    public void btnBack_actionPerformed(ActionEvent e) {
        this.goBack();
    }

    public void btnForward_actionPerformed(ActionEvent e) {
        this.goForward();
    }

    public void btnEnd_actionPerformed(ActionEvent e) {
        this.goToEnd();
    }

    public void btnZoomIn_actionPerformed(ActionEvent e) {
        this.zoomIn();
    }

    public void btnZoomOut_actionPerformed(ActionEvent e) {
        this.zoomOut();
    }

    public void itemSaveAs_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            this.owner.getData().saveAll(fc.getSelectedFile().getPath());
        }
    }

    public void itemExit_actionPerformed(ActionEvent e) {
        this.graphSelector.dispose();
        this.dispose();
    }

    public void itemZoomIn_actionPerformed(ActionEvent e) {
        this.zoomIn();
    }

    public void itemZoomOut_actionPerformed(ActionEvent e) {
        this.zoomOut();
    }

    public void itemDefaultZoom_actionPerformed(ActionEvent e) {
        this.setDefaultZoom();
    }

    public void itemSelect_actionPerformed(ActionEvent e) {
        if (((JCheckBoxMenuItem)e.getSource()).getState()) {
            this.graphSelector.setVisible(true);
        } else {
            this.graphSelector.setVisible(false);
        }
    }

    public void itemDescr_actionPerformed(ActionEvent e) {
        if (((JCheckBoxMenuItem)e.getSource()).getState()) {
            this.canvas.showDescriptions(true);
        } else {
            this.canvas.showDescriptions(false);
        }
    }

    public void itemLog_actionPerformed(ActionEvent e) {
    }

    public void itemLines_actionPerformed(ActionEvent e) {
        if (((JCheckBoxMenuItem)e.getSource()).getState()) {
            this.canvas.setThickLines(true);
        } else {
            this.canvas.setThickLines(false);
        }
    }

    public void itemGoToStart_actionPerformed(ActionEvent e) {
        this.goToStart();
    }

    public void itemGoBack_actionPerformed(ActionEvent e) {
        this.goBack();
    }

    public void itemGoForward_actionPerformed(ActionEvent e) {
        this.goForward();
    }

    public void itemGoToEnd_actionPerformed(ActionEvent e) {
        this.goToEnd();
    }

    public void itemAbout_actionPerformed(ActionEvent e) {
        new AboutGUI();
    }

    public void btnRun_actionPerformed(ActionEvent e) {
        boolean bl = this.running = !this.running;
        if (this.running) {
            this.graphSelector.enableChoice(false);
            long time = System.currentTimeMillis() - this.owner.getStartTime();
            this.timer = new Refresh(time - (long)((int)this.period), 100L);
            AglobeThreadPool.getThread(this.timer, "Refresh thread").start();
            this.btnRun.setText("Stop");
        } else {
            this.timer.halt();
            this.timer = null;
            this.btnRun.setText("Run");
            this.graphSelector.enableChoice(true);
        }
        this.updateUI();
    }

    public void this_windowClosing(WindowEvent e) {
        if (this.graphSelector != null) {
            this.graphSelector.dispose();
        }
        this.owner.done();
    }

    private class Refresh
    implements Runnable {
        private long frame = 0L;
        private long period = 1000L;
        private volatile Refresh dummy = this;

        public Refresh(long start, long period) {
            this.period = period;
            this.frame = start;
        }

        public void run() {
            while (this.dummy == this) {
                try {
                    Thread.sleep(this.period);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.frame += this.period;
                DataAnalyzerGUI.this.goTo(this.frame);
            }
        }

        public void halt() {
            this.dummy = null;
        }
    }
}

