/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.dataanalyzer;

import aglobe.agent.dataanalyzer.CollectedData;
import aglobe.agent.dataanalyzer.DataAnalyzerGUI;
import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import aglobe.ontology.AglobeParams;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataAnalyzerAgent
extends Agent
implements GISTopicServerListener {
    private DataAnalyzerGUI gui;
    private CollectedData data;
    private long startTime;
    public static final String TOPIC_TEST_DATA = "TEST_DATA";
    private GISServerService.Shell gisShell;

    public void init(AgentInfo ai, int initState) {
        if (this.data == null) {
            this.startTime = System.currentTimeMillis();
            this.data = new CollectedData();
        }
        try {
            if (this.gui == null) {
                this.gui = new DataAnalyzerGUI(this);
            }
        }
        catch (Exception ex) {
            this.logSevere("Cannot create gui due to: " + ex + "\nDataAnalyzer will be stopped");
            this.stop();
            return;
        }
        this.gui.setTitle("Test Agent - " + this.getContainer().getContainerName() + ":" + ai.getReadableName());
        this.gui.init();
        this.gui.setSize(800, 600);
        this.gui.validate();
        this.gui.setVisible(true);
        if (this.gisShell == null) {
            this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        }
        if (this.gisShell == null) {
            this.logWarning("DataAnalyzerAgent runs only on a server container!");
            this.kill();
        } else {
            this.gisShell.subscribeTopic(TOPIC_TEST_DATA, this);
        }
    }

    protected void handleIncomingMessage(Message m) {
        this.logWarning("Unexpected message: " + m.toString());
        m.release();
    }

    public void exit() {
        this.kill();
    }

    public void handleTopic(String topic, Object content, String reason, String contName, Address contAddress) {
        if (topic.equals(TOPIC_TEST_DATA)) {
            List<AglobeParam> parList = ((AglobeParams)content).getAglobeParam();
            ArrayList<AglobeParam> tmp = new ArrayList<AglobeParam>();
            long timestamp = Long.MIN_VALUE;
            String agentName = null;
            Iterator<AglobeParam> iterator = parList.iterator();
            while (iterator.hasNext()) {
                AglobeParam listElem;
                AglobeParam par = listElem = iterator.next();
                try {
                    if (par.getName().equals("timestamp")) {
                        timestamp = Integer.decode(par.getValue()).intValue();
                        continue;
                    }
                    if (par.getName().equals("name")) {
                        agentName = par.getValue();
                        continue;
                    }
                    tmp.add(par);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            timestamp = System.currentTimeMillis() - this.startTime;
            if (timestamp != Long.MIN_VALUE) {
                String paramName = "";
                boolean added = false;
                for (AglobeParam par : tmp) {
                    try {
                        paramName = par.getName();
                        double value = Double.parseDouble(par.getValue());
                        this.data.addValue(agentName, paramName, timestamp, value);
                        added = true;
                    }
                    catch (NumberFormatException nfe) {
                        this.logWarning("Invalid value for parameter '" + paramName + "'");
                    }
                }
                if (added) {
                    this.gui.graphSelector.updateContent();
                }
            }
            return;
        }
        this.logWarning("Unexpected incoming topic: " + topic);
    }

    public void handleLoginTopic(String topic, String contName, Address contAddress) {
    }

    public void handleLogoutTopic(String topic, String contName) {
    }

    protected void finish() {
        if (this.gisShell != null) {
            this.gisShell.unsubscribeTopic(TOPIC_TEST_DATA);
        }
    }

    public final CollectedData getData() {
        return this.data;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public void done() {
        this.stop();
    }

    public void updateUI() {
        this.gui.updateUI();
    }
}

