/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.dataanalyzer;

import aglobe.agent.dataanalyzer.DiscreteFunction;
import aglobe.agent.dataanalyzer.Graph;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

public class CollectedData {
    private Hashtable<String, Integer> agentNames = new Hashtable();
    private Hashtable<String, Integer> paramNames = new Hashtable();
    private int agents = 0;
    private int params = 0;
    private ArrayList<ArrayList<Graph>> data = new ArrayList();
    private Graph numberOfAgents = new Graph(new DiscreteFunction(), "number of agents", Color.WHITE);
    private long startTime;
    private long endTime;
    public static final Color[] BASIC_COLORS = new Color[]{Color.MAGENTA, Color.GREEN, Color.RED, Color.BLUE, Color.ORANGE, Color.GREEN, Color.RED, Color.CYAN, Color.YELLOW};
    public int aktDefaultColor = 0;

    public CollectedData() {
        this.clear();
    }

    public final GraphEnumerator enumerator() {
        return new GraphEnumerator(this);
    }

    public final Graph agentCount() {
        return this.numberOfAgents;
    }

    public final int numAgents() {
        return this.agents;
    }

    public final int numParams() {
        return this.params;
    }

    public final boolean containsAgent(String name) {
        return this.agentNames.containsKey(name);
    }

    public final boolean containsParam(String name) {
        return this.paramNames.containsKey(name);
    }

    private final int agentIndex(String name) {
        if (this.agentNames.containsKey(name)) {
            return this.agentNames.get(name);
        }
        return -1;
    }

    private final int paramIndex(String name) {
        if (this.paramNames.containsKey(name)) {
            return this.paramNames.get(name);
        }
        return -1;
    }

    public final String agentName(int index) {
        for (Map.Entry<String, Integer> me : this.agentNames.entrySet()) {
            if (me.getValue() != index) continue;
            return me.getKey();
        }
        return "n/a";
    }

    public final String paramName(int index) {
        for (Map.Entry<String, Integer> me : this.paramNames.entrySet()) {
            if (me.getValue() != index) continue;
            return me.getKey();
        }
        return "n/a";
    }

    public void clear() {
        this.agentNames.clear();
        this.paramNames.clear();
        this.numberOfAgents.getFunction().clear();
        this.numberOfAgents.getFunction().addSample(0.0, 0.0);
        this.data.clear();
        this.agents = 0;
        this.params = 0;
        this.startTime = 0L;
        this.endTime = -1L;
        this.addAgent("average");
    }

    private void addAgent(String name) {
        ArrayList<Graph> alist = new ArrayList<Graph>();
        int i = 0;
        while (i < this.params) {
            alist.add(new Graph(new DiscreteFunction(), String.valueOf(name) + " (" + this.paramName(i) + ")", this.getDefaultColor()));
            ++i;
        }
        this.data.add(alist);
        this.agentNames.put(name, this.agents);
        ++this.agents;
    }

    private void addParam(String name) {
        int i = 0;
        while (i < this.agents) {
            this.data.get(i).add(new Graph(new DiscreteFunction(), String.valueOf(this.agentName(i)) + " (" + name + ")", this.getDefaultColor()));
            ++i;
        }
        this.paramNames.put(name, this.params);
        ++this.params;
    }

    private Color getDefaultColor() {
        Color returnColor = BASIC_COLORS[this.aktDefaultColor];
        this.aktDefaultColor = (this.aktDefaultColor + 1) % BASIC_COLORS.length;
        return returnColor;
    }

    public final Graph get(String agent, String param) {
        int ai = this.agentIndex(agent);
        int pi = this.paramIndex(param);
        if (ai >= 0 && pi >= 0) {
            return this.data.get(ai).get(pi);
        }
        return null;
    }

    public final Graph get(int agent, int param) {
        return this.data.get(agent).get(param);
    }

    public final Graph getCounts() {
        return this.numberOfAgents;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public void addValue(String agent, String param, long time, double value) {
        Graph gr;
        int i;
        if (this.startTime > this.endTime) {
            this.startTime = this.endTime = time;
        } else if (time > this.endTime) {
            this.endTime = time;
        }
        if (!this.containsAgent(agent)) {
            double factor = this.agents;
            this.addAgent(agent);
            factor /= (double)this.agents;
            this.numberOfAgents.getFunction().addSample(time, this.agents - 1);
            i = 0;
            while (i < this.params) {
                gr = this.data.get(0).get(i);
                gr.getFunction().addSample(time, factor * gr.getFunction().lastValue());
                ++i;
            }
        }
        if (!this.containsParam(param)) {
            this.addParam(param);
            this.data.get(0).get(this.params - 1).getFunction().addSample(time, value);
        }
        int ai = this.agentIndex(agent);
        int pi = this.paramIndex(param);
        gr = this.data.get(ai).get(pi);
        gr.getFunction().addSample(time, value);
        double avg = 0.0;
        double cnt = 0.0;
        i = 1;
        while (i < this.agents) {
            if (!this.data.get(i).get(pi).getFunction().isEmpty()) {
                cnt += 1.0;
                avg += this.data.get(i).get(pi).getFunction().lastValue();
            }
            ++i;
        }
        avg = cnt > 0.0 ? (avg /= cnt) : Double.POSITIVE_INFINITY;
        this.data.get(0).get(pi).getFunction().addSample(time, avg);
    }

    public final boolean anyVisible() {
        if (this.numberOfAgents.isVisible()) {
            return true;
        }
        int i = 0;
        while (i < this.agents) {
            int j = 0;
            while (j < this.params) {
                if (this.data.get(i).get(j).isVisible()) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public final void saveAll(String filename) {
    }

    public class GraphEnumerator {
        private CollectedData cd;
        int ai;
        int pi;

        public GraphEnumerator(CollectedData cd) {
            this.cd = cd;
            this.pi = -1;
            this.ai = -1;
            this.nextValidPosition();
        }

        /*
         * Unable to fully structure code
         */
        private void nextValidPosition() {
            if (this.ai >= 0) ** GOTO lbl14
            if (this.cd.getCounts().isVisible()) {
                return;
            }
            this.pi = 0;
            this.ai = 0;
            ** GOTO lbl14
            {
                if (this.cd.get(this.ai, this.pi).isVisible()) {
                    return;
                }
                ++this.pi;
                do {
                    if (this.pi < this.cd.numParams()) continue block0;
                    this.pi = 0;
                    ++this.ai;
lbl14:
                    // 3 sources

                } while (this.ai < this.cd.numAgents());
            }
        }

        public final boolean hasMoreElements() {
            return this.ai < this.cd.numAgents();
        }

        public Graph nextElement() {
            Graph gr;
            if (this.ai < 0) {
                gr = this.cd.getCounts();
                this.pi = 0;
                this.ai = 0;
            } else {
                gr = this.cd.get(this.ai, this.pi);
                ++this.pi;
            }
            this.nextValidPosition();
            return gr;
        }
    }
}

