/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.comanalyzer;

import aglobe.agent.comanalyzer.DataContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class OptionsGUI
extends JDialog
implements ActionListener {
    private DataContainer dataContainer;
    private JTextField filter;
    private JTextField refreshTime;
    private JTextField fadingTime;
    private JTextField timeFrame;
    private JTextField msgCountSensitivity;
    private JTextField minLineWidth;
    private JTextField maxLineWidth;
    private JButton button;

    OptionsGUI(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 10, 10, 10);
        constraints.anchor = 17;
        constraints.gridy = 0;
        content.add((Component)new JLabel("Filter [regular expression]:"), constraints);
        this.filter = new JTextField(20);
        content.add((Component)this.filter, constraints);
        this.filter.setText(dataContainer.getRegularExpression());
        constraints.gridy = 1;
        content.add((Component)new JLabel("Refresh Time [ms]:"), constraints);
        this.refreshTime = new JTextField(5);
        content.add((Component)this.refreshTime, constraints);
        this.refreshTime.setText(Integer.toString(dataContainer.paramRefreshTime));
        constraints.gridy = 2;
        content.add((Component)new JLabel("Message Fading Time [ms]:"), constraints);
        this.fadingTime = new JTextField(5);
        content.add((Component)this.fadingTime, constraints);
        this.fadingTime.setText(Integer.toString(dataContainer.paramFadingTime));
        constraints.gridy = 3;
        content.add((Component)new JLabel("Message Time Frame [ms]:"), constraints);
        this.timeFrame = new JTextField(8);
        content.add((Component)this.timeFrame, constraints);
        this.timeFrame.setText(Integer.toString(dataContainer.paramTimeFrame));
        constraints.gridy = 4;
        content.add((Component)new JLabel("Message Count Sensitivity [%]:"), constraints);
        this.msgCountSensitivity = new JTextField(8);
        content.add((Component)this.msgCountSensitivity, constraints);
        this.msgCountSensitivity.setText(Integer.toString(Math.round(dataContainer.paramMsgCountSensitivity * 100.0f)));
        constraints.gridy = 5;
        content.add((Component)new JLabel("Message Line Min Width [pxs]:"), constraints);
        this.minLineWidth = new JTextField(8);
        content.add((Component)this.minLineWidth, constraints);
        this.minLineWidth.setText(Float.toString(dataContainer.paramMinLineWidth));
        constraints.gridy = 6;
        content.add((Component)new JLabel("Message Line Max Width [pxs]:"), constraints);
        this.maxLineWidth = new JTextField(8);
        content.add((Component)this.maxLineWidth, constraints);
        this.maxLineWidth.setText(Float.toString(dataContainer.paramMaxLineWidth));
        constraints.gridy = 7;
        constraints.gridx = 1;
        constraints.anchor = 13;
        this.button = new JButton("Apply");
        this.button.addActionListener(this);
        content.add((Component)this.button, constraints);
        this.setTitle("Options");
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.filter.getText().equals(this.dataContainer.getRegularExpression())) {
            try {
                this.dataContainer.setRegularExpression(this.filter.getText());
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(this, "Invalid filter format!", "Error", 0);
                return;
            }
        }
        try {
            this.dataContainer.paramRefreshTime = Integer.parseInt(this.refreshTime.getText());
            this.dataContainer.paramFadingTime = Integer.parseInt(this.fadingTime.getText());
            this.dataContainer.paramTimeFrame = Integer.parseInt(this.timeFrame.getText());
            this.dataContainer.paramMsgCountSensitivity = (float)Integer.parseInt(this.msgCountSensitivity.getText()) / 100.0f;
            this.dataContainer.paramMinLineWidth = Float.parseFloat(this.minLineWidth.getText());
            this.dataContainer.paramMaxLineWidth = Float.parseFloat(this.maxLineWidth.getText());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Invalid numeric format!", "Error", 0);
            return;
        }
        this.dataContainer.saveStore();
        this.dispose();
    }
}

