/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.comanalyzer;

import aglobe.agent.comanalyzer.ComAnalyzerAgent;
import aglobe.container.Store;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobe.platform.thread.AglobeThreadPool;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;

class DataContainer {
    private static final String STORE_FILTER = "param/filter";
    private static final String STORE_REFRESH_TIME = "param/refresh_time";
    private static final String STORE_FADING_TIME = "param/fading_time";
    private static final String STORE_TIME_FRAME = "param/time_frame";
    private static final String STORE_MSGCNT_SENS = "param/msgcnt_sens";
    private static final String STORE_LINE_MINWIDTH = "param/line_minwidth";
    private static final String STORE_LINE_MAXWIDTH = "param/line_maxwidth";
    private static final int AGENT_BOX_WIDTH = 120;
    private static final int AGENT_BOX_HEIGHT = 50;
    private static final int AGENT_BOX_BORDER = 5;
    private static final int PANEL_BORDER = 25;
    private static final int FONT_SIZE = 11;
    private static final Color COLOR_AGENT_FILL = new Color(255, 255, 128);
    private static final Color COLOR_SERVICE_FILL = new Color(128, 192, 255);
    private static final Stroke STROKE_WIDTH_1 = new BasicStroke(1.0f);
    private static final AlphaComposite ALPHA_COMPOSITE_OPAQUE = AlphaComposite.Src;
    int paramRefreshTime;
    int paramFadingTime;
    int paramTimeFrame;
    float paramMsgCountSensitivity;
    float paramMinLineWidth;
    float paramMaxLineWidth;
    ComAnalyzerAgent owner;
    Store store;
    private JPanel guiCanvas;
    private int guiOffsetX;
    private int guiOffsetY;
    private float guiScale;
    private float guiRadiusX;
    private float guiRadiusY;
    private int agentBoxWidth;
    private int agentBoxHeight;
    private int agentBoxBorder;
    private AgentInfo zoomedAgent;
    private Font fontDefault;
    private Font fontScaled;
    private FontMetrics fontMetricsDefault;
    private FontMetrics fontMetricsScaled;
    private long timeStamp;
    private String regexString;
    private Pattern regexPattern;
    private Map<String, Address> containerAddresses;
    private Map<Address, AgentInfo> agentInfos;
    private Vector<AgentInfo> visibleAgents;
    private Set<Address> invisibleAgents;
    private Map<Address, HashSet<Address>> agentsOnContainer;
    private DataMatrices dataMatrices;
    private LinkedList<MessageInfo> messages;

    DataContainer(ComAnalyzerAgent owner) {
        this.owner = owner;
        this.store = owner.getContainer().getAgentStore(owner.getName());
        this.guiCanvas = owner.getGUI().getCanvasPanel();
        this.guiOffsetX = 0;
        this.guiOffsetY = 0;
        this.guiScale = 1.0f;
        this.agentBoxWidth = Math.round(this.guiScale * 120.0f);
        this.agentBoxHeight = Math.round(this.guiScale * 50.0f);
        this.agentBoxBorder = Math.round(this.guiScale * 5.0f);
        this.fontDefault = new Font("Default", 0, 11);
        this.fontScaled = new Font("Default", 0, Math.round(this.guiScale * 11.0f));
        this.fontMetricsDefault = this.guiCanvas.getFontMetrics(this.fontDefault);
        this.fontMetricsScaled = this.guiCanvas.getFontMetrics(this.fontScaled);
        this.timeStamp = System.currentTimeMillis();
        this.init();
        this.loadStore();
        AglobeThreadPool.getThread(new TimeStamp(), "Time stamp thread").start();
        AglobeThreadPool.getThread(new Refresh(), "Refresh thread").start();
    }

    private synchronized void init() {
        this.containerAddresses = new HashMap<String, Address>();
        this.agentInfos = new HashMap<Address, AgentInfo>();
        this.visibleAgents = new Vector();
        this.invisibleAgents = new HashSet<Address>();
        this.agentsOnContainer = new HashMap<Address, HashSet<Address>>();
        this.dataMatrices = new DataMatrices();
        this.messages = new LinkedList();
        this.zoomedAgent = null;
        this.loginContainer(this.owner.getContainer().getContainerName(), this.owner.getAddress().deriveContainerAddress());
    }

    synchronized void loadStore() {
        this.regexString = this.store.getString(STORE_FILTER, ".*");
        this.regexPattern = Pattern.compile(this.regexString, 2);
        this.paramRefreshTime = this.store.getInt(STORE_REFRESH_TIME, 500);
        this.paramFadingTime = this.store.getInt(STORE_FADING_TIME, 4000);
        this.paramTimeFrame = this.store.getInt(STORE_TIME_FRAME, 10000);
        this.paramMsgCountSensitivity = (float)this.store.getDouble(STORE_MSGCNT_SENS, 0.1);
        this.paramMinLineWidth = (float)this.store.getDouble(STORE_LINE_MINWIDTH, 1.0);
        this.paramMaxLineWidth = (float)this.store.getDouble(STORE_LINE_MAXWIDTH, 5.0);
    }

    synchronized void saveStore() {
        this.store.putString(STORE_FILTER, this.regexString);
        this.store.putInt(STORE_REFRESH_TIME, this.paramRefreshTime);
        this.store.putInt(STORE_FADING_TIME, this.paramFadingTime);
        this.store.putInt(STORE_TIME_FRAME, this.paramTimeFrame);
        this.store.putDouble(STORE_MSGCNT_SENS, this.paramMsgCountSensitivity);
        this.store.putDouble(STORE_LINE_MINWIDTH, this.paramMinLineWidth);
        this.store.putDouble(STORE_LINE_MAXWIDTH, this.paramMaxLineWidth);
    }

    synchronized void loginContainer(String containerName, Address containerAddress) {
        this.containerAddresses.put(containerName, containerAddress);
        Set set = this.agentsOnContainer.get(containerAddress);
        if (set == null) {
            this.agentsOnContainer.put(containerAddress, new HashSet());
        } else {
            int maxStringWidthScaled = Math.round(this.guiScale * 110.0f);
            Vector containerNameWrappedScaled = this.wrapString(containerName, this.fontMetricsScaled, maxStringWidthScaled);
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                AgentInfo info = this.agentInfos.get(iter.next());
                info.containerNameWrappedScaled = containerNameWrappedScaled;
            }
            this.guiCanvas.repaint();
        }
    }

    synchronized void logoutContainer(String containerName) {
        Address containerAddress = this.containerAddresses.remove(containerName);
        if (containerAddress == null) {
            return;
        }
        Set set = this.agentsOnContainer.get(containerAddress);
        if (this.zoomedAgent != null && set.contains(this.zoomedAgent)) {
            this.zoomedAgent = null;
        }
        Iterator iter = this.messages.iterator();
        while (iter.hasNext()) {
            MessageInfo info = (MessageInfo)iter.next();
            if (!set.contains(info.senderAddress) && !set.contains(info.receiverAddress)) continue;
            iter.remove();
        }
        Iterator iter2 = set.iterator();
        while (iter2.hasNext()) {
            AgentInfo info = this.agentInfos.remove(iter2.next());
            if (info == null) continue;
            this.visibleAgents.remove(info);
        }
        this.agentsOnContainer.remove(containerAddress);
        this.dataMatrices.rebuildMatrices(this.visibleAgents);
        this.recalcAgentPositions();
        this.guiCanvas.repaint();
    }

    synchronized void incomingMessageCopy(Message m, boolean undeliverable) {
        Object info;
        Address senderAddress = m.getSender();
        Address senderContainerAddress = senderAddress.deriveContainerAddress();
        String senderContainerName = senderContainerAddress.getContainerName();
        boolean isSenderVisible = false;
        int senderMatrixIndex = -1;
        if (this.invisibleAgents.contains(senderAddress)) {
            isSenderVisible = false;
        } else {
            AgentInfo info2 = this.agentInfos.get(senderAddress);
            if (info2 == null) {
                Matcher regexMatcher = this.regexPattern.matcher(senderAddress.toString());
                if (regexMatcher.find()) {
                    senderMatrixIndex = this.dataMatrices.getSize();
                    info2 = new AgentInfo(senderAddress, senderContainerAddress, senderContainerName, senderMatrixIndex);
                    this.dataMatrices.extendMatrices();
                    ((DataMatrices)this.dataMatrices).agentInfoMatrix[senderMatrixIndex] = info2;
                    this.agentInfos.put(senderAddress, info2);
                    this.addAgentToGUI(info2);
                    HashSet<Address> set = this.agentsOnContainer.get(senderContainerAddress);
                    if (set == null) {
                        set = new HashSet();
                        this.agentsOnContainer.put(senderContainerAddress, set);
                    }
                    set.add(senderAddress);
                    isSenderVisible = true;
                } else {
                    this.invisibleAgents.add(senderAddress);
                    isSenderVisible = false;
                }
            } else {
                senderMatrixIndex = info2.matrixIndex;
                isSenderVisible = true;
            }
        }
        Address receiverAddress = m.getReceiver();
        Address receiverContainerAddress = receiverAddress.deriveContainerAddress();
        String receiverContainerName = receiverContainerAddress.getContainerName();
        boolean isReceiverVisible = false;
        int receiverMatrixIndex = -1;
        if (this.invisibleAgents.contains(receiverAddress)) {
            isReceiverVisible = false;
        } else {
            info = this.agentInfos.get(receiverAddress);
            if (info == null) {
                Matcher regexMatcher = this.regexPattern.matcher(receiverAddress.toString());
                if (regexMatcher.find()) {
                    receiverMatrixIndex = this.dataMatrices.getSize();
                    info = new AgentInfo(receiverAddress, receiverContainerAddress, receiverContainerName, receiverMatrixIndex);
                    this.dataMatrices.extendMatrices();
                    ((DataMatrices)this.dataMatrices).agentInfoMatrix[receiverMatrixIndex] = info;
                    this.agentInfos.put(receiverAddress, (AgentInfo)info);
                    this.addAgentToGUI((AgentInfo)info);
                    HashSet<Address> set = this.agentsOnContainer.get(receiverContainerAddress);
                    if (set == null) {
                        set = new HashSet();
                        this.agentsOnContainer.put(receiverContainerAddress, set);
                    }
                    set.add(receiverAddress);
                    isReceiverVisible = true;
                } else {
                    this.invisibleAgents.add(receiverAddress);
                    isReceiverVisible = false;
                }
            } else {
                receiverMatrixIndex = ((AgentInfo)info).matrixIndex;
                isReceiverVisible = true;
            }
        }
        if (!isSenderVisible || !isReceiverVisible) {
            return;
        }
        if (senderMatrixIndex > receiverMatrixIndex) {
            ((DataMatrices)this.dataMatrices).opacityMatrix[senderMatrixIndex][receiverMatrixIndex] = 1.0f;
            int[] nArray = this.dataMatrices.msgCountMatrix[senderMatrixIndex];
            int n = receiverMatrixIndex;
            nArray[n] = nArray[n] + 1;
        } else {
            ((DataMatrices)this.dataMatrices).opacityMatrix[receiverMatrixIndex][senderMatrixIndex] = 1.0f;
            int[] nArray = this.dataMatrices.msgCountMatrix[receiverMatrixIndex];
            int n = senderMatrixIndex;
            nArray[n] = nArray[n] + 1;
        }
        info = new MessageInfo(senderAddress, senderMatrixIndex, receiverAddress, receiverMatrixIndex, this.timeStamp);
        this.messages.addLast((MessageInfo)info);
        this.guiCanvas.repaint();
    }

    public synchronized void setGUIOffset(int x, int y, boolean doRepaint) {
        this.guiOffsetX = x;
        this.guiOffsetY = y;
        this.recalcAgentPositions();
        if (doRepaint) {
            this.guiCanvas.repaint();
        }
    }

    synchronized int getGUIOffsetX() {
        return this.guiOffsetX;
    }

    synchronized int getGUIOffsetY() {
        return this.guiOffsetY;
    }

    synchronized float getGUIScale() {
        return this.guiScale;
    }

    synchronized void setGUIScale(float guiScale, boolean doRepaint) {
        int fontSize;
        if ((double)guiScale < 0.05) {
            guiScale = 0.05f;
        }
        if ((double)guiScale > 10.0) {
            guiScale = 10.0f;
        }
        this.guiScale = guiScale;
        if (guiScale < 1.0f) {
            fontSize = Math.round(guiScale * 11.0f);
            this.agentBoxWidth = Math.round(guiScale * 120.0f);
            this.agentBoxHeight = Math.round(guiScale * 50.0f);
            this.agentBoxBorder = Math.round(guiScale * 5.0f);
        } else {
            fontSize = 11;
            this.agentBoxWidth = 120;
            this.agentBoxHeight = 50;
            this.agentBoxBorder = 5;
        }
        if (fontSize < 3) {
            this.fontScaled = null;
            this.fontMetricsScaled = null;
            int i = 0;
            while (i < this.visibleAgents.size()) {
                AgentInfo info = this.visibleAgents.get(i);
                info.agentNameWrappedScaled = null;
                info.containerNameWrappedScaled = null;
                ++i;
            }
        } else {
            this.fontScaled = new Font("Default", 0, fontSize);
            this.fontMetricsScaled = this.guiCanvas.getFontMetrics(this.fontScaled);
            int maxStringWidth = Math.round(guiScale * 110.0f);
            int i = 0;
            while (i < this.visibleAgents.size()) {
                AgentInfo info = this.visibleAgents.get(i);
                info.agentNameWrappedScaled = this.wrapString(info.agentName, this.fontMetricsScaled, maxStringWidth);
                info.containerNameWrappedScaled = this.wrapString(info.containerName, this.fontMetricsScaled, maxStringWidth);
                ++i;
            }
        }
        this.recalcAgentPositions();
        if (doRepaint) {
            this.guiCanvas.repaint();
        }
    }

    synchronized float getGUIRadiusX() {
        return this.guiRadiusX;
    }

    synchronized float getGUIRadiusY() {
        return this.guiRadiusY;
    }

    synchronized String getRegularExpression() {
        return this.regexString;
    }

    synchronized void setRegularExpression(String regularExpression) throws IllegalArgumentException {
        this.regexString = regularExpression;
        this.regexPattern = Pattern.compile(regularExpression, 2);
        this.init();
        this.guiCanvas.repaint();
    }

    synchronized void zoomAgent(int mouseX, int mouseY) {
        AgentInfo[] agentInfoMatrix = this.dataMatrices.agentInfoMatrix;
        int count = this.dataMatrices.getSize();
        int i = 0;
        while (i < count) {
            AgentInfo info = agentInfoMatrix[i];
            if (mouseX >= info.boxTopLeftX && mouseX <= info.boxTopLeftX + this.agentBoxWidth && mouseY >= info.boxTopLeftY && mouseY <= info.boxTopLeftY + this.agentBoxHeight) {
                if (info != this.zoomedAgent) {
                    this.zoomedAgent = info;
                    this.guiCanvas.repaint();
                }
                return;
            }
            ++i;
        }
        if (this.zoomedAgent != null) {
            this.zoomedAgent = null;
            this.guiCanvas.repaint();
        }
    }

    public synchronized void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.drawMessages(g2d);
        int count = this.visibleAgents.size();
        int i = 0;
        while (i < count) {
            this.drawAgent(g2d, this.visibleAgents.get(i));
            ++i;
        }
        if (this.zoomedAgent != null) {
            this.drawAgent(g2d, this.zoomedAgent);
        }
    }

    synchronized void recalcAgentPositions() {
        int panelWidthHalf = this.guiCanvas.getWidth() / 2;
        int panelHeightHalf = this.guiCanvas.getHeight() / 2;
        this.guiRadiusX = panelWidthHalf - 60 - 25;
        this.guiRadiusY = panelHeightHalf - 25 - 25;
        if (this.guiScale > 1.0f) {
            this.guiRadiusX *= this.guiScale;
            this.guiRadiusY *= this.guiScale;
        }
        int centerX = Math.round(this.guiScale * (float)this.guiOffsetX) + panelWidthHalf;
        int centerY = Math.round(this.guiScale * (float)this.guiOffsetY) + panelHeightHalf;
        int agentBoxWidthHalf = this.agentBoxWidth / 2;
        int agentBoxHeightHalf = this.agentBoxHeight / 2;
        int count = this.visibleAgents.size();
        double angleStep = Math.PI * 2 / (double)count;
        double angle = 0.0;
        int i = 0;
        while (i < count) {
            AgentInfo info = this.visibleAgents.get(i);
            info.boxCenterX = (int)Math.round((double)centerX + (double)this.guiRadiusX * Math.sin(angle));
            info.boxCenterY = (int)Math.round((double)centerY + (double)this.guiRadiusY * Math.cos(angle));
            info.boxTopLeftX = info.boxCenterX - agentBoxWidthHalf;
            info.boxTopLeftY = info.boxCenterY - agentBoxHeightHalf;
            angle += angleStep;
            ++i;
        }
    }

    private synchronized void addAgentToGUI(AgentInfo info) {
        int i = 0;
        while (i < this.visibleAgents.size()) {
            if (this.visibleAgents.get((int)i).containerAddress.equals(info)) {
                this.visibleAgents.add(i, info);
                this.recalcAgentPositions();
                return;
            }
            ++i;
        }
        this.visibleAgents.add(info);
        this.recalcAgentPositions();
    }

    private synchronized void decreaseOpacity() {
        AgentInfo[] agentInfoMatrix = this.dataMatrices.agentInfoMatrix;
        float[][] opacityMatrix = this.dataMatrices.opacityMatrix;
        int count = this.dataMatrices.getSize();
        int i = 0;
        while (i < count) {
            agentInfoMatrix[i].isActive = false;
            ++i;
        }
        float delta = (float)this.paramRefreshTime / (float)this.paramFadingTime;
        int i2 = 0;
        while (i2 < count) {
            int j = 0;
            while (j <= i2) {
                float[] fArray = opacityMatrix[i2];
                int n = j;
                float f = fArray[n] = fArray[n] - delta;
                if (f <= 0.0f) {
                    opacityMatrix[i2][j] = 0.0f;
                } else {
                    agentInfoMatrix[i2].isActive = true;
                    agentInfoMatrix[j].isActive = true;
                }
                ++j;
            }
            ++i2;
        }
    }

    private synchronized void removeOldMessages(long timeFrame) {
        while (!this.messages.isEmpty()) {
            MessageInfo msg = this.messages.getFirst();
            if (msg.timeStamp >= this.timeStamp - timeFrame) break;
            if (msg.senderMatrixIndex > msg.receiverMatrixIndex) {
                int[] nArray = this.dataMatrices.msgCountMatrix[msg.senderMatrixIndex];
                int n = msg.receiverMatrixIndex;
                nArray[n] = nArray[n] - 1;
            } else {
                int[] nArray = this.dataMatrices.msgCountMatrix[msg.receiverMatrixIndex];
                int n = msg.senderMatrixIndex;
                nArray[n] = nArray[n] - 1;
            }
            this.messages.removeFirst();
        }
    }

    private synchronized Vector wrapString(String string, FontMetrics fontMetrics, int maxWidth) {
        Vector<String> v = new Vector<String>();
        if (string == null || fontMetrics == null) {
            return v;
        }
        String remains = string;
        while (true) {
            if (fontMetrics.stringWidth(remains) <= maxWidth) {
                v.add(remains);
                return v;
            }
            int width = 0;
            int i = 0;
            while ((width += fontMetrics.charWidth(remains.charAt(i))) <= maxWidth) {
                ++i;
            }
            v.add(remains.substring(0, i));
            remains = "  " + remains.substring(i);
        }
    }

    private synchronized void drawAgent(Graphics2D g, AgentInfo info) {
        Vector agentNameWrapped;
        Vector containerNameWrapped;
        FontMetrics fontMetrics;
        Font font;
        int boxBorder;
        int boxHeight;
        int boxWidth;
        int y;
        int x;
        if (this.zoomedAgent == info) {
            x = info.boxCenterX - 60;
            y = info.boxCenterY - 25;
            boxWidth = 120;
            boxHeight = 50;
            boxBorder = 5;
            font = this.fontDefault;
            fontMetrics = this.fontMetricsDefault;
            containerNameWrapped = info.containerNameWrappedDefault;
            agentNameWrapped = info.agentNameWrappedDefault;
        } else {
            x = info.boxTopLeftX;
            y = info.boxTopLeftY;
            boxWidth = this.agentBoxWidth;
            boxHeight = this.agentBoxHeight;
            boxBorder = this.agentBoxBorder;
            font = this.fontScaled;
            fontMetrics = this.fontMetricsScaled;
            containerNameWrapped = info.containerNameWrappedScaled;
            agentNameWrapped = info.agentNameWrappedScaled;
        }
        g.setComposite(ALPHA_COMPOSITE_OPAQUE);
        if (info.isService) {
            g.setPaint(COLOR_SERVICE_FILL);
        } else {
            g.setPaint(COLOR_AGENT_FILL);
        }
        g.setStroke(STROKE_WIDTH_1);
        g.fillRect(x, y, boxWidth, boxHeight);
        g.setPaint(info.isActive ? Color.RED : Color.BLACK);
        g.drawRect(x, y, boxWidth, boxHeight);
        if (font != null) {
            g.setFont(font);
            g.setClip(x, y, boxWidth, boxHeight);
            x += boxBorder;
            y += boxBorder;
            int lineHeight = fontMetrics.getHeight();
            int i = 0;
            while (i < containerNameWrapped.size()) {
                g.drawString((String)containerNameWrapped.get(i), x, y += lineHeight);
                ++i;
            }
            i = 0;
            while (i < agentNameWrapped.size()) {
                g.drawString((String)agentNameWrapped.get(i), x, y += lineHeight);
                ++i;
            }
            g.setClip(null);
        }
    }

    private synchronized void drawMessages(Graphics2D g) {
        int count = this.visibleAgents.size();
        int row = 0;
        while (row < count) {
            int column = 0;
            while (column < row) {
                int msgCount;
                float alpha = this.dataMatrices.opacityMatrix[row][column];
                if (alpha > 0.0f && (msgCount = this.dataMatrices.msgCountMatrix[row][column]) > 0) {
                    float lineWidth;
                    AgentInfo infoRow = this.dataMatrices.agentInfoMatrix[row];
                    AgentInfo infoColumn = this.dataMatrices.agentInfoMatrix[column];
                    float color = (float)msgCount * this.paramMsgCountSensitivity;
                    if ((double)color > 1.0) {
                        color = 1.0f;
                    }
                    if ((lineWidth = color * this.paramMaxLineWidth) < this.paramMinLineWidth) {
                        lineWidth = this.paramMinLineWidth;
                    }
                    g.setPaint(new Color(color, 0.0f, 0.0f));
                    g.setStroke(new BasicStroke(lineWidth));
                    g.setComposite(AlphaComposite.getInstance(3, alpha));
                    g.drawLine(infoRow.boxCenterX, infoRow.boxCenterY, infoColumn.boxCenterX, infoColumn.boxCenterY);
                }
                ++column;
            }
            ++row;
        }
    }

    private class AgentInfo {
        boolean isService;
        Address agentAddress;
        String agentName;
        Vector agentNameWrappedDefault;
        Vector agentNameWrappedScaled;
        Address containerAddress;
        String containerName;
        Vector containerNameWrappedDefault;
        Vector containerNameWrappedScaled;
        int matrixIndex;
        boolean isActive;
        int boxTopLeftX;
        int boxTopLeftY;
        int boxCenterX;
        int boxCenterY;

        AgentInfo(Address agentAddress, Address containerAddress, String containerName, int matrixIndex) {
            int maxStringWidthDefault = 110;
            int maxStringWidthScaled = Math.round(DataContainer.this.guiScale * 110.0f);
            this.isService = agentAddress.isService();
            this.agentAddress = agentAddress;
            this.agentName = agentAddress.getName();
            this.agentNameWrappedDefault = DataContainer.this.wrapString(this.agentName, DataContainer.this.fontMetricsDefault, maxStringWidthDefault);
            this.agentNameWrappedScaled = DataContainer.this.wrapString(this.agentName, DataContainer.this.fontMetricsScaled, maxStringWidthScaled);
            this.containerAddress = containerAddress;
            this.containerName = containerName;
            this.containerNameWrappedDefault = DataContainer.this.wrapString(containerName, DataContainer.this.fontMetricsDefault, maxStringWidthDefault);
            this.containerNameWrappedScaled = DataContainer.this.wrapString(containerName, DataContainer.this.fontMetricsScaled, maxStringWidthScaled);
            this.matrixIndex = matrixIndex;
            this.isActive = false;
        }
    }

    private class MessageInfo {
        Address senderAddress;
        int senderMatrixIndex;
        Address receiverAddress;
        int receiverMatrixIndex;
        long timeStamp;

        MessageInfo(Address senderAddress, int senderMatrixIndex, Address receiverAddress, int receiverMatrixIndex, long timeStamp) {
            this.senderAddress = senderAddress;
            this.senderMatrixIndex = senderMatrixIndex;
            this.receiverAddress = receiverAddress;
            this.receiverMatrixIndex = receiverMatrixIndex;
            this.timeStamp = timeStamp;
        }
    }

    private class DataMatrices {
        private int matricesCapacity = 0;
        private int matricesSize = 0;
        private AgentInfo[] agentInfoMatrix = new AgentInfo[0];
        private float[][] opacityMatrix = new float[0][0];
        private int[][] msgCountMatrix = new int[0][0];

        private DataMatrices() {
        }

        private int getSize() {
            return this.matricesSize;
        }

        private void extendMatrices() {
            if (this.matricesSize + 1 > this.matricesCapacity) {
                this.matricesCapacity += 50;
                AgentInfo[] tmp1 = new AgentInfo[this.matricesCapacity];
                int i = 0;
                while (i < this.matricesSize) {
                    tmp1[i] = this.agentInfoMatrix[i];
                    ++i;
                }
                this.agentInfoMatrix = tmp1;
                float[][] tmp2 = new float[this.matricesCapacity][];
                int i2 = 0;
                while (i2 < this.matricesSize) {
                    tmp2[i2] = this.opacityMatrix[i2];
                    ++i2;
                }
                i2 = this.matricesSize;
                while (i2 < this.matricesCapacity) {
                    tmp2[i2] = new float[i2 + 1];
                    ++i2;
                }
                this.opacityMatrix = tmp2;
                int[][] tmp3 = new int[this.matricesCapacity][];
                int i3 = 0;
                while (i3 < this.matricesSize) {
                    tmp3[i3] = this.msgCountMatrix[i3];
                    ++i3;
                }
                i3 = this.matricesSize;
                while (i3 < this.matricesCapacity) {
                    tmp3[i3] = new int[i3 + 1];
                    ++i3;
                }
                this.msgCountMatrix = tmp3;
            }
            ++this.matricesSize;
        }

        private void rebuildMatrices(Vector visibleAgents) {
            int size = visibleAgents.size();
            int capacity = size + 50;
            AgentInfo[] tmp1 = new AgentInfo[capacity];
            float[][] tmp2 = new float[capacity][];
            int[][] tmp3 = new int[capacity][];
            int i = 0;
            while (i < capacity) {
                tmp2[i] = new float[i + 1];
                tmp3[i] = new int[i + 1];
                ++i;
            }
            int column = 0;
            while (column < size) {
                AgentInfo infoColumn;
                tmp1[column] = infoColumn = (AgentInfo)visibleAgents.get(column);
                int row = column;
                while (row < size) {
                    AgentInfo infoRow = (AgentInfo)visibleAgents.get(row);
                    if (infoRow.matrixIndex > infoColumn.matrixIndex) {
                        tmp2[row][column] = this.opacityMatrix[infoRow.matrixIndex][infoColumn.matrixIndex];
                        tmp3[row][column] = this.msgCountMatrix[infoRow.matrixIndex][infoColumn.matrixIndex];
                    } else {
                        tmp2[row][column] = this.opacityMatrix[infoColumn.matrixIndex][infoRow.matrixIndex];
                        tmp3[row][column] = this.msgCountMatrix[infoColumn.matrixIndex][infoRow.matrixIndex];
                    }
                    ++row;
                }
                infoColumn.matrixIndex = column++;
            }
            this.matricesSize = size;
            this.matricesCapacity = capacity;
            this.agentInfoMatrix = tmp1;
            this.opacityMatrix = tmp2;
            this.msgCountMatrix = tmp3;
        }
    }

    private class TimeStamp
    implements Runnable {
        private TimeStamp() {
        }

        public void run() {
            while (true) {
                DataContainer.this.timeStamp = System.currentTimeMillis();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private class Refresh
    implements Runnable {
        private Refresh() {
        }

        public void run() {
            while (true) {
                DataContainer.this.decreaseOpacity();
                DataContainer.this.removeOldMessages(DataContainer.this.paramTimeFrame);
                DataContainer.this.guiCanvas.repaint();
                try {
                    Thread.sleep(DataContainer.this.paramRefreshTime);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

