/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.comanalyzer;

import aglobe.agent.comanalyzer.AboutGUI;
import aglobe.agent.comanalyzer.ComAnalyzerAgent;
import aglobe.agent.comanalyzer.DataContainer;
import aglobe.agent.comanalyzer.OptionsGUI;
import aglobe.util.gui.RememberPositionJFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

class ComAnalyzerAgentGUI
extends RememberPositionJFrame
implements ActionListener {
    private ComAnalyzerAgent owner;
    private DataContainer dataContainer;
    private JPanel canvasPanel;
    private int mousePosX;
    private int mousePosY;
    private float dragAnchorAbsX;
    private float dragAnchorAbsY;
    private float dragAnchorRelX;
    private float dragAnchorRelY;

    ComAnalyzerAgentGUI(ComAnalyzerAgent owner) {
        super(owner);
        this.owner = owner;
        this.setTitle("Communication Analyzer");
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu("File");
        menuBar.add(menuFile);
        JMenuItem menuItem = new JMenuItem("Options");
        menuItem.setActionCommand("MenuFileOptions");
        menuItem.addActionListener(this);
        menuFile.add(menuItem);
        menuFile.addSeparator();
        menuItem = new JMenuItem("Close");
        menuItem.setActionCommand("MenuFileClose");
        menuItem.addActionListener(this);
        menuFile.add(menuItem);
        JMenu menuHelp = new JMenu("Help");
        menuBar.add(menuHelp);
        menuItem = new JMenuItem("About");
        menuItem.setActionCommand("MenuHelpAbout");
        menuItem.addActionListener(this);
        menuHelp.add(menuItem);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.canvasPanel = new CanvasPanel();
        content.add((Component)this.canvasPanel, "Center");
        this.addWindowListener(new MyWindowAdapter(owner));
        this.setSize(512, 512);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("MenuFileOptions")) {
            if (this.dataContainer != null) {
                new OptionsGUI(this.dataContainer);
            }
            return;
        }
        if (e.getActionCommand().equals("MenuFileClose")) {
            this.owner.killSelf();
            return;
        }
        if (e.getActionCommand().equals("MenuHelpAbout")) {
            new AboutGUI();
            return;
        }
    }

    JPanel getCanvasPanel() {
        return this.canvasPanel;
    }

    void setDataContainer(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    private class CanvasPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private CanvasPanel() {
            this.setBackground(new Color(0.8f, 0.8f, 0.8f));
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    if (ComAnalyzerAgentGUI.this.dataContainer != null) {
                        ComAnalyzerAgentGUI.this.dataContainer.recalcAgentPositions();
                    }
                }
            });
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ComAnalyzerAgentGUI.this.dataContainer != null) {
                ComAnalyzerAgentGUI.this.dataContainer.draw(g);
            }
        }

        public void mousePressed(MouseEvent e) {
            int n = e.getX();
            ComAnalyzerAgentGUI.this.mousePosX = n;
            ComAnalyzerAgentGUI.this.dragAnchorAbsX = n;
            int n2 = e.getY();
            ComAnalyzerAgentGUI.this.mousePosY = n2;
            ComAnalyzerAgentGUI.this.dragAnchorAbsY = n2;
            float guiScale = ComAnalyzerAgentGUI.this.dataContainer.getGUIScale();
            ComAnalyzerAgentGUI.this.dragAnchorRelX = ((float)(ComAnalyzerAgentGUI.this.mousePosX - this.getWidth() / 2) - (float)ComAnalyzerAgentGUI.this.dataContainer.getGUIOffsetX() * guiScale) / ComAnalyzerAgentGUI.this.dataContainer.getGUIRadiusX();
            ComAnalyzerAgentGUI.this.dragAnchorRelY = ((float)(ComAnalyzerAgentGUI.this.mousePosY - this.getHeight() / 2) - (float)ComAnalyzerAgentGUI.this.dataContainer.getGUIOffsetY() * guiScale) / ComAnalyzerAgentGUI.this.dataContainer.getGUIRadiusY();
        }

        public void mouseDragged(MouseEvent e) {
            boolean buttonRight;
            int x = e.getX();
            int y = e.getY();
            int deltaX = x - ComAnalyzerAgentGUI.this.mousePosX;
            int deltaY = y - ComAnalyzerAgentGUI.this.mousePosY;
            ComAnalyzerAgentGUI.this.mousePosX = x;
            ComAnalyzerAgentGUI.this.mousePosY = y;
            float guiScale = ComAnalyzerAgentGUI.this.dataContainer.getGUIScale();
            boolean buttonLeft = (e.getModifiers() & 0x10) == 16;
            boolean bl = buttonRight = (e.getModifiers() & 4) == 4;
            if (buttonLeft) {
                int guiOffsetX = Math.round((float)ComAnalyzerAgentGUI.this.dataContainer.getGUIOffsetX() + (float)deltaX / guiScale);
                int guiOffsetY = Math.round((float)ComAnalyzerAgentGUI.this.dataContainer.getGUIOffsetY() + (float)deltaY / guiScale);
                ComAnalyzerAgentGUI.this.dataContainer.setGUIOffset(guiOffsetX, guiOffsetY, true);
            }
            if (buttonRight) {
                float k = 1.0f + (float)Math.abs(deltaY) / 20.0f;
                guiScale = deltaY < 0 ? (guiScale *= k) : (guiScale /= k);
                ComAnalyzerAgentGUI.this.dataContainer.setGUIScale(guiScale, false);
                int guiOffsetX = Math.round((ComAnalyzerAgentGUI.this.dragAnchorAbsX - (float)(this.getWidth() / 2) - ComAnalyzerAgentGUI.this.dragAnchorRelX * ComAnalyzerAgentGUI.this.dataContainer.getGUIRadiusX()) / guiScale);
                int guiOffsetY = Math.round((ComAnalyzerAgentGUI.this.dragAnchorAbsY - (float)(this.getHeight() / 2) - ComAnalyzerAgentGUI.this.dragAnchorRelY * ComAnalyzerAgentGUI.this.dataContainer.getGUIRadiusY()) / guiScale);
                ComAnalyzerAgentGUI.this.dataContainer.setGUIOffset(guiOffsetX, guiOffsetY, true);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (ComAnalyzerAgentGUI.this.dataContainer != null) {
                ComAnalyzerAgentGUI.this.dataContainer.zoomAgent(e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class MyWindowAdapter
    extends WindowAdapter {
        private ComAnalyzerAgent owner;

        MyWindowAdapter(ComAnalyzerAgent owner) {
            this.owner = owner;
        }

        public void windowClosing(WindowEvent e) {
            this.owner.killSelf();
        }
    }
}

