/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.comanalyzer;

import aglobe.agent.comanalyzer.ComAnalyzerAgentGUI;
import aglobe.agent.comanalyzer.DataContainer;
import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.service.link.LinkMessageCopyListener;
import aglobe.service.link.LinkNeighbourListener;
import aglobe.service.link.LinkService;
import javax.swing.SwingUtilities;

public class ComAnalyzerAgent
extends Agent
implements GISTopicServerListener {
    public ComAnalyzerAgentGUI gui;
    private DataContainer dataContainer;
    private GISServerService.Shell gisServer = null;
    private LinkService.Shell link = null;

    public void init(AgentInfo a, int initState) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ComAnalyzerAgent.this.gui = new ComAnalyzerAgentGUI(ComAnalyzerAgent.this);
                }
            });
        }
        catch (Exception ex) {
            this.logSevere("Cannot create gui due to: " + ex + "\nComAnalyzer will be stopped.");
            this.stop();
            return;
        }
        this.dataContainer = new DataContainer(this);
        this.gui.setDataContainer(this.dataContainer);
        if (this.gisServer == null) {
            this.gisServer = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
            if (this.gisServer == null) {
                this.link = (LinkService.Shell)this.getContainer().getServiceManager().getService(this, "container/link");
                if (this.link == null) {
                    this.logSevere("GISServerService not running");
                    this.stop();
                    return;
                }
                this.link.subscribeNeighbour(new LinkNeighbourListener(){

                    public void handleRegister(Address containerAddress) {
                        ComAnalyzerAgent.this.loginContainer(containerAddress.getContainerName(), containerAddress);
                    }

                    public void handleDeregister(Address containerAddress) {
                        ComAnalyzerAgent.this.logoutContainer(containerAddress.getContainerName());
                    }

                    public void addEvent(Runnable e) {
                        ComAnalyzerAgent.this.addEvent(e);
                    }
                });
                this.link.subsribeMessageCopy(new LinkMessageCopyListener(){

                    public void handleMessageCopy(byte[] serializedMessage, String undeliverable) {
                        try {
                            Message m = Message.getMessageFormBinarySerializedData(serializedMessage, ComAnalyzerAgent.this);
                            ComAnalyzerAgent.this.incomingMessageCopy(m, Boolean.valueOf(undeliverable));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void addEvent(Runnable e) {
                        ComAnalyzerAgent.this.addEvent(e);
                    }
                });
            }
        } else {
            this.gisServer.subscribeTopic("VISIBILITY_UPDATES", this);
            this.gisServer.subscribeTopic("OUTGOING_MESSAGE_COPY", this);
        }
    }

    void killSelf() {
        this.kill();
    }

    ComAnalyzerAgentGUI getGUI() {
        return this.gui;
    }

    private void loginContainer(String containerName, Address containerAddress) {
        this.dataContainer.loginContainer(containerName, containerAddress);
    }

    private void logoutContainer(String containerName) {
        this.dataContainer.logoutContainer(containerName);
    }

    private void incomingMessageCopy(Message m, boolean undeliverable) {
        if (!undeliverable) {
            if (m.isMulticast()) {
                this.logWarning("Multicast message are not supported yet");
            } else {
                this.dataContainer.incomingMessageCopy(m, undeliverable);
            }
        }
    }

    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
        if (topic.equals("VISIBILITY_UPDATES")) {
            Address rAdr = remoteContainerAddress;
            if (rAdr == null) {
                rAdr = this.getAddress().deriveContainerAddress();
            }
            this.loginContainer(remoteContainerName, rAdr);
        }
    }

    public void handleLogoutTopic(String topic, String remoteContainerName) {
        if (topic.equals("VISIBILITY_UPDATES")) {
            this.logoutContainer(remoteContainerName);
        }
    }

    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals("OUTGOING_MESSAGE_COPY")) {
            try {
                Message m = Message.getMessageFormBinarySerializedData((byte[])content, this);
                this.incomingMessageCopy(m, Boolean.valueOf(reason));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.logWarning("Problem with getting message copy: " + ex + "\nOriginal content: " + (String)content);
            }
        }
    }

    protected void handleIncomingMessage(Message m) {
        this.logSevere("Unexpected message: " + m.toString());
        m.release();
    }
}

