/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.data.Batch;
import across.data.CoalitionDescription;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import across.data.TeamProposal;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.visio.VisualAgent;
import across.visio.ont.AllianceDescription;
import across.visio.ont.CPlantAgentDescription;
import across.visio.ont.DFAgentDescription;
import across.visio.visual.AllianceTreeModel;
import across.visio.visual.ColorFactory;
import across.visio.visual.Screen;
import across.visio.visual.TaskTreeModel;
import across.visio.visual.VisAgent;
import across.visio.visual.VisAlliance;
import across.visio.visual.VisCoalition;
import across.visio.visual.VisData;
import across.visio.visual.VisTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Visualizer {
    VisualAgent _owner;
    private Screen _screen;
    public List _agents;
    private List _alliances;
    private List _tasks;
    private List _coalitions;
    private AllianceTreeModel _atm;
    private TaskTreeModel _ttm;
    private TaskTreeModel _ctm;
    private ColorFactory _cf;

    public Visualizer(VisualAgent owner) {
        this._owner = owner;
        this._agents = new LinkedList();
        this._alliances = new LinkedList();
        this._tasks = new LinkedList();
        this._coalitions = new LinkedList();
        this._atm = new AllianceTreeModel(this._agents, this._alliances);
        this._ttm = new TaskTreeModel(this._tasks);
        this._ctm = new TaskTreeModel(this._coalitions);
        this._cf = ColorFactory.getDefaultFactory();
        this._screen = new Screen(this, this._atm, this._ttm, this._ctm);
        this._screen.setVisible(true);
    }

    public Screen getScreen() {
        return this._screen;
    }

    public void quit() {
        this._owner.quit();
    }

    public void shutdown() {
        this._screen.dispose();
        this._screen = null;
    }

    public void setVisibility(String name, boolean visible) {
        for (VisAgent va : this._agents) {
            if (!va.getName().equals(name)) continue;
            va.setVisibility(visible);
            this._atm.fireTreeChange();
            return;
        }
    }

    public void registerAgent(DFAgentDescription dfad, CPlantAgentDescription cpad) {
        for (VisAgent va : this._agents) {
            if (!va.getName().equals(dfad.getName())) continue;
            va.dfAD.setOwner(dfad.getOwner());
            va.dfAD.setType(dfad.getType());
            va.cpAD.setCity(cpad.getCity());
            va.cpAD.setCountry(cpad.getCountry());
            this._atm.fireTreeChange();
            return;
        }
        Visualizer vi = this;
        this._agents.add(new VisAgent(dfad, cpad, this._agents, vi));
    }

    public void deregisterAgent(DFAgentDescription dfad) {
        int i = this._agents.indexOf(new VisAgent.Comparator(dfad.getName()));
        if (i != -1) {
            VisAgent a = (VisAgent)this._agents.get(i);
            this._agents.remove(i);
            a.deregister();
            this._atm.fireTreeChange();
            this._ttm.fireTreeChange();
        }
    }

    public void newAlliance(AllianceDescription ad) {
        List members = ad.getMembers();
        LinkedList<VisAgent> toadd = new LinkedList<VisAgent>();
        VisAlliance cural = null;
        Object alName = null;
        for (String name : ad.getMembers()) {
            int i = this._agents.indexOf(new VisAgent.Comparator(name));
            if (i == -1) {
                System.out.println("Unknown agent in alliance! - " + name + this._agents.toString());
                DFAgentDescription dfd = new DFAgentDescription(name, "unknown", "unknown owner");
                CPlantAgentDescription cad = new CPlantAgentDescription(name, "no city", "no country");
                this.registerAgent(dfd, cad);
                continue;
            }
            VisAgent agent = (VisAgent)this._agents.get(i);
            VisAlliance alliance = agent.getAlliance();
            alliance = null;
            if (alliance == null) {
                toadd.add(agent);
                continue;
            }
            if (cural == null) {
                cural = alliance;
                continue;
            }
            if (alliance == cural) continue;
            toadd.add(agent);
        }
        if (cural == null) {
            cural = new VisAlliance(this, this._screen.getDesktop(), ad.getName());
        }
        cural.addMembers(toadd);
        if (!this._alliances.contains(cural)) {
            this._alliances.add(cural);
            this._screen.autoArrangeAlliances();
        }
        this._atm.fireTreeChange();
        this._ttm.fireTreeChange();
    }

    public boolean newCoalition(CoalitionDescription cd, String locationInitiatorName, String id, String initiator) {
        VisTask task;
        List childs;
        boolean ok = false;
        int position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf(locationInitiatorName) + ": " + id));
        if (position > -1 && (position = (childs = (task = (VisTask)this._tasks.get(position)).getChildren()).indexOf(new VisData.Comparator(initiator))) > -1) {
            VisData locationInitiator = (VisData)childs.get(position);
            boolean added = false;
            for (VisTask vt : this._coalitions) {
                VisCoalition vc;
                if (!(vt.getName().contains(id) & vt.getName().contains(initiator))) continue;
                if (!vt.getName().contains("Transporter")) {
                    vc = (VisCoalition)vt.getCoalitions().get(0);
                    List<String> newAgents = cd.getCoalitionMember();
                    Iterator<String> j = newAgents.iterator();
                    while (j.hasNext()) {
                        vc.addAgentToCoalition(j.next());
                    }
                    if (!newAgents.contains(cd.getCoalitionLeader())) {
                        vc.addAgentToCoalition(cd.getCoalitionLeader());
                    }
                    this.setDisplayTask(vt);
                    added = true;
                    ok = true;
                    continue;
                }
                vc = (VisCoalition)vt.getCoalitions().get(0);
                String[] subparticipants = vc.removeAllParticipants();
                int j = 0;
                while (j < subparticipants.length) {
                    cd.getCoalitionMember().add(subparticipants[j]);
                    ++j;
                }
                vc.insertParticipants(cd.getCoalitionLeader(), cd.getCoalitionMember(), this._agents);
                vt.setName(cd.getTaskName());
                this.setDisplayTask(vt);
                added = true;
                ok = true;
            }
            if (!added) {
                VisTask coalition = new VisTask(this._agents, cd);
                locationInitiator.addChild(coalition);
                this._ttm.fireNodeInserted(new Object[]{task, locationInitiator}, new int[]{locationInitiator.getChildCount() - 1});
                ok = true;
                this._coalitions.add(coalition);
                this.setDisplayTask(coalition);
                this._ctm.fireNodeInserted(null, new int[]{this._coalitions.size() - 1});
            }
        }
        if (!ok) {
            System.out.println("coalition wasn't added");
        }
        return ok;
    }

    public void newLocCFPRequest(RequestList requestList, Collection participants, String name) {
        VisTask t = new VisTask(this._agents, requestList, participants, name);
        this._tasks.add(t);
        this._ttm.fireNodeInserted(null, new int[]{this._tasks.size() - 1});
    }

    public void addTransporLeaderProposal(Proposal prop, String proposer, TransportCfp cfp, Map batchesById, Map locationNames, Map locationBatches, Proposal myProposal, TeamProposal teamProposal) {
        String locationName = (String)locationNames.get(Visualizer.parseId(prop.getRequestid(), 0));
        String locationInitiator = Visualizer.parseId(prop.getRequestid(), 1);
        int position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf(locationName) + ": " + Visualizer.parseId(prop.getRequestid(), 0)));
        if (position > -1) {
            VisTask task = (VisTask)this._tasks.get(position);
            List childs = task.getChildren();
            if ((position = childs.indexOf(new VisData.Comparator(locationInitiator))) > -1) {
                List requested;
                String itemName;
                VisData leader;
                VisData transport;
                VisData location = (VisData)childs.get(position);
                if ((position = (childs = location.getChildren()).indexOf(new VisData.Comparator("Transport"))) > -1) {
                    transport = (VisData)childs.get(position);
                } else {
                    transport = new VisData("Transport", 19);
                    location.addChild(transport);
                    this._ttm.fireNodeInserted(new Object[]{task, location}, new int[]{location.getChildCount() - 1});
                }
                childs = transport.getChildren();
                position = childs.indexOf(new VisData.Comparator(String.valueOf(proposer) + " from " + locationInitiator));
                if (position < 0) {
                    leader = new VisData(String.valueOf(proposer) + " from " + locationInitiator, 7);
                    transport.addChild(leader);
                    this._ttm.fireNodeInserted(new Object[]{task, location, transport}, new int[]{transport.getChildCount() - 1});
                } else {
                    leader = (VisData)childs.get(position);
                }
                VisData proposerAgent = new VisData(proposer, 4);
                leader.addChild(proposerAgent);
                this._ttm.fireNodeInserted(new Object[]{task, location, transport, leader}, new int[]{leader.getChildCount() - 1});
                double cov = 0.0;
                boolean ok = false;
                boolean match = false;
                if (myProposal != null) {
                    for (ItemCoverage ic : myProposal.getItemCoverage()) {
                        itemName = "";
                        block1: for (TransportBatch tb : teamProposal.getRequestedServices().getTransportBatch()) {
                            if (tb.getBatchid() != ic.getItemid()) continue;
                            match = true;
                            itemName = tb.getComodityName();
                            requested = (List)locationBatches.get(Visualizer.parseId(myProposal.getRequestid(), 0));
                            for (Batch b : requested) {
                                if (!b.getComodityName().equalsIgnoreCase(itemName)) continue;
                                cov = (double)tb.getCount() * ic.getCoverage() / (double)b.getCount();
                                ok = true;
                                break block1;
                            }
                        }
                        VisData item = new VisData(String.valueOf(itemName) + " " + (int)(cov * 100.0) + " %", 24);
                        if (!ok) continue;
                        item.setProgress((int)(cov * 100.0));
                        proposerAgent.addChild(item);
                        this._ttm.fireNodeInserted(new Object[]{task, location, transport, leader, proposerAgent}, new int[]{proposerAgent.getChildCount() - 1});
                    }
                }
                ok = false;
                for (ItemCoverage ic : prop.getItemCoverage()) {
                    itemName = "";
                    block4: for (TransportBatch tb : teamProposal.getTransportCfp().getTransportBatch()) {
                        if (tb.getBatchid() != ic.getItemid()) continue;
                        itemName = tb.getComodityName();
                        requested = (List)locationBatches.get(Visualizer.parseId(cfp.getRequestid(), 0));
                        for (Batch b : requested) {
                            if (!b.getComodityName().equalsIgnoreCase(itemName)) continue;
                            cov = ic.getCoverage() * (double)tb.getCount() / (double)b.getCount();
                            ok = true;
                            break block4;
                        }
                    }
                    if (ok) {
                        VisData newItem = new VisData(String.valueOf(itemName) + " " + (int)(cov * 100.0) + "%", 24);
                        newItem.setProgress((int)(cov * 100.0));
                        leader.addChild(newItem);
                        this._ttm.fireNodeInserted(new Object[]{task, location, transport, leader}, new int[]{leader.getChildCount() - 1});
                    }
                    if (ok) continue;
                    System.out.println("no set error");
                }
            } else {
                System.out.println("no location error");
            }
        } else {
            System.out.println("no task error");
        }
    }

    public void addTransportLeaderSubcontractProposal(Proposal prop, String proposer, String transporterInitiator, TransportCfp cfp, Map batchesById, Map locationNames, Map locationBatches, Proposal myProposal, TeamProposal teamProposal) {
        if (myProposal != null) {
            String locationName = (String)locationNames.get(Visualizer.parseId(myProposal.getRequestid(), 0));
            int position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf(locationName) + ": " + Visualizer.parseId(myProposal.getRequestid(), 0)));
            if (position > -1) {
                VisTask task = (VisTask)this._tasks.get(position);
                List childs = task.getChildren();
                if ((position = childs.indexOf(new VisData.Comparator(Visualizer.parseId(myProposal.getRequestid(), 1)))) > -1) {
                    List requested;
                    String itemName;
                    VisData subLeader;
                    VisData subContract;
                    VisData leader;
                    VisData transport;
                    VisData location = (VisData)childs.get(position);
                    if ((position = (childs = location.getChildren()).indexOf(new VisData.Comparator("Transport"))) > -1) {
                        transport = (VisData)childs.get(position);
                    } else {
                        transport = new VisData("Transport", 19);
                        location.addChild(transport);
                        this._ttm.fireNodeInserted(new Object[]{task, location}, new int[]{location.getChildCount() - 1});
                    }
                    childs = transport.getChildren();
                    position = childs.indexOf(new VisData.Comparator(String.valueOf(transporterInitiator) + " from " + Visualizer.parseId(myProposal.getRequestid(), 1)));
                    if (position < 0) {
                        leader = new VisData(String.valueOf(transporterInitiator) + " from " + Visualizer.parseId(myProposal.getRequestid(), 1), 7);
                        transport.addChild(leader);
                        this._ttm.fireNodeInserted(new Object[]{task, location, transport}, new int[]{transport.getChildCount() - 1});
                    } else {
                        leader = (VisData)childs.get(position);
                        this._ttm.fireNodeChanged(new Object[]{task, location, transport}, leader);
                    }
                    childs = leader.getChildren();
                    position = childs.indexOf(new VisData.Comparator("subcontract"));
                    if (position < 0) {
                        subContract = new VisData("subcontract", 24);
                        leader.addChild(subContract);
                        this._ttm.fireNodeInserted(new Object[]{task, location, transport, leader}, new int[]{leader.getChildCount() - 1});
                    } else {
                        subContract = (VisData)childs.get(position);
                    }
                    childs = subContract.getChildren();
                    position = childs.indexOf(new VisData.Comparator(proposer));
                    if (position < 0) {
                        subLeader = new VisData(proposer, 7);
                        subContract.addChild(subLeader);
                        this._ttm.fireNodeInserted(new Object[]{task, location, transport, leader, subContract}, new int[]{subContract.getChildCount() - 1});
                    } else {
                        subLeader = (VisData)childs.get(position);
                    }
                    VisData subLeaderProposal = new VisData(proposer, 4);
                    subLeader.addChild(subLeaderProposal);
                    this._ttm.fireNodeInserted(new Object[]{task, location, transport, leader, subContract, subLeader}, new int[]{subLeader.getChildCount() - 1});
                    double cov = 0.0;
                    boolean ok = false;
                    for (ItemCoverage ic : myProposal.getItemCoverage()) {
                        itemName = "";
                        block1: for (TransportBatch tb : teamProposal.getRequestedServices().getTransportBatch()) {
                            if (tb.getBatchid() != ic.getItemid()) continue;
                            itemName = tb.getComodityName();
                            requested = (List)locationBatches.get(Visualizer.parseId(myProposal.getRequestid(), 0));
                            for (Batch b : requested) {
                                if (!b.getComodityName().equalsIgnoreCase(itemName)) continue;
                                cov = (double)tb.getCount() * ic.getCoverage() / (double)b.getCount();
                                ok = true;
                                break block1;
                            }
                        }
                        VisData item = new VisData(String.valueOf(itemName) + " " + (int)(cov * 100.0) + " %", 24);
                        if (!ok) continue;
                        item.setProgress((int)(cov * 100.0));
                        subLeaderProposal.addChild(item);
                        this._ttm.fireNodeInserted(new Object[]{task, location, transport, leader, subContract, subLeaderProposal}, new int[]{subLeaderProposal.getChildCount() - 1});
                    }
                    for (ItemCoverage ic : prop.getItemCoverage()) {
                        itemName = "";
                        block4: for (TransportBatch tb : teamProposal.getTransportCfp().getTransportBatch()) {
                            if (tb.getBatchid() != ic.getItemid()) continue;
                            itemName = tb.getComodityName();
                            requested = (List)locationBatches.get(cfp.getRequestid());
                            for (Batch b : requested) {
                                if (!b.getComodityName().equalsIgnoreCase(itemName)) continue;
                                cov = ic.getCoverage() * (double)tb.getCount() / (double)b.getCount();
                                ok = true;
                                break block4;
                            }
                        }
                        VisData newItem = new VisData(String.valueOf(itemName) + " " + (int)(cov * 100.0) + "%", 24);
                        newItem.setProgress((int)(cov * 100.0));
                        if (!ok) {
                            System.out.println("no set error");
                        }
                        subLeader.addChild(newItem);
                        this._ttm.fireNodeInserted(new Object[]{task, location, transport, leader, subContract, subLeader}, new int[]{subLeader.getChildCount() - 1});
                    }
                } else {
                    System.out.println("no location error");
                }
            } else {
                System.out.println("no task error");
            }
        }
    }

    public void newLocationOffer(Proposal proposal, String locationName, Map batchesById, String initiator) {
        int position = -1;
        position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf(initiator) + ": " + proposal.getRequestid()));
        if (position < 0) {
            System.out.println("error");
        } else {
            VisTask t = (VisTask)this._tasks.get(position);
            int oldChildCount = t.getChildCount();
            t.addLocationProposal(proposal, locationName, batchesById);
            int newChilds = t.getChildCount() - oldChildCount;
            int[] indicates = new int[newChilds];
            int i = 0;
            while (i < newChilds) {
                indicates[i] = oldChildCount + i;
                ++i;
            }
            this._ttm.fireNodeInserted(new Object[]{t}, indicates);
        }
    }

    public boolean bestLocationOffer(String locationName, Proposal bestProposal, String initiator) {
        int position = -1;
        position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf(initiator) + ": " + bestProposal.getRequestid()));
        if (position < 0) {
            return false;
        }
        VisTask t = (VisTask)this._tasks.get(position);
        List childs = t.getChildren();
        if ((position = childs.indexOf(new VisData.Comparator(locationName))) < 0) {
            return false;
        }
        VisData vd = (VisData)childs.get(position);
        vd.setType(18);
        return true;
    }

    public void locationRefused(String name, String requestId, String initiator) {
        int position = -1;
        position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf(initiator) + ": " + requestId));
        if (position > -1) {
            VisTask t = (VisTask)this._tasks.get(position);
            t.addRefusedLocation(name);
            this._ttm.fireNodeInserted(new Object[]{t}, new int[]{t.getChildCount() - 1});
        }
    }

    public void acceptationReceived(String name, String requestId, String initiator) {
        int position = -1;
        if (position > -1) {
            position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf(initiator) + ": " + requestId));
            VisTask t = (VisTask)this._tasks.get(position);
            t.addLocationReceivedAcceptation(name);
            this._ttm.fireNodeInserted(new Object[]{t}, new int[]{t.getChildCount() - 1});
        }
    }

    public void addTeamMemberSubcontractProposal(Proposal p, String proposer, String transporterInitiator, TeamProposal tp, Map locationNames, Map locationBatches) {
        if (p != null) {
            int position = -1;
            position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf((String)locationNames.get(Visualizer.parseId(tp.getTransportCfp().getRequestid(), 0))) + ": " + Visualizer.parseId(tp.getTransportCfp().getRequestid(), 0)));
            if (position > -1) {
                VisTask t = (VisTask)this._tasks.get(position);
                List childs = t.getChildren();
                if ((position = childs.indexOf(new VisData.Comparator(Visualizer.parseId(p.getRequestid(), 1)))) > -1) {
                    VisData proposerAgent;
                    VisData subLeader;
                    VisData subContract;
                    VisData leader;
                    VisData transport;
                    VisData location = (VisData)childs.get(position);
                    if ((position = (childs = location.getChildren()).indexOf(new VisData.Comparator("Transport"))) > -1) {
                        transport = (VisData)childs.get(position);
                        childs = transport.getChildren();
                    } else {
                        transport = new VisData("Transport", 19);
                        location.addChild(transport);
                        this._ttm.fireNodeInserted(new Object[]{t, location}, new int[]{location.getChildCount() - 1});
                    }
                    List transportChilds = transport.getChildren();
                    position = transportChilds.indexOf(new VisData.Comparator(String.valueOf(transporterInitiator) + " from " + Visualizer.parseId(p.getRequestid(), 1)));
                    if (position < 0) {
                        leader = new VisData(String.valueOf(transporterInitiator) + " from " + Visualizer.parseId(p.getRequestid(), 1), 7);
                        transport.addChild(leader);
                        this._ttm.fireNodeInserted(new Object[]{t, location, transport}, new int[]{transport.getChildCount() - 1});
                    } else {
                        leader = (VisData)transportChilds.get(position);
                    }
                    childs = leader.getChildren();
                    position = childs.indexOf(new VisData.Comparator("subcontract"));
                    if (position < 0) {
                        subContract = new VisData("subcontract", 24);
                        leader.addChild(subContract);
                        this._ttm.fireNodeInserted(new Object[]{t, location, transport, leader}, new int[]{leader.getChildCount() - 1});
                    } else {
                        subContract = (VisData)childs.get(position);
                    }
                    childs = subContract.getChildren();
                    position = childs.indexOf(new VisData.Comparator(tp.getTeamLeader().getName()));
                    if (position < 0) {
                        subLeader = new VisData(tp.getTeamLeader().getName(), 7);
                        subContract.addChild(subLeader);
                        this._ttm.fireNodeInserted(new Object[]{t, location, transport, subContract}, new int[]{subContract.getChildCount() - 1});
                    } else {
                        subLeader = (VisData)childs.get(position);
                    }
                    childs = subLeader.getChildren();
                    position = childs.indexOf(new VisData.Comparator(proposer));
                    if (position < 0) {
                        proposerAgent = new VisData(proposer, 4);
                        subLeader.addChild(proposerAgent);
                        this._ttm.fireNodeInserted(new Object[]{t, location, transport, subContract, subLeader}, new int[]{subLeader.getChildCount() - 1});
                    } else {
                        proposerAgent = (VisData)childs.get(position);
                    }
                    double cov = 0.0;
                    boolean ok = false;
                    for (ItemCoverage ic : p.getItemCoverage()) {
                        String itemName = "";
                        block1: for (TransportBatch tb : tp.getRequestedServices().getTransportBatch()) {
                            if (tb.getBatchid() != ic.getItemid()) continue;
                            itemName = tb.getComodityName();
                            List requested = (List)locationBatches.get(Visualizer.parseId(tp.getTransportCfp().getRequestid(), 0));
                            for (Batch b : requested) {
                                if (!b.getComodityName().equalsIgnoreCase(itemName)) continue;
                                cov = (double)tb.getCount() * ic.getCoverage() / (double)b.getCount();
                                ok = true;
                                break block1;
                            }
                        }
                        VisData item = new VisData(String.valueOf(itemName) + " " + (int)(cov * 100.0) + " %", 24);
                        item.setProgress((int)(cov * 100.0));
                        proposerAgent.addChild(item);
                        this._ttm.fireNodeInserted(new Object[]{t, location, transport, leader, subContract, proposerAgent}, new int[]{proposerAgent.getChildCount() - 1});
                    }
                } else {
                    System.out.println("no location error " + p.getRequestid());
                }
            } else {
                System.out.println("no contract error");
            }
        }
    }

    public void addTeamMemberProposal(Proposal p, String proposer, String locationInitiator, TeamProposal tp, Map locationNames, Map locationBatches) {
        if (p != null) {
            int position = -1;
            position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf((String)locationNames.get(Visualizer.parseId(tp.getTransportCfp().getRequestid(), 0))) + ": " + Visualizer.parseId(tp.getTransportCfp().getRequestid(), 0)));
            if (position > -1) {
                VisTask t = (VisTask)this._tasks.get(position);
                List childs = t.getChildren();
                if ((position = childs.indexOf(new VisData.Comparator(Visualizer.parseId(p.getRequestid(), 1)))) > -1) {
                    VisData leader;
                    VisData transport;
                    VisData location = (VisData)childs.get(position);
                    if ((position = (childs = location.getChildren()).indexOf(new VisData.Comparator("Transport"))) > -1) {
                        transport = (VisData)childs.get(position);
                        childs = transport.getChildren();
                    } else {
                        transport = new VisData("Transport", 19);
                        location.addChild(transport);
                        this._ttm.fireNodeInserted(new Object[]{t, location}, new int[]{location.getChildCount() - 1});
                    }
                    List transportChilds = transport.getChildren();
                    position = transportChilds.indexOf(new VisData.Comparator(String.valueOf(tp.getTeamLeader().getName()) + " from " + locationInitiator));
                    if (position < 0) {
                        leader = new VisData(String.valueOf(tp.getTeamLeader().getName()) + " from " + locationInitiator, 7);
                        transport.addChild(leader);
                        this._ttm.fireNodeInserted(new Object[]{t, location, transport}, new int[]{transport.getChildCount() - 1});
                    } else {
                        leader = (VisData)transportChilds.get(position);
                    }
                    VisData proposerAgent = new VisData(proposer, 4);
                    leader.addChild(proposerAgent);
                    this._ttm.fireNodeInserted(new Object[]{t, location, transport, leader}, new int[]{leader.getChildCount() - 1});
                    double cov = 0.0;
                    boolean ok = false;
                    for (ItemCoverage ic : p.getItemCoverage()) {
                        String itemName = "";
                        block1: for (TransportBatch tb : tp.getRequestedServices().getTransportBatch()) {
                            if (tb.getBatchid() != ic.getItemid()) continue;
                            itemName = tb.getComodityName();
                            List requested = (List)locationBatches.get(Visualizer.parseId(tp.getTransportCfp().getRequestid(), 0));
                            for (Batch b : requested) {
                                if (!b.getComodityName().equalsIgnoreCase(itemName)) continue;
                                cov = (double)tb.getCount() * ic.getCoverage() / (double)b.getCount();
                                ok = true;
                                break block1;
                            }
                        }
                        VisData item = new VisData(String.valueOf(itemName) + " " + (int)(cov * 100.0) + " %", 24);
                        item.setProgress((int)(cov * 100.0));
                        proposerAgent.addChild(item);
                        this._ttm.fireNodeInserted(new Object[]{t, location, transport, leader, proposerAgent}, new int[]{proposerAgent.getChildCount() - 1});
                    }
                } else {
                    System.out.println("no location error " + p.getRequestid());
                }
            } else {
                System.out.println("no contract error");
            }
        }
    }

    public void setBestLeader(TransportCfp cfp, String name, String locationInitiator, Map locationNames) {
        VisData location;
        VisTask task;
        List childs;
        boolean ok = false;
        int position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf((String)locationNames.get(Visualizer.parseId(cfp.getRequestid(), 0))) + ": " + Visualizer.parseId(cfp.getRequestid(), 0)));
        if (position > -1 && (position = (childs = (task = (VisTask)this._tasks.get(position)).getChildren()).indexOf(new VisData.Comparator(locationInitiator))) > -1 && (position = (childs = (location = (VisData)childs.get(position)).getChildren()).indexOf(new VisData.Comparator("Transport"))) > -1) {
            VisData leader;
            VisData transport = (VisData)childs.get(position);
            if ((position = (childs = transport.getChildren()).indexOf(new VisData.Comparator(String.valueOf(name) + " from " + locationInitiator))) < 0) {
                leader = new VisData(String.valueOf(name) + " from " + locationInitiator, 23);
                transport.addChild(leader);
                this._ttm.fireNodeInserted(new Object[]{task, location, transport}, new int[]{transport.getChildCount() - 1});
            } else {
                leader = (VisData)childs.get(position);
            }
            leader.setType(23);
            this._ttm.fireNodeChanged(new Object[]{task, location, transport}, leader);
            ok = true;
        }
        if (!ok) {
            System.out.println("The best leader wasn't set!");
        }
    }

    public void setBestSubcontractLeader(TransportCfp cfp, String name, String transporterInitiator, Map locationNames) {
        int position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf((String)locationNames.get(Visualizer.parseId(cfp.getRequestid(), 0))) + ": " + Visualizer.parseId(cfp.getRequestid(), 0)));
        if (position > -1) {
            VisTask task = (VisTask)this._tasks.get(position);
            List childs = task.getChildren();
            if ((position = childs.indexOf(new VisData.Comparator(Visualizer.parseId(cfp.getRequestid(), 1)))) > -1) {
                VisData location = (VisData)childs.get(position);
                if ((position = (childs = location.getChildren()).indexOf(new VisData.Comparator("Transport"))) > -1) {
                    VisData subContract;
                    VisData leader;
                    VisData transport = (VisData)childs.get(position);
                    if ((position = (childs = transport.getChildren()).indexOf(new VisData.Comparator(String.valueOf(transporterInitiator) + " from " + Visualizer.parseId(cfp.getRequestid(), 1)))) < 0) {
                        leader = new VisData(String.valueOf(transporterInitiator) + " from " + Visualizer.parseId(cfp.getRequestid(), 1), 7);
                        transport.addChild(leader);
                        this._ttm.fireNodeInserted(new Object[]{task, location, transport}, new int[]{transport.getChildCount() - 1});
                    } else {
                        leader = (VisData)childs.get(position);
                    }
                    childs = leader.getChildren();
                    position = childs.indexOf(new VisData.Comparator("subcontract"));
                    if (position < 0) {
                        subContract = new VisData("sobcontract", 24);
                        leader.addChild(subContract);
                        this._ttm.fireNodeInserted(new Object[]{task, location, transport, leader}, new int[]{leader.getChildCount() - 1});
                    } else {
                        subContract = (VisData)childs.get(position);
                    }
                    childs = subContract.getChildren();
                    position = childs.indexOf(new VisData.Comparator(name));
                    if (position < 0) {
                        VisData subLeader = new VisData(name, 23);
                        subContract.addChild(subLeader);
                        this._ttm.fireNodeInserted(new Object[]{task, location, transport, leader, subContract}, new int[]{subContract.getChildCount() - 1});
                    } else {
                        VisData subLeader = (VisData)childs.get(position);
                        subLeader.setType(23);
                        this._ttm.fireNodeChanged(new Object[]{task, location, transport, leader, subContract}, subLeader);
                    }
                }
            } else {
                System.out.println("no location error");
            }
        }
    }

    public void finishCoalition(String id, Map locationNames) {
        int i = this._coalitions.indexOf(new VisTask.Comparator(String.valueOf(id) + "'s coalition"));
        if (i < 0) {
            System.out.println("nothing to finish: " + id);
        } else {
            VisTask task;
            List childs;
            VisTask coalition = (VisTask)this._coalitions.get(i);
            coalition.setNodeType(15);
            String locationName = (String)locationNames.get(Visualizer.parseId(id, 0));
            String locationInitiator = Visualizer.parseId(id, 1);
            int position = this._tasks.indexOf(new VisTask.Comparator(String.valueOf(locationName) + ": " + Visualizer.parseId(id, 0)));
            if (position > -1 && (position = (childs = (task = (VisTask)this._tasks.get(position)).getChildren()).indexOf(new VisData.Comparator(locationInitiator))) > -1) {
                VisData location = (VisData)childs.get(position);
                if ((position = (childs = location.getChildren()).indexOf(new VisData.Comparator("Transport"))) > -1) {
                    VisData transport = (VisData)childs.get(position);
                    this._ttm.fireNodeChanged(new Object[]{task, location, transport}, coalition);
                } else {
                    System.out.println("Coalition wasn't finished");
                }
            }
        }
    }

    protected void deleteAlliance(VisAlliance a) {
        this._alliances.remove(a);
        if (this._screen._tiling) {
            this._screen.autoArrangeAlliances();
        }
    }

    protected void setColorSchema(ColorFactory.PropertyGetter g) {
        this._cf.setColorSchema(g);
        Iterator i = this._agents.iterator();
        while (i.hasNext()) {
            ((VisAgent)i.next()).refreshColor();
        }
    }

    protected void setDisplayTask(VisTask t) {
        Iterator i = this._alliances.iterator();
        while (i.hasNext()) {
            ((VisAlliance)i.next()).setDisplayTask(t);
        }
    }

    public List getAlliances() {
        return this._alliances;
    }

    public static String parseId(String s, int index) {
        String[] ids = s.split("-");
        if (index > ids.length - 1) {
            return null;
        }
        return ids[index];
    }
}

