/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.data.Batch;
import across.data.CoalitionDescription;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import across.visio.visual.TreeMember;
import across.visio.visual.VisCoalition;
import across.visio.visual.VisData;
import across.visio.visual.VisString;
import aglobe.container.transport.Address;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VisTask
implements TreeMember {
    private List _agentbase;
    private List _treechildren;
    private String _taskname;
    private String _tasklocation;
    private String _taskdegree;
    private String _taskdisaster;
    private List _coalitions;
    private int nodeType = 20;

    public VisTask(String s) {
        this._taskname = s;
        this._treechildren = new LinkedList();
        this._treechildren.add(new VisString(this._tasklocation, 16));
        this._treechildren.add(new VisString(this._taskdisaster, 18));
        this._treechildren.add(new VisString(this._taskdegree, 17));
    }

    public VisTask(List agentbase, CoalitionDescription cd) {
        this._agentbase = agentbase;
        this._taskname = cd.getTaskName();
        this._tasklocation = cd.getTaskLocation();
        this._taskdegree = cd.getTaskDegree();
        this._taskdisaster = cd.getTaskDisaster();
        this._coalitions = new LinkedList();
        this.addCoalition(cd);
        this._treechildren = new LinkedList();
    }

    public VisTask(List agentbase, RequestList requestList, Collection participants, String name) {
        this._agentbase = agentbase;
        this._taskname = String.valueOf(name) + ": " + requestList.getRequestid();
        this._coalitions = new LinkedList();
        this._treechildren = new LinkedList();
        for (Batch b : requestList.getBatch()) {
            this._treechildren.add(new VisString(String.valueOf(b.getComodityName()) + " = " + Long.toString(b.getCount()), 21));
        }
        VisData vd = new VisData("Potential partners", 24);
        for (Address a : participants) {
            vd.addChild(new VisData(a.getName(), 24));
        }
        this._treechildren.add(vd);
    }

    public void addChild(Object node) {
        this._treechildren.add(node);
    }

    public void addLocationProposal(Proposal proposal, String locationName, Map batchesById) {
        VisData vd = new VisData(locationName, 4);
        for (ItemCoverage ic : proposal.getItemCoverage()) {
            Batch tb = (Batch)batchesById.get(Long.toString(ic.getItemid()));
            int num = 0;
            while (tb == null) {
                System.out.println(num);
                ++num;
                tb = (Batch)batchesById.get(Long.toString(ic.getItemid()));
            }
            VisData newData = new VisData(String.valueOf(tb.getComodityName()) + " " + (int)(ic.getCoverage() * 100.0) + "%", 15);
            newData.setProgress((int)(ic.getCoverage() * 100.0));
            vd.addChild(newData);
        }
        this._treechildren.add(vd);
    }

    public void addRefusedLocation(String locationName) {
        this._treechildren.add(new VisString("Location " + locationName + " refused proposal", 16));
    }

    public void addLocationReceivedAcceptation(String locationName) {
        this._treechildren.add(new VisString("Location " + locationName + " received acceptation", 24));
    }

    public void addCoalition(CoalitionDescription cd) {
        this._coalitions.add(new VisCoalition(this, cd, this._agentbase));
    }

    public void removeCoalition(VisCoalition c) {
        this._coalitions.remove(c);
    }

    public void setName(String newTaskName) {
        this._taskname = newTaskName;
    }

    public String getName() {
        return this._taskname;
    }

    public List getCoalitions() {
        return this._coalitions;
    }

    public String toString() {
        return this._taskname;
    }

    @Override
    public Object getChild(int index) {
        if (index < this._treechildren.size()) {
            return this._treechildren.get(index);
        }
        if ((index -= this._treechildren.size()) < this._coalitions.size()) {
            return this._coalitions.get(index);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this._treechildren.size() + this._coalitions.size();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getIndexOfChild(Object child) {
        int i = this._treechildren.indexOf(child);
        if (i == -1) {
            i = this._coalitions.indexOf(child);
            if (i != -1) {
                return i + this._treechildren.size();
            }
            return -1;
        }
        return i;
    }

    @Override
    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int type) {
        this.nodeType = type;
    }

    public List getChildren() {
        return this._treechildren;
    }

    public static class Comparator {
        String _name;

        public Comparator(String name) {
            this._name = name;
        }

        public boolean equals(Object other) {
            return other instanceof VisTask && ((VisTask)other).getName().equalsIgnoreCase(this._name);
        }
    }
}

