/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.data.CoalitionDescription;
import across.visio.visual.TreeMember;
import across.visio.visual.VisAgent;
import across.visio.visual.VisCoalitionLeader;
import across.visio.visual.VisTask;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class VisCoalition
implements TreeMember {
    private static int co = 0;
    private VisTask _owner;
    private VisAgent _leader;
    private List _members;
    private VisCoalitionLeader _vleader;
    private List _agentbase;

    public VisCoalition(VisTask owner, CoalitionDescription cd, List agentbase) {
        this._owner = owner;
        this._agentbase = agentbase;
        int ii = agentbase.indexOf(new VisAgent.Comparator(cd.getCoalitionLeader()));
        if (ii == -1) {
            System.out.println("ERROR: Leader " + cd.getCoalitionLeader() + " is not member of agents: " + agentbase);
        }
        this._leader = (VisAgent)agentbase.get(ii);
        if (this._leader != null) {
            this._leader.joinCoalition(this);
            this._leader.getAlliance().addCoalition(this);
        } else {
            System.out.println("Coalition without a leader!!");
        }
        this._vleader = new VisCoalitionLeader(this._leader);
        this._members = new LinkedList();
        Iterator<String> i = cd.getCoalitionMember().iterator();
        ++co;
        while (i.hasNext()) {
            ii = agentbase.indexOf(new VisAgent.Comparator(i.next()));
            VisAgent m = (VisAgent)agentbase.get(ii);
            if (m == null || m == this._leader) continue;
            m.joinCoalition(this);
            this._members.add(m);
        }
    }

    public void addAgentToCoalition(String name) {
        int ii = this._agentbase.indexOf(new VisAgent.Comparator(name));
        VisAgent m = (VisAgent)this._agentbase.get(ii);
        if (m != null) {
            m.joinCoalition(this);
            this._members.add(m);
        }
    }

    public String[] removeAllParticipants() {
        String[] participants = new String[this._members.size() + 1];
        participants[0] = this._leader.getName();
        int index = 1;
        for (VisAgent va : this._members) {
            participants[index] = va.getName();
            va.leaveCoalition(this);
            ++index;
        }
        this._members = new LinkedList();
        this._leader.getAlliance().removeCoalition(this);
        return participants;
    }

    public void insertParticipants(String leader, List members, List agentbase) {
        this._agentbase = agentbase;
        int ii = this._agentbase.indexOf(new VisAgent.Comparator(leader));
        if (ii == -1) {
            System.out.println("ERROR: Leader is not member of agents: " + this._agentbase);
        }
        this._leader = (VisAgent)this._agentbase.get(ii);
        if (this._leader != null) {
            this._leader.joinCoalition(this);
            this._leader.getAlliance().addCoalition(this);
        } else {
            System.out.println("Coalition without a leader!!");
        }
        this._vleader = new VisCoalitionLeader(this._leader);
        this._members = new LinkedList();
        Iterator i = members.iterator();
        ++co;
        while (i.hasNext()) {
            ii = this._agentbase.indexOf(new VisAgent.Comparator((String)i.next()));
            VisAgent m = (VisAgent)this._agentbase.get(ii);
            if (m == null || m == this._leader) continue;
            m.joinCoalition(this);
            this._members.add(m);
        }
    }

    public void removeAgent(VisAgent a) {
        if (a == this._leader) {
            this.dismiss();
        } else {
            this._members.remove(a);
        }
    }

    public void dismiss() {
        Iterator i = this._members.iterator();
        while (i.hasNext()) {
            ((VisAgent)i.next()).leaveCoalition(this);
        }
        this._leader.getAlliance().removeCoalition(this);
        this._owner.removeCoalition(this);
    }

    public VisTask getTask() {
        return this._owner;
    }

    public VisAgent getLeader() {
        return this._leader;
    }

    public List getMembers() {
        return this._members;
    }

    public int getMemberCount() {
        return this._members.size();
    }

    public String toString() {
        return this._leader.toString();
    }

    @Override
    public Object getChild(int index) {
        if (index == 0) {
            return this._owner;
        }
        if (index == 1) {
            return this._vleader;
        }
        return this._members.get(index - 2);
    }

    @Override
    public int getChildCount() {
        return 2 + this._members.size();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getIndexOfChild(Object child) {
        if (child == this._owner) {
            return 0;
        }
        if (child == this._vleader) {
            return 1;
        }
        int i = this._members.indexOf(child);
        if (i != -1) {
            return i + 2;
        }
        return -1;
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    public static class TaskComparator {
        VisTask _task;

        public TaskComparator(VisTask task) {
            this._task = task;
        }

        public boolean equals(Object other) {
            return other instanceof VisCoalition && ((VisCoalition)other)._owner == this._task;
        }
    }
}

