/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.visio.visual.DISPLAYCONST;
import across.visio.visual.MyTreeCellRenderer;
import across.visio.visual.PhantomAgent;
import across.visio.visual.ShadowBorder;
import across.visio.visual.TreeMember;
import across.visio.visual.VisAgent;
import across.visio.visual.VisAgentInterface;
import across.visio.visual.VisCoalition;
import across.visio.visual.VisTask;
import across.visio.visual.Visualizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class VisAlliance
extends JInternalFrame
implements TreeMember,
DISPLAYCONST {
    private static int _alliancecount = 1;
    private static final String NOTASK = "No Task";
    private Visualizer _owner;
    private String _name = "Alliance #" + _alliancecount++;
    private VisTask _displaytask;
    private JDesktopPane _pane;
    private List _members;
    private List _coalitions;
    private PhantomFactory _pf = new PhantomFactory();
    private JPanel jPanel1 = new JPanel();
    private JScrollPane AgentScrollPane = new JScrollPane();
    private JComboBox TaskCombo = new JComboBox();
    private CanvasPanel AgentPanel = new CanvasPanel();
    private Border border1;

    public VisAlliance(Visualizer owner, JDesktopPane pane, String name) {
        super("", true, false, false, true);
        if (name != null) {
            this._name = name;
        }
        this.setTitle(this._name);
        this.setFrameIcon(new ImageIcon(MyTreeCellRenderer.class.getResource("images/alliance.gif")));
        this._displaytask = null;
        this._owner = owner;
        this._pane = pane;
        this._members = new LinkedList();
        this._coalitions = new LinkedList();
        this.AgentPanel = new CanvasPanel();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._pane.add(this);
        this.pack();
        this.setLocation(_alliancecount * 23, _alliancecount * 23);
        this.setVisible(true);
    }

    public boolean isMember(String agent) {
        return this._members.contains(new VisAgent.Comparator(agent));
    }

    public void addMember(VisAgent a) {
        if (!this.isMember(a.getName())) {
            this._members.add(a);
            a.joinAlliance(this);
            this.AgentPanel.add(a);
        }
        this.arrange();
    }

    public void addMembers(List newcommers) {
        for (VisAgent a : newcommers) {
            if (this.isMember(a.getName())) continue;
            this._members.add(a);
            a.joinAlliance(this);
            this.AgentPanel.add(a);
        }
        this.arrange();
    }

    public void removeMember(VisAgent a) {
        if (this._members.contains(a)) {
            this._members.remove(a);
            this.AgentPanel.remove(a);
            if (this._members.size() == 0) {
                this._owner.deleteAlliance(this);
                this.setVisible(false);
                this._pane.remove(this);
                this.dispose();
            } else {
                this.arrange();
            }
        }
    }

    public void addCoalition(VisCoalition c) {
        if (!this._coalitions.contains(c)) {
            if (!this._coalitions.contains(new VisCoalition.TaskComparator(c.getTask()))) {
                this.TaskCombo.addItem(c.getTask());
            }
            this._coalitions.add(c);
            if (c.getTask() == this._displaytask) {
                this.arrange();
            }
        }
    }

    public void removeCoalition(VisCoalition c) {
        this._coalitions.remove(c);
        if (!this._coalitions.contains(new VisCoalition.TaskComparator(c.getTask()))) {
            this.TaskCombo.removeItem(c.getTask());
        }
        if (c.getTask() == this._displaytask) {
            this.arrange();
        }
    }

    public void dismiss() {
        this._pane.remove(this);
        this._members.clear();
        this._coalitions.clear();
    }

    public void setDisplayTask(VisTask task) {
        if (!this._coalitions.contains(new VisCoalition.TaskComparator(task))) {
            task = null;
        }
        this._displaytask = task;
        if (task != null) {
            this.TaskCombo.setSelectedItem(task);
        } else {
            this.TaskCombo.setSelectedItem(NOTASK);
        }
        this.arrange();
    }

    public void arrange() {
        int col;
        LinkedList memberstoshow = new LinkedList(this._members);
        LinkedList<VisCoalition> coalstoshow = new LinkedList<VisCoalition>();
        int maxmembers = 1;
        this.AgentPanel.removeShapes();
        this._pf.start();
        if (this._displaytask != null) {
            List tc = this._displaytask.getCoalitions();
            for (VisCoalition c : tc) {
                if (!this._coalitions.contains(c)) continue;
                coalstoshow.add(c);
                if (c.getMemberCount() <= maxmembers) continue;
                maxmembers = c.getMemberCount();
            }
        }
        int row = 0;
        for (VisCoalition c : coalstoshow) {
            int membercount;
            JLabel leader = c.getLeader();
            if (!memberstoshow.contains(leader)) {
                leader = this._pf.getPhantom((VisAgentInterface)((Object)leader));
            }
            if ((membercount = c.getMemberCount()) > 0) {
                leader.setLocation((c.getMemberCount() * COLWIDTH - HGAP >> 1) - AGENTCENTER + HGAP, row * ROWHEIGHT + VGAP);
            } else {
                leader.setLocation(HGAP, row * ROWHEIGHT + VGAP);
            }
            leader.setRole("Coalition Leader");
            Point linestart = leader.getLocation();
            linestart.translate(AGENTCENTER, AGENTHEIGHT);
            memberstoshow.remove(leader);
            ++row;
            if (membercount <= 0) continue;
            col = 0;
            for (JLabel a : c.getMembers()) {
                if (!memberstoshow.contains(a)) {
                    a = this._pf.getPhantom((VisAgentInterface)((Object)a));
                }
                Point pos = new Point(col * COLWIDTH + HGAP, row * ROWHEIGHT + VGAP);
                a.setLocation(pos);
                a.setRole("Coalition Member");
                pos.translate(AGENTCENTER, 0);
                this.AgentPanel.addShape(new Line2D.Double(linestart, pos));
                memberstoshow.remove(a);
                ++col;
            }
            ++row;
        }
        int rowcap = (this.AgentScrollPane.getViewport().getWidth() - HGAP) / COLWIDTH;
        int maxnext = maxmembers > rowcap ? maxmembers : rowcap;
        boolean rowoverflow = false;
        Iterator resti = memberstoshow.iterator();
        col = 0;
        boolean emptyrow = true;
        while (resti.hasNext()) {
            JLabel a;
            emptyrow = false;
            a = (VisAgent)resti.next();
            a.setLocation(col * COLWIDTH + HGAP, row * ROWHEIGHT + VGAP);
            ((VisAgent)a).setRole("Other");
            if (++col < maxnext) continue;
            emptyrow = true;
            ++row;
            col = 0;
            rowoverflow = true;
        }
        this._pf.end();
        if (!emptyrow) {
            ++row;
        }
        int w = rowoverflow ? maxnext : (col > maxmembers ? col : maxmembers);
        this.AgentPanel.setPreferredSize(new Dimension(w * COLWIDTH + HGAP, row * ROWHEIGHT + VGAP));
        this.AgentPanel.revalidate();
        this.AgentPanel.repaint();
    }

    @Override
    public String toString() {
        return this._name;
    }

    @Override
    public Object getChild(int index) {
        return this._members.get(index);
    }

    @Override
    public int getChildCount() {
        return this._members.size();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this._members.indexOf(child);
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    public VisAlliance() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = ShadowBorder.createStandardShadow();
        this.AgentPanel.setLayout(null);
        this.TaskCombo.addItem(NOTASK);
        this.TaskCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisAlliance.this.TaskCombo_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.TaskCombo, null);
        this.getContentPane().add((Component)this.AgentScrollPane, "Center");
        this.AgentScrollPane.getViewport().add((Component)this.AgentPanel, null);
    }

    void TaskCombo_actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        Object item = cb.getSelectedItem();
        if (item instanceof String) {
            this.setDisplayTask(null);
        } else {
            this.setDisplayTask((VisTask)item);
        }
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return true;
    }

    private class CanvasPanel
    extends JPanel {
        private List _shapes;

        public CanvasPanel() {
            this.setPreferredSize(new Dimension(3 * COLWIDTH + HGAP, 2 * ROWHEIGHT + VGAP));
            this._shapes = new LinkedList();
        }

        public synchronized void removeShapes() {
            this._shapes.clear();
        }

        public synchronized void addShape(Shape s) {
            this._shapes.add(s);
        }

        @Override
        public synchronized void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Color oldc = g2d.getColor();
            g2d.setColor(Color.black);
            Iterator i = this._shapes.iterator();
            while (i.hasNext()) {
                g2d.draw((Shape)i.next());
            }
            g2d.setColor(oldc);
        }
    }

    private class PhantomFactory {
        List _phantoms = new LinkedList();
        int _index = 0;

        public void start() {
            Iterator i = this._phantoms.iterator();
            while (i.hasNext()) {
                ((PhantomAgent)i.next()).clearOwner();
            }
            this._index = 0;
        }

        public PhantomAgent getPhantom(VisAgentInterface a) {
            PhantomAgent p;
            if (this._index < this._phantoms.size()) {
                p = (PhantomAgent)this._phantoms.get(this._index);
            } else {
                p = new PhantomAgent((VisAgent)a);
                this._phantoms.add(p);
                VisAlliance.this.AgentPanel.add(p);
            }
            ++this._index;
            p.setOwner((VisAgent)a);
            return p;
        }

        public void end() {
            while (this._index < this._phantoms.size()) {
                PhantomAgent p = (PhantomAgent)this._phantoms.get(this._index);
                VisAlliance.this.AgentPanel.remove(p);
                this._phantoms.remove(this._index);
            }
        }
    }
}

