/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.visio.VisualAgent;
import across.visio.ont.CPlantAgentDescription;
import across.visio.ont.DFAgentDescription;
import across.visio.visual.AgentInfoPanel;
import across.visio.visual.ColorFactory;
import across.visio.visual.DISPLAYCONST;
import across.visio.visual.PhantomAgent;
import across.visio.visual.ShadowBorder;
import across.visio.visual.TreeMember;
import across.visio.visual.VisAgentInterface;
import across.visio.visual.VisAlliance;
import across.visio.visual.VisCoalition;
import across.visio.visual.VisString;
import across.visio.visual.Visualizer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;

public class VisAgent
extends JLabel
implements VisAgentInterface,
TreeMember,
DISPLAYCONST {
    private static VisString NoAl = new VisString("None", 5);
    private String _name;
    private String _type;
    private String _country;
    private String _city;
    private VisAlliance _alliance;
    private List _coalitions;
    private List _treechildren;
    private Object _role;
    private String _titlename;
    private boolean _infoon = false;
    private List _phantoms = new LinkedList();
    Visualizer owner;
    DFAgentDescription dfAD;
    CPlantAgentDescription cpAD;
    private boolean visibility = true;
    private Object waglobeObjInform = new Object();
    private Map modelsOG = new HashMap();
    private Map modelsOS = new HashMap();
    private Map modelsMT = new HashMap();
    private Map modelsMF = new HashMap();
    private List otherAgents = new LinkedList();

    public VisAgent(DFAgentDescription dfad, CPlantAgentDescription cpad, List otherAgents, Visualizer owner) {
        this.owner = owner;
        this.otherAgents = otherAgents;
        this.dfAD = dfad;
        this.cpAD = cpad;
        this._name = dfad.getName();
        this._type = dfad.getType();
        this._country = cpad.getCountry();
        this._city = cpad.getCity();
        this._alliance = null;
        this._coalitions = new LinkedList();
        this._treechildren = new LinkedList();
        this._treechildren.add(new VisString(this._type, 10));
        if (this._country != null) {
            this._treechildren.add(new VisString(this._country, 11));
        }
        if (this._city != null) {
            this._treechildren.add(new VisString(this._city, 12));
        }
        this._role = "Other";
        this.refreshColor();
        this._titlename = this._name;
        String _shortname = (String)VisualAgent.getConfig().getNames().get(this._titlename);
        if (_shortname != null) {
            this._titlename = _shortname;
        }
        this.setSize(AGENTWIDTH, AGENTHEIGHT);
        this.setPreferredSize(new Dimension(AGENTWIDTH, AGENTHEIGHT));
        this.setBorder(ShadowBorder.createStandardShadow());
        this.setForeground(AGENTTXTCOLOR);
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        if (this._titlename.endsWith("Transporter")) {
            String name = this._titlename.substring(0, this._titlename.length() - 11);
            this.setText(String.valueOf(NAMEPREFIX) + name + "<BR>" + "Transporter" + NAMESUFFIX);
        } else {
            this.setText(String.valueOf(NAMEPREFIX) + this._titlename + NAMESUFFIX);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VisAgent.this.this_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VisAgent.this.this_mouseReleased(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VisAgent.this.this_mouseExited(e);
            }
        });
    }

    public void deregister() {
        Iterator i = this._coalitions.iterator();
        while (i.hasNext()) {
            ((VisCoalition)i.next()).removeAgent(this);
        }
        if (this._alliance != null) {
            this._alliance.removeMember(this);
        }
    }

    public void joinAlliance(VisAlliance a) {
        if (this._alliance != null) {
            this._alliance.removeMember(this);
        }
        this._alliance = a;
        this._alliance.addMember(this);
    }

    public void joinCoalition(VisCoalition c) {
        this._coalitions.add(c);
    }

    public void leaveCoalition(VisCoalition c) {
        this._coalitions.remove(c);
    }

    @Override
    public void refreshColor() {
        Color backGC = ColorFactory.getDefaultFactory().getColor(this);
        if (!this.getVisibility()) {
            backGC = backGC.darker();
        }
        this.setBackground(backGC);
        Iterator i = this._phantoms.iterator();
        while (i.hasNext()) {
            ((PhantomAgent)i.next()).refreshColor();
        }
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getCountry() {
        return this._country;
    }

    @Override
    public String getCity() {
        return this._city;
    }

    public VisAlliance getAlliance() {
        return this._alliance;
    }

    @Override
    public Object getRole() {
        return this._role;
    }

    @Override
    public void setRole(Object role) {
        this._role = role;
        this.refreshColor();
    }

    @Override
    public List getCoalitions() {
        return this._coalitions;
    }

    @Override
    public String toString() {
        return this._titlename;
    }

    public void addPhantom(PhantomAgent a) {
        this._phantoms.add(a);
    }

    public void removePhantom(PhantomAgent a) {
        this._phantoms.remove(a);
    }

    @Override
    public Object getChild(int index) {
        if (index < this._treechildren.size()) {
            return this._treechildren.get(index);
        }
        if ((index -= this._treechildren.size()) == 0) {
            return this._alliance == null ? NoAl : this._alliance;
        }
        return this._coalitions.get(index - 1);
    }

    @Override
    public int getChildCount() {
        return 1 + this._treechildren.size() + this._coalitions.size();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getIndexOfChild(Object child) {
        int i = this._treechildren.indexOf(child);
        if (i == -1) {
            if (child == this._alliance) {
                return this._treechildren.size();
            }
            i = this._coalitions.indexOf(child);
            if (i != -1) {
                return i + this._treechildren.size() + 1;
            }
            return -1;
        }
        return i;
    }

    @Override
    public int getNodeType() {
        return 4;
    }

    void this_mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this._infoon = true;
            AgentInfoPanel.DefaultAgentInfo.activate(e);
        } else {
            e.getButton();
        }
    }

    void this_mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this._infoon) {
                this._infoon = false;
                AgentInfoPanel.DefaultAgentInfo.deactivate(e);
            }
        } else {
            e.getButton();
        }
    }

    void this_mouseExited(MouseEvent e) {
        if (this._infoon) {
            this._infoon = false;
            AgentInfoPanel.DefaultAgentInfo.deactivate(e);
        }
    }

    public void setVisibility(boolean visible) {
        this.visibility = visible;
        this.refreshColor();
    }

    @Override
    public boolean getVisibility() {
        return this.visibility;
    }

    public static class Comparator {
        String _name;

        public Comparator(String name) {
            this._name = name;
        }

        public boolean equals(Object other) {
            return other instanceof VisAgent && ((VisAgent)other).getName().equalsIgnoreCase(this._name);
        }
    }
}

