/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.visio.visual.TreeMember;
import across.visio.visual.VisString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TaskTreeModel
implements TreeModel {
    private final VisString ROOT = new VisString("Tasks", 3);
    private List _tasks;
    private List _listeners;

    public TaskTreeModel(List tasks) {
        this._tasks = tasks;
        this._listeners = new LinkedList();
    }

    @Override
    public Object getRoot() {
        return this.ROOT;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.ROOT) {
            return this._tasks.get(index);
        }
        if (parent instanceof TreeMember) {
            return ((TreeMember)parent).getChild(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.ROOT) {
            return this._tasks.size();
        }
        if (parent instanceof TreeMember) {
            return ((TreeMember)parent).getChildCount();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == this.ROOT) {
            return false;
        }
        if (node instanceof TreeMember) {
            return ((TreeMember)node).isLeaf();
        }
        return false;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Method valueForPathChanged() not yet implemented.");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.ROOT) {
            return this._tasks.indexOf(child);
        }
        if (parent instanceof TreeMember) {
            return ((TreeMember)parent).getIndexOfChild(child);
        }
        return -1;
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener l) {
        this._listeners.add(l);
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener l) {
        if (this._listeners.contains(l)) {
            this._listeners.remove(l);
        }
    }

    protected void fireTreeChange() {
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.ROOT});
        Iterator i = this._listeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeStructureChanged(e);
        }
    }

    protected synchronized void fireNodeChanged(Object[] path, Object node) {
        int len = 0;
        if (path != null) {
            len = path.length;
        }
        Object[] p = new Object[len + 1];
        p[0] = this.ROOT;
        int j = 1;
        while (j < p.length) {
            p[j] = path[j - 1];
            ++j;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, p, null, new Object[]{node});
        Iterator i = this._listeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesInserted(e);
        }
    }

    protected synchronized void fireNodeInserted(Object[] path, final int[] nodes) {
        int len = 0;
        if (path != null) {
            len = path.length;
        }
        Object[] p = new Object[len + 1];
        p[0] = this.ROOT;
        int j = 1;
        while (j < p.length) {
            p[j] = path[j - 1];
            ++j;
        }
        TreeModelEvent e = new TreeModelEvent(this, p){

            @Override
            public int[] getChildIndices() {
                return nodes;
            }
        };
        Iterator i = this._listeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesInserted(e);
        }
    }
}

