/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.visio.visual.DISPLAYCONST;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class ShadowBorder
extends AbstractBorder
implements DISPLAYCONST {
    private static Border _standardshadow;
    protected int _thickness;
    protected Color _shadowcolor;
    protected Color _backcolor;

    public ShadowBorder(int thickness, Color shadowcolor, Color backcolor) {
        this._thickness = thickness;
        this._shadowcolor = shadowcolor;
        this._backcolor = backcolor;
    }

    public ShadowBorder() {
        this(SHADOWTHICK, SHADOWCOLOR, SHADOWBCOLOR);
    }

    public static Border createStandardShadow() {
        if (_standardshadow == null) {
            _standardshadow = new ShadowBorder();
        }
        return _standardshadow;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this._shadowcolor);
        int i = 0;
        while (i < this._thickness) {
            g.drawLine(x + this._thickness, y + height - i - 1, x + width, y + height - i - 1);
            g.drawLine(x + width - i - 1, y + this._thickness, x + width - i - 1, y + width);
            ++i;
        }
        g.setColor(this._backcolor);
        i = 0;
        while (i < this._thickness) {
            g.drawLine(x, y + height - i - 1, x + this._thickness - 1, y + height - i - 1);
            g.drawLine(x + width - i - 1, y, x + width - i - 1, y + this._thickness - 1);
            ++i;
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, this._thickness, this._thickness);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

