/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.visio.VisualAgent;
import across.visio.visual.AgentInfoPanel;
import across.visio.visual.AllianceTreeModel;
import across.visio.visual.ColorFactory;
import across.visio.visual.IconWindow;
import across.visio.visual.LegendWindow;
import across.visio.visual.MyTreeCellRenderer;
import across.visio.visual.ToolWindow;
import across.visio.visual.VisAlliance;
import across.visio.visual.VisTask;
import across.visio.visual.Visualizer;
import aglobe.container.Store;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Screen
extends JFrame {
    public boolean _tiling = VisualAgent.getConfig().getTileArrange();
    private Visualizer _owner;
    private TreeModel _alliancemodel;
    private final Store store;
    private static final String GUI_X = "gui/x";
    private static final String GUI_Y = "gui/y";
    private static final String GUI_W = "gui/w";
    private static final String GUI_H = "gui/h";
    private TreeModel _tasktreemodel;
    private TreeModel _coalitionstreemodel;
    private boolean showfull = true;
    private LegendWindow _legend = new LegendWindow();
    private ToolWindow _icons = new IconWindow();
    private AgentInfoPanel _agentinfo = AgentInfoPanel.DefaultAgentInfo;
    private AbstractAction KeyAction;
    private AbstractAction IconAction;
    private MyDesktopManager _desktopmanager = new MyDesktopManager();
    private JPanel contentPane;
    private JSplitPane jSplitPane1 = new JSplitPane();
    private JSplitPane jSplitPane2 = new JSplitPane();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JDesktopPane _desktop = new JDesktopPane();
    private JTree _tasktree;
    private JTree _alliancetree;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JToolBar jToolBar1 = new JToolBar();
    private JLabel jLabel1 = new JLabel();
    private JComboBox ColorCombo = new JComboBox();
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu FileMenu = new JMenu();
    private JMenuItem MenuQuit = new JMenuItem();
    private ButtonGroup LFgroup = new ButtonGroup();
    private JMenu ViewMenu = new JMenu();
    private JMenu MenuLF = new JMenu();
    private JRadioButtonMenuItem MetalLF = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem MotifLF = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem WindowsLF = new JRadioButtonMenuItem();
    private JCheckBoxMenuItem KeyCheckbox;
    private JToggleButton ColorKeyButton;
    private JCheckBoxMenuItem IconCheckbox;
    private JToggleButton IconButton;
    private JButton TileButton = new JButton();
    private JButton CascadeButton = new JButton();
    private Component component1;
    private JMenuItem TileMenuItem = new JMenuItem();
    private JMenuItem CascadeMenuItem = new JMenuItem();
    JButton CoalitionsButton = new JButton();

    public Screen(Visualizer owner, AllianceTreeModel alliancemodel, TreeModel tasktreemodel, TreeModel coalitionstreemodel) {
        this.store = owner._owner.getContainer().getAgentStore(owner._owner.getName());
        try {
            this._owner = owner;
            this._alliancemodel = alliancemodel;
            this._alliancetree = new JTree(this._alliancemodel);
            this._alliancetree.setRootVisible(false);
            this._alliancetree.setCellRenderer(new MyTreeCellRenderer());
            this._alliancetree.putClientProperty("JTree.lineStyle", "Angled");
            this._alliancetree.expandPath(new TreePath(new Object[]{alliancemodel.ROOT, alliancemodel.AGENTROOT}));
            this._alliancetree.expandPath(new TreePath(new Object[]{alliancemodel.ROOT, alliancemodel.ALLIANCEROOT}));
            this._tasktreemodel = tasktreemodel;
            this._tasktree = new JTree(this._tasktreemodel);
            this._tasktree.setCellRenderer(new MyTreeCellRenderer());
            this._tasktree.putClientProperty("JTree.lineStyle", "Angled");
            this._coalitionstreemodel = coalitionstreemodel;
            this.ColorCombo.addItem(ColorFactory.countryGetter);
            this.ColorCombo.addItem(ColorFactory.roleGetter);
            this.ColorCombo.addItem(ColorFactory.typeGetter);
            this.ColorCombo.addItem(ColorFactory.cityGetter);
            this._desktop.setDesktopManager(this._desktopmanager);
            this.jbInit();
            this.pack();
            this._legend.setShowAction(this.KeyAction);
            JLayeredPane layeredPane = this.getLayeredPane();
            this._legend.setVisible(false);
            this._legend.setSnapTo(this._desktop, 0);
            layeredPane.add((Component)this._legend, JLayeredPane.PALETTE_LAYER);
            this._icons.setShowAction(this.IconAction);
            this._icons.setVisible(false);
            this._icons.setSnapTo(this.jSplitPane2, 1);
            layeredPane.add((Component)this._icons, JLayeredPane.PALETTE_LAYER);
            this._agentinfo.setVisible(false);
            layeredPane.add((Component)this._agentinfo, new Integer(JLayeredPane.PALETTE_LAYER.hashCode() + 1));
            this.jSplitPane2.setDividerLocation(0.5);
            this.jSplitPane2.setDividerSize(3);
            this.setIconImage(new ImageIcon(Screen.class.getResource("images/agent.gif")).getImage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.KeyAction = new AbstractAction("Color Key", new ImageIcon(Screen.class.getResource("images/colorkey.gif"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean newstate = !Screen.this._legend.isVisible();
                Screen.this.ColorKeyButton.setSelected(newstate);
                Screen.this.KeyCheckbox.setSelected(newstate);
                Screen.this._legend.setVisible(newstate);
            }
        };
        this.IconAction = new AbstractAction("Icon Key", new ImageIcon(Screen.class.getResource("images/agent.gif"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean newstate = !Screen.this._icons.isVisible();
                Screen.this.IconButton.setSelected(newstate);
                Screen.this.IconCheckbox.setSelected(newstate);
                Screen.this._icons.setVisible(newstate);
            }
        };
        this.KeyCheckbox = new JCheckBoxMenuItem(this.KeyAction);
        this.ColorKeyButton = new JToggleButton(this.KeyAction);
        this.IconCheckbox = new JCheckBoxMenuItem(this.IconAction);
        this.IconButton = new JToggleButton(this.IconAction);
        this.contentPane = (JPanel)this.getContentPane();
        this.component1 = Box.createVerticalStrut(8);
        this.jSplitPane2.setOrientation(0);
        this.contentPane.setLayout(this.borderLayout1);
        this.setDefaultCloseOperation(0);
        this.setTitle("Inacc Visualizer");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Screen.this.this_windowClosing(e);
            }
        });
        this.jLabel1.setLabelFor(this.ColorCombo);
        this.jLabel1.setText("Color by ");
        this.ColorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Screen.this.ColorCombo_actionPerformed(e);
            }
        });
        this.ColorCombo.setMaximumSize(new Dimension(200, 21));
        this.ColorCombo.setToolTipText("Property to Color Agents by");
        this._tasktree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Screen.this.TreeMaybePopUp(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Screen.this.TreeMaybePopUp(e);
            }
        });
        this._alliancetree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Screen.this.TreeMaybePopUp(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Screen.this.TreeMaybePopUp(e);
            }
        });
        this.FileMenu.setText("File");
        this.FileMenu.setMnemonic(70);
        this.MenuQuit.setText("Quit");
        this.MenuQuit.setAccelerator(KeyStroke.getKeyStroke(88, 8, false));
        this.MenuQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Screen.this.MenuQuit_actionPerformed(e);
            }
        });
        this.ViewMenu.setText("View");
        this.ViewMenu.setMnemonic(86);
        this.MenuLF.setText("L&F");
        this.MetalLF.setText("Metal");
        this.MetalLF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Screen.this.MetalLF_actionPerformed(e);
            }
        });
        this.MotifLF.setText("Motif");
        this.MotifLF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Screen.this.MotifLF_actionPerformed(e);
            }
        });
        this.WindowsLF.setText("Windows");
        this.WindowsLF.setSelected(true);
        this.WindowsLF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Screen.this.WindowsLF_actionPerformed(e);
            }
        });
        this.ColorKeyButton.setText("");
        this.ColorKeyButton.setToolTipText("Show/Hide the Color Key");
        this.ColorKeyButton.setMargin(new Insets(0, 0, 0, 0));
        this.KeyCheckbox.setAccelerator(KeyStroke.getKeyStroke(75, 0, false));
        this.IconButton.setText("");
        this.IconButton.setToolTipText("Show/Hide the Icon Key");
        this.IconButton.setMargin(new Insets(0, 0, 0, 0));
        this.IconCheckbox.setAccelerator(KeyStroke.getKeyStroke(73, 0, false));
        this.TileButton.setMargin(new Insets(0, 0, 0, 0));
        this.TileButton.setIcon(new ImageIcon(Screen.class.getResource("images/tiles.gif")));
        this.TileButton.setToolTipText("Tile Alliances");
        this.TileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Screen.this.TileButton_actionPerformed(e);
            }
        });
        this.CascadeButton.setMargin(new Insets(0, 0, 0, 0));
        this.CascadeButton.setIcon(new ImageIcon(Screen.class.getResource("images/cascade.gif")));
        this.CascadeButton.setToolTipText("Cascade Alliances");
        this.CascadeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Screen.this.CascadeButton_actionPerformed(e);
            }
        });
        this.TileMenuItem.setText("Tile");
        this.TileMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 0, false));
        this.TileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Screen.this.TileButton_actionPerformed(e);
            }
        });
        this.CascadeMenuItem.setText("Cascade");
        this.CascadeMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 0, false));
        this.CascadeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Screen.this.CascadeButton_actionPerformed(e);
            }
        });
        this.CoalitionsButton.setToolTipText("Show/Hide coalition tree");
        this.CoalitionsButton.setIcon(new ImageIcon(Screen.class.getResource("images/coalition.gif")));
        this.CoalitionsButton.setMargin(new Insets(0, 0, 0, 0));
        this.CoalitionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Screen.this.CoalitionsButton_actionPerformed(e);
            }
        });
        this.jSplitPane2.add((Component)this.jScrollPane1, "top");
        this.jSplitPane2.add((Component)this.jScrollPane2, "bottom");
        this.jScrollPane1.getViewport().add((Component)this._tasktree, null);
        this.jScrollPane2.getViewport().add((Component)this._alliancetree, null);
        this.jSplitPane1.add((Component)this.jSplitPane2, "left");
        this.jSplitPane1.add((Component)this._desktop, "right");
        this.contentPane.add((Component)this.jToolBar1, "North");
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this.jLabel1, null);
        this.jToolBar1.add((Component)this.ColorCombo, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.IconButton);
        this.jToolBar1.add(this.ColorKeyButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.TileButton);
        this.jToolBar1.add((Component)this.CascadeButton, null);
        this.jToolBar1.add((Component)this.CoalitionsButton, null);
        this.jToolBar1.add(this.component1, null);
        this.jSplitPane1.setDividerLocation(200);
        this.contentPane.add((Component)this.jSplitPane1, "Center");
        this.jMenuBar1.add(this.FileMenu);
        this.jMenuBar1.add(this.ViewMenu);
        this.FileMenu.add(this.MenuQuit);
        this.setJMenuBar(this.jMenuBar1);
        this.MenuLF.add(this.MetalLF);
        this.MenuLF.add(this.WindowsLF);
        this.MenuLF.add(this.MotifLF);
        this.LFgroup.add(this.MetalLF);
        this.LFgroup.add(this.WindowsLF);
        this.LFgroup.add(this.MotifLF);
        this.ViewMenu.add(this.MenuLF);
        this.ViewMenu.addSeparator();
        this.ViewMenu.add(this.IconCheckbox);
        this.ViewMenu.add(this.KeyCheckbox);
        this.ViewMenu.addSeparator();
        this.ViewMenu.add(this.TileMenuItem);
        this.ViewMenu.add(this.CascadeMenuItem);
    }

    @Override
    public void setVisible(boolean parm1) {
        if (!parm1) {
            Point p = this.getLocation();
            this.store.putInt(GUI_X, p.x);
            this.store.putInt(GUI_Y, p.y);
            Dimension d = this.getSize();
            this.store.putInt(GUI_W, d.width);
            this.store.putInt(GUI_H, d.height);
        } else if (this.store.exist(GUI_X)) {
            Point loc = this.getLocation();
            int x = this.store.getInt(GUI_X, loc.x);
            int y = this.store.getInt(GUI_Y, loc.y);
            this.setLocation(x, y);
            Dimension d = this.getPreferredSize();
            int w = this.store.getInt(GUI_W, d.width);
            int h = this.store.getInt(GUI_H, d.height);
            this.setSize(w, h);
        }
        super.setVisible(parm1);
    }

    public JTree getAllianceTree() {
        return this._alliancetree;
    }

    public JDesktopPane getDesktop() {
        return this._desktop;
    }

    public JTree getTaskTree() {
        return this._tasktree;
    }

    public static void main(String[] args) {
    }

    void ColorCombo_actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        this._owner.setColorSchema((ColorFactory.PropertyGetter)cb.getSelectedItem());
    }

    void TreeMaybePopUp(MouseEvent e) {
        TreePath p;
        Object src = e.getSource();
        if (e.isPopupTrigger() && src instanceof JTree && (p = ((JTree)src).getPathForLocation(e.getX(), e.getY())) != null) {
            final Object o = p.getLastPathComponent();
            JPopupMenu TaskTreePopUp = new JPopupMenu();
            JMenuItem PopUpDisplay = new JMenuItem();
            if (o instanceof VisTask) {
                PopUpDisplay.setText("Display");
                PopUpDisplay.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Screen.this._owner.setDisplayTask((VisTask)o);
                    }
                });
            } else if (o instanceof VisAlliance) {
                PopUpDisplay.setText("Move to Top");
                PopUpDisplay.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Screen.this._desktop.getDesktopManager().activateFrame((VisAlliance)o);
                    }
                });
            }
            TaskTreePopUp.add(PopUpDisplay);
            TaskTreePopUp.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void autoArrangeAlliances() {
        if (!this._desktopmanager.wasUserResized() && VisualAgent.getConfig().getAutoArrange()) {
            if (this._tiling) {
                this.tileAlliances();
            } else {
                this.cascadeAlliances();
            }
        }
    }

    public void tileAlliances() {
        this._tiling = true;
        DesktopManager dm = this._desktop.getDesktopManager();
        List alliances = this._owner.getAlliances();
        int remainder = alliances.size();
        if (remainder > 0) {
            Iterator i = alliances.iterator();
            int rows = (int)Math.round(Math.ceil(Math.sqrt(alliances.size())));
            int height = this._desktop.getHeight() / rows;
            int row = 0;
            while (row < rows) {
                int colls = (int)Math.round(Math.floor(remainder / (rows - row)));
                remainder -= colls;
                int width = this._desktop.getWidth() / colls;
                int coll = 0;
                while (coll < colls) {
                    VisAlliance a = (VisAlliance)i.next();
                    dm.setBoundsForFrame(a, coll * width, row * height, width, height);
                    a.arrange();
                    ++coll;
                }
                ++row;
            }
        }
    }

    public void cascadeAlliances() {
        this._tiling = false;
        DesktopManager dm = this._desktop.getDesktopManager();
        List alliances = this._owner.getAlliances();
        int width = this._desktop.getWidth() / 2;
        int height = this._desktop.getHeight() / 2;
        Iterator i = alliances.iterator();
        int pos = 0;
        while (i.hasNext()) {
            VisAlliance a = (VisAlliance)i.next();
            Dimension d = a.getPreferredSize();
            int w = width > d.width ? width : d.width;
            int h = height > d.height ? height : d.height;
            dm.setBoundsForFrame(a, pos * 23, pos * 23, w, h);
            ++pos;
            a.arrange();
            a.moveToFront();
        }
    }

    void MetalLF_actionPerformed(ActionEvent e) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            SwingUtilities.updateComponentTreeUI(this);
            this._alliancetree.setCellRenderer(new MyTreeCellRenderer());
            this._tasktree.setCellRenderer(new MyTreeCellRenderer());
            this._icons.setSize(this._icons.getPreferredSize());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void WindowsLF_actionPerformed(ActionEvent e) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            SwingUtilities.updateComponentTreeUI(this);
            this._alliancetree.setCellRenderer(new MyTreeCellRenderer());
            this._tasktree.setCellRenderer(new MyTreeCellRenderer());
            this._icons.setSize(this._icons.getPreferredSize());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void MotifLF_actionPerformed(ActionEvent e) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            SwingUtilities.updateComponentTreeUI(this);
            this._alliancetree.setCellRenderer(new MyTreeCellRenderer());
            this._tasktree.setCellRenderer(new MyTreeCellRenderer());
            this._icons.setSize(this._icons.getPreferredSize());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void Borland_actionPerformed(ActionEvent e) {
    }

    void MenuQuit_actionPerformed(ActionEvent e) {
        this._owner.quit();
    }

    void this_windowClosing(WindowEvent e) {
        this._owner.quit();
    }

    void KeyCheckbox_actionPerformed(ActionEvent e) {
        this._legend.setVisible(!this._legend.isVisible());
    }

    void TileButton_actionPerformed(ActionEvent e) {
        this.tileAlliances();
        this._tiling = true;
    }

    void CascadeButton_actionPerformed(ActionEvent e) {
        this.cascadeAlliances();
        this._tiling = false;
    }

    void CoalitionsButton_actionPerformed(ActionEvent e) {
        if (this.showfull) {
            this._tasktree.setModel(this._coalitionstreemodel);
        } else {
            this._tasktree.setModel(this._tasktreemodel);
        }
        this.showfull = !this.showfull;
    }

    private static class MyDesktopManager
    extends DefaultDesktopManager {
        private boolean _wasresize = false;

        public boolean wasUserResized() {
            return this._wasresize;
        }

        @Override
        public void endResizingFrame(JComponent f) {
            this._wasresize = true;
            super.endResizingFrame(f);
        }
    }
}

