/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.visio.visual.DISPLAYCONST;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class PhantomBorder
extends AbstractBorder
implements DISPLAYCONST {
    private static Border _standardshadow;
    protected int _thickness;
    protected Color _shadowcolor;
    protected Color _backcolor;
    static final float[] dash1;
    static final BasicStroke dashed;

    static {
        dash1 = new float[]{1.0f, 2.0f};
        dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    }

    public PhantomBorder(int thickness, Color shadowcolor, Color backcolor) {
        this._thickness = thickness;
        this._shadowcolor = shadowcolor;
        this._backcolor = backcolor;
    }

    public PhantomBorder() {
        this(SHADOWTHICK, SHADOWCOLOR, SHADOWBCOLOR);
    }

    public static Border createStandardShadow() {
        if (_standardshadow == null) {
            _standardshadow = new PhantomBorder();
        }
        return _standardshadow;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        Color oldColor = g.getColor();
        Stroke oldStroke = g2.getStroke();
        g.setColor(this._shadowcolor);
        int i = 0;
        while (i < this._thickness) {
            g.drawLine(x + this._thickness, y + height - i - 1, x + width, y + height - i - 1);
            g.drawLine(x + width - i - 1, y + this._thickness, x + width - i - 1, y + width);
            ++i;
        }
        g.setColor(this._backcolor);
        i = 0;
        while (i < this._thickness) {
            g.drawLine(x, y + height - i - 1, x + this._thickness - 1, y + height - i - 1);
            g.drawLine(x + width - i - 1, y, x + width - i - 1, y + this._thickness - 1);
            ++i;
        }
        g2.setStroke(dashed);
        g2.setColor(this._shadowcolor);
        g2.drawLine(x, y, x, y + height - this._thickness - 1);
        g2.drawLine(x, y, x + width - this._thickness - 1, y);
        g2.drawLine(x + width - this._thickness - 1, y + height - this._thickness - 1, x + width - this._thickness - 1, y);
        g2.drawLine(x + width - this._thickness - 1, y + height - this._thickness - 1, x, y + height - this._thickness - 1);
        g.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, this._thickness, this._thickness);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

