/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.visio.visual.AgentInfoPanel;
import across.visio.visual.ColorFactory;
import across.visio.visual.DISPLAYCONST;
import across.visio.visual.PhantomBorder;
import across.visio.visual.VisAgent;
import across.visio.visual.VisAgentInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;

public class PhantomAgent
extends JLabel
implements VisAgentInterface,
DISPLAYCONST {
    private VisAgent _owner;
    private Object _role;
    private boolean _infoon = false;

    public PhantomAgent(VisAgent owner) {
        this._owner = owner;
        this._role = "Other";
        this.refreshColor();
        this.setSize(AGENTWIDTH, AGENTHEIGHT);
        this.setPreferredSize(new Dimension(AGENTWIDTH, AGENTHEIGHT));
        this.setBorder(PhantomBorder.createStandardShadow());
        this.setForeground(AGENTTXTCOLOR);
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setText(String.valueOf(NAMEPREFIX) + "Phantom" + NAMESUFFIX);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PhantomAgent.this.this_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PhantomAgent.this.this_mouseReleased(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PhantomAgent.this.this_mouseExited(e);
            }
        });
    }

    public void setOwner(VisAgent owner) {
        this._owner = owner;
        this.setText(this._owner.getText());
        this._owner.addPhantom(this);
    }

    public void clearOwner() {
        this._owner.removePhantom(this);
    }

    @Override
    public String getType() {
        return this._owner.getType();
    }

    @Override
    public String getCountry() {
        return this._owner.getCountry();
    }

    @Override
    public String getCity() {
        return this._owner.getCity();
    }

    @Override
    public boolean getVisibility() {
        return this._owner.getVisibility();
    }

    @Override
    public void setRole(Object role) {
        this._role = role;
        this.refreshColor();
    }

    @Override
    public Object getRole() {
        return this._role;
    }

    @Override
    public List getCoalitions() {
        return this._owner.getCoalitions();
    }

    @Override
    public void refreshColor() {
        Color backGC = ColorFactory.getDefaultFactory().getColor(this);
        if (!this.getVisibility()) {
            backGC = backGC.darker();
        }
        this.setBackground(backGC);
    }

    void this_mousePressed(MouseEvent e) {
        this._infoon = true;
        AgentInfoPanel.DefaultAgentInfo.activate(e);
    }

    void this_mouseReleased(MouseEvent e) {
        if (this._infoon) {
            this._infoon = false;
            AgentInfoPanel.DefaultAgentInfo.deactivate(e);
        }
    }

    void this_mouseExited(MouseEvent e) {
        if (this._infoon) {
            this._infoon = false;
            AgentInfoPanel.DefaultAgentInfo.deactivate(e);
        }
    }
}

