/*
 * Decompiled with CFR 0.152.
 */
package across.visio.visual;

import across.visio.VisualAgent;
import across.visio.visual.VisAgentInterface;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ColorFactory {
    public static final String LEADER = "Coalition Leader";
    public static final String MEMBER = "Coalition Member";
    public static final String OTHER = "Other";
    private static final Color LEADERc = new Color(255, 192, 192);
    private static final Color MEMBERc = new Color(192, 192, 255);
    private static final Color OTHERc = new Color(192, 192, 128);
    private static final List PALETTE = VisualAgent.getConfig().getColors();
    private static ColorSchema defaultschema = new ColorSchema();
    public static final PropertyGetter roleGetter;
    public static final PropertyGetter typeGetter;
    public static final PropertyGetter countryGetter;
    public static final PropertyGetter cityGetter;
    private static ColorFactory defaultFactory;
    private HashMap _schemas = new HashMap();
    private ColorSchema _currentschema;
    private PropertyGetter _currentgetter;
    private List _listeners;

    static {
        defaultschema.putColor(LEADER, LEADERc);
        defaultschema.putColor(MEMBER, MEMBERc);
        defaultschema.putColor(OTHER, OTHERc);
        roleGetter = new PropertyGetter(){

            @Override
            public Object getProperty(VisAgentInterface a) {
                return a.getRole();
            }

            public String toString() {
                return "Role";
            }
        };
        typeGetter = new PropertyGetter(){

            @Override
            public Object getProperty(VisAgentInterface a) {
                return a.getType();
            }

            public String toString() {
                return "Type";
            }
        };
        countryGetter = new PropertyGetter(){

            @Override
            public Object getProperty(VisAgentInterface a) {
                return a.getCountry();
            }

            public String toString() {
                return "Country";
            }
        };
        cityGetter = new PropertyGetter(){

            @Override
            public Object getProperty(VisAgentInterface a) {
                return a.getCity();
            }

            public String toString() {
                return "City";
            }
        };
        defaultFactory = null;
    }

    public static ColorFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = new ColorFactory();
        }
        return defaultFactory;
    }

    private ColorFactory() {
        this._schemas.put(roleGetter, defaultschema);
        this._currentschema = new ColorSchema();
        this._currentgetter = countryGetter;
        this._listeners = new LinkedList();
    }

    public void setColorSchema(PropertyGetter g) {
        this._currentschema = (ColorSchema)this._schemas.get(g);
        this._currentgetter = g;
        if (this._currentschema == null) {
            this._currentschema = new ColorSchema();
            this._schemas.put(g, this._currentschema);
        }
        this.updateKeys();
    }

    protected void updateKeys() {
        Set keys = this._currentschema.getKeys();
        Iterator i = this._listeners.iterator();
        while (i.hasNext()) {
            ((ColorFactoryListener)i.next()).updateKeys(keys);
        }
    }

    public Color getColor(VisAgentInterface a) {
        return this._currentschema.getColorFor(this._currentgetter.getProperty(a));
    }

    public Color getKeyColor(Object key) {
        return this._currentschema.getKeyColor(key);
    }

    public void registerColorFactoryListener(ColorFactoryListener l) {
        this._listeners.add(l);
        l.updateKeys(this._currentschema.getKeys());
    }

    public void deregisterColorFactoryListener(ColorFactoryListener l) {
        this._listeners.remove(l);
    }

    public static abstract class PropertyGetter {
        public abstract Object getProperty(VisAgentInterface var1);
    }

    public static interface ColorFactoryListener {
        public void updateKeys(Set var1);
    }

    private static class ColorSchema {
        int _count = 0;
        HashMap _colors = new HashMap();

        public Color getColorFor(Object o) {
            Color c = (Color)this._colors.get(o);
            if (c == null) {
                if (this._count >= PALETTE.size()) {
                    this._count = 0;
                }
                c = (Color)PALETTE.get(this._count++);
                this._colors.put(o, c);
                defaultFactory.updateKeys();
            }
            return c;
        }

        public void putColor(Object key, Color value) {
            this._colors.put(key, value);
        }

        public Color getKeyColor(Object key) {
            return (Color)this._colors.get(key);
        }

        public Set getKeys() {
            return this._colors.keySet();
        }
    }
}

