/*
 * Decompiled with CFR 0.152.
 */
package across.visio.oldvisio;

import across.data.AgentData;
import across.data.Batch;
import across.data.ColumnData;
import across.data.Page;
import across.data.PublicParams;
import across.data.RelationInfo;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.visio.oldvisio.VisioConnectionAgent;
import aglobe.container.transport.Address;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.visio3D.Position2D;
import aglobe.visio3D.VisioCallbackListener;
import aglobe.visio3D.VisioConnection;
import aglobe.visio3D.ontology.Chart;
import aglobex.simulation.global.EntitiesPositionInfo;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.Configuration;
import aglobex.simulation.ontology.Param;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Visualizer
implements VisioCallbackListener,
GISTopicServerListener {
    private static final String VISIO_TYPE_PARAM = "Type";
    private VisioConnectionAgent owner;
    private List<EntityRecord> entityRecords = new ArrayList<EntityRecord>();
    private Map<String, EntityRecord> entityRecordByName = new HashMap<String, EntityRecord>();
    private Map<Address, EntityRecord> entityRecordByAddress = new HashMap<Address, EntityRecord>();
    public static VisioConnection visio;
    private boolean relInfoTopicSubscribed = false;
    private HashSet<String> relInfoSubscribers = new HashSet();
    private HashMap<String, LinkedList> relInfoCache = new HashMap();
    private HashMap<String, ColumnData> checker = new HashMap();
    Map<String, Map<String, String>> agentInfoParams = new HashMap<String, Map<String, String>>();
    private Configuration conf;
    private EntitiesPositionInfo lastPos;
    private short[] slotIndexToVisioIndex;
    private Position2D[] pos;
    private HashMap<String, HashSet<Long>> contracts = new HashMap();
    private HashMap batchIdToRequestId = new HashMap();
    private final int contractsToDisplay = 15;
    private LinkedList<String> contractIdsForDisplay = new LinkedList();
    private HashMap<String, LinkedList<Batch>> batchInContainer = new HashMap();
    private short humagentContainerId;
    private Address humagentAddress = null;
    private String humagentContainer = null;
    private boolean contractsIdsVisible = false;
    private String nowShowing = null;
    private LinkedList leftBatches = new LinkedList();

    private Visualizer(VisioConnectionAgent owner, Configuration conf) {
        this.owner = owner;
        this.conf = conf;
        if (this.slotIndexToVisioIndex == null) {
            this.slotIndexToVisioIndex = new short[conf.getMaxEntities()];
            Arrays.fill(this.slotIndexToVisioIndex, (short)-1);
        }
        this.pos = new Position2D[conf.getMaxEntities()];
        int i = 0;
        while (i < this.pos.length) {
            this.pos[i] = new Position2D(-1, 0.0);
            this.pos[i].logged = false;
            ++i;
        }
        try {
            String visioConf = null;
            for (Param param : conf.getParam()) {
                if (!param.getName().equals("VISIO_CONFIGURATION")) continue;
                visioConf = param.getValue();
            }
            visio = new VisioConnection(visioConf);
            visio.sendReset();
            visio.registerCallbackListener(this);
        }
        catch (Exception ex1) {
            owner.getLogger().warning(ex1.toString());
        }
    }

    public static Visualizer newInstance(VisioConnectionAgent owner, Configuration conf) {
        return new Visualizer(owner, conf);
    }

    synchronized void entityLogged(EntityRecord er) {
        if (!this.entityRecords.contains(er)) {
            this.entityRecords.add(er);
            this.entityRecordByAddress.put(er.address, er);
            this.entityRecordByName.put(er.containerName, er);
            this.createEntityInVisio(er);
        }
    }

    private void createEntityInVisio(EntityRecord er) {
        if (visio != null) {
            short visInd;
            this.slotIndexToVisioIndex[er.indexToSlotArray] = visInd = visio.sendCreateObject(er.entityDescriptor.confParamsString.get("ENTITY_VISIO_NAME"), er.entityDescriptor.confParamsString.get("ENTITY_VISIO_OBJECT"), er.entityDescriptor.confParamsString.get("ENTITY_VISIO_TEXTURE"), -1.0);
            this.pos[visInd].logged = true;
            this.pos[visInd].objectIndex = visInd;
        }
    }

    synchronized void entityLogout(EntityRecord er) {
        short ind = this.slotIndexToVisioIndex[er.indexToSlotArray];
        this.slotIndexToVisioIndex[er.indexToSlotArray] = -1;
        this.entityRecords.remove(er);
        this.entityRecordByAddress.remove(er.address);
        this.entityRecordByName.remove(er.containerName);
        visio.sendDestroyObject(ind);
    }

    synchronized void entityCrashed(String contName) {
        final EntityRecord er = this.entityRecordByName.get(contName);
        short ind = this.slotIndexToVisioIndex[er.indexToSlotArray];
        visio.sendShowAction(contName, ind, (byte)41);
        this.owner.scheduleEvent(new Runnable(){

            @Override
            public void run() {
                Visualizer.this.entityLogout(er);
            }
        }, 1000L);
    }

    synchronized void positionUpdate(EntitiesPositionInfo epi) {
        if (visio != null) {
            for (EntityRecord er : this.entityRecords) {
                short ind = this.slotIndexToVisioIndex[er.indexToSlotArray];
                if (ind == -1) continue;
                this.pos[ind].positionUpdated = true;
                this.pos[ind].X = epi.x[er.indexToSlotArray];
                this.pos[ind].Y = epi.y[er.indexToSlotArray];
                visio.sendPostionUpdate(this.pos);
                this.pos[ind].positionUpdated = false;
            }
            this.lastPos = epi;
        }
    }

    synchronized void incomingCommunication(Address from, Address to) {
        EntityRecord f = this.entityRecordByAddress.get(from.deriveContainerAddress());
        EntityRecord t = this.entityRecordByAddress.get(to.deriveContainerAddress());
        if (f != null && t != null && visio != null) {
            short fromInd = this.slotIndexToVisioIndex[f.indexToSlotArray];
            short toInd = this.slotIndexToVisioIndex[t.indexToSlotArray];
            if (fromInd != -1 && toInd != -1) {
                visio.sendCommunication(fromInd, toInd, (byte)2);
            }
        }
    }

    synchronized void sendCodeTransferToVisio(String from, Address to) {
        EntityRecord f = this.entityRecordByName.get(from);
        EntityRecord t = this.entityRecordByAddress.get(to.deriveContainerAddress());
        if (f != null && t != null && visio != null) {
            short fromInd = this.slotIndexToVisioIndex[f.indexToSlotArray];
            short toInd = this.slotIndexToVisioIndex[t.indexToSlotArray];
            if (fromInd != -1 && toInd != -1) {
                visio.sendCommunication(fromInd, toInd, (byte)4);
            }
        }
    }

    synchronized void incomingAgentInfo(Page page) {
        Address entityAddress = page.getAddress().deriveContainerAddress();
        EntityRecord en = this.entityRecordByAddress.get(entityAddress);
        if (en != null && visio != null) {
            PublicParams pubPar;
            Map<String, String> params = this.agentInfoParams.get(page.getName());
            if (params == null) {
                params = new HashMap<String, String>();
                this.agentInfoParams.put(page.getName(), params);
            }
            if (!(pubPar = page.getPublicParams()).getType().equals("")) {
                params.put(VISIO_TYPE_PARAM, pubPar.getType());
            }
            for (across.data.Param param : pubPar.getParam()) {
                if (!param.getValue().equals("")) {
                    params.put(param.getName(), param.getValue());
                    continue;
                }
                params.remove(param.getName());
            }
            short ind = this.slotIndexToVisioIndex[en.indexToSlotArray];
            if (ind != -1) {
                visio.sendAgentInfo(page.getName(), ind, params);
            }
        }
    }

    synchronized void incomingAgentInfoRemoved(Address agentAddress) {
        Address entityAddress = agentAddress.deriveContainerAddress();
        EntityRecord en = this.entityRecordByAddress.get(entityAddress);
        if (en != null && visio != null) {
            this.agentInfoParams.remove(agentAddress.getName());
            visio.sendRemoveAgent(agentAddress.getName());
            this.owner.getLogger().fine("Send agent info removed: " + agentAddress);
        }
    }

    synchronized void updateVisioInfo(String entityName, String newText) {
        EntityRecord en = this.entityRecordByName.get(entityName);
        if (en != null) {
            short ind;
            if (visio != null && (ind = this.slotIndexToVisioIndex[en.indexToSlotArray]) != -1) {
                visio.sendObjectInfo(ind, newText);
            }
        } else {
            this.owner.getLogger().warning("Receiving update visio text for unknown entity name: " + entityName);
        }
    }

    synchronized void updateVisioInfo(String entityName, byte load) {
        EntityRecord en = this.entityRecordByName.get(entityName);
        if (en != null) {
            short ind;
            if (visio != null && (ind = this.slotIndexToVisioIndex[en.indexToSlotArray]) != -1) {
                visio.sendSpecialCarLoad(ind, load);
            }
        } else {
            this.owner.getLogger().warning("Receiving load update for unknown entity name: " + entityName);
        }
    }

    synchronized void showVisioAction(String entityName, Address agentAddress, byte action) {
        EntityRecord en = this.entityRecordByName.get(entityName);
        if (en != null) {
            short ind;
            if (visio != null && (ind = this.slotIndexToVisioIndex[en.indexToSlotArray]) != -1) {
                visio.sendShowAction(agentAddress.getName(), ind, action);
            }
        } else {
            this.owner.getLogger().warning("Receiving load update for unknown entity name: " + entityName);
        }
    }

    synchronized void visioSetChart(String entityName, String chartName, Chart chartDefinition) {
        EntityRecord en = this.entityRecordByName.get(entityName);
        if (en != null) {
            short ind;
            if (visio != null && (ind = this.slotIndexToVisioIndex[en.indexToSlotArray]) != -1) {
                visio.sendSetChart(ind, chartName, chartDefinition);
            }
        } else {
            this.owner.getLogger().warning("Receiving set chart for unknown entity name: " + entityName);
        }
    }

    synchronized void visioRemoveChart(String entityName, String chartName) {
        EntityRecord en = this.entityRecordByName.get(entityName);
        if (en != null) {
            short ind;
            if (visio != null && (ind = this.slotIndexToVisioIndex[en.indexToSlotArray]) != -1) {
                visio.sendRemoveChart(ind, chartName);
            }
        } else {
            this.owner.getLogger().warning("Receiving remove chart for unknown entity name: " + entityName);
        }
    }

    @Override
    public void visioPlanStart(short objectIndex) {
    }

    @Override
    public void visioPlanStop(short objectIndex) {
    }

    @Override
    public void visioSetSimulationSpeed(short speed) {
    }

    @Override
    public void visioReceivedScreenShotData(short screenShotID, BufferedImage screenShot) {
    }

    @Override
    public void visioRelInfoStart(String agentName, short containerID) {
        if (!this.relInfoTopicSubscribed) {
            this.relInfoTopicSubscribed = true;
            this.owner.gisShell.subscribeTopic("VISIO_REL_INFO", this);
            this.owner.gisShell.broadcastTopic("VISIO_REL_INFO", "SEND UPDATE PLEASE");
        }
        if (this.relInfoSubscribers.contains(String.valueOf(agentName) + containerID)) {
            return;
        }
        this.relInfoSubscribers.add(String.valueOf(agentName) + containerID);
        this.sendRelInfoToVisio(agentName, containerID);
    }

    @Override
    public void visioRelInfoEnd(String agentName, short containerID) {
        if (!this.relInfoSubscribers.contains(String.valueOf(agentName) + containerID)) {
            return;
        }
        this.relInfoSubscribers.remove(String.valueOf(agentName) + containerID);
    }

    private synchronized void parseRelInfoUpdate(RelationInfo relInfoUpdate, String remoteContainerName) {
        LinkedList<ColumnData> curRelInfo = this.relInfoCache.get(relInfoUpdate.getOwnerAgentName());
        this.owner.logSevere(relInfoUpdate.toString());
        if (curRelInfo == null) {
            curRelInfo = new LinkedList<ColumnData>();
            this.relInfoCache.put(relInfoUpdate.getOwnerAgentName(), curRelInfo);
        }
        for (ColumnData item : relInfoUpdate.getColumnData()) {
            if (this.checker.get(String.valueOf(relInfoUpdate.getOwnerAgentName()) + item.getColumnTitle()) != null) {
                int pos = -1;
                int position = -1;
                Iterator iterator = curRelInfo.iterator();
                while (iterator.hasNext()) {
                    ++pos;
                    ColumnData cd = (ColumnData)iterator.next();
                    if (!cd.getColumnTitle().equals(item.getColumnTitle())) continue;
                    position = pos;
                    break;
                }
                if (position == -1) {
                    System.out.println("conceptual error in column cache");
                }
                curRelInfo.remove(position);
                curRelInfo.add(position, item);
            } else {
                curRelInfo.add(item);
            }
            this.checker.put(String.valueOf(relInfoUpdate.getOwnerAgentName()) + item.getColumnTitle(), item);
        }
        this.sendRelInfoToVisio(relInfoUpdate.getOwnerAgentName(), this.slotIndexToVisioIndex[this.entityRecordByName.get((Object)remoteContainerName).indexToSlotArray]);
    }

    private synchronized void sendRelInfoToVisio(String agentName, short visioObjectID) {
        List curRelInfo = this.relInfoCache.get(agentName);
        if (curRelInfo == null) {
            return;
        }
        if (visio != null) {
            int colNum = curRelInfo.size();
            String[] aColumnTitle = new String[colNum];
            String[][] aAgentName = new String[colNum][];
            short[][] aContainerID = new short[colNum][];
            String[][] aInfoString = new String[colNum][];
            byte[][] infoColor = new byte[colNum][];
            int i = 0;
            for (ColumnData column : curRelInfo) {
                int agtNum = column.getAgentData().size();
                aAgentName[i] = new String[agtNum];
                aContainerID[i] = new short[agtNum];
                aInfoString[i] = new String[agtNum];
                infoColor[i] = new byte[agtNum];
                aColumnTitle[i] = column.getColumnTitle();
                int j = 0;
                for (AgentData elem1 : column.getAgentData()) {
                    aAgentName[i][j] = elem1.getAgentName();
                    aContainerID[i][j] = this.slotIndexToVisioIndex[this.entityRecordByName.get((Object)elem1.getContainerName()).indexToSlotArray];
                    aInfoString[i][j] = elem1.getInfoString();
                    infoColor[i][j] = elem1.getInfoColor();
                    ++j;
                }
                ++i;
            }
            visio.sendRelationInfoUpdate(visioObjectID, agentName, aColumnTitle, aAgentName, aContainerID, aInfoString, infoColor);
        }
    }

    @Override
    public synchronized void visioSendRequestsIDsStart() {
        this.contractsIdsVisible = true;
        this.visioSendRequestsIDs();
        if (this.nowShowing != null) {
            this.displayBatchList();
        }
    }

    @Override
    public synchronized void visioSendRequestsIDsEnd() {
        this.contractsIdsVisible = false;
    }

    public synchronized void visioSendRequestsIDs() {
        visio.sendShowRequestIDs(this.humagentContainerId, this.contractIdsForDisplay);
    }

    public synchronized void setHumanitarianContainer(Address humAddress, String humContainer) {
        this.humagentContainerId = this.slotIndexToVisioIndex[this.entityRecordByName.get((Object)humContainer).indexToSlotArray];
        this.humagentAddress = humAddress;
        this.humagentContainer = humContainer;
    }

    @Override
    public synchronized void visioBatchInfoStart(String requestID) {
        this.nowShowing = requestID;
        this.displayBatchList();
    }

    @Override
    public void visioBatchInfoEnd(String requestID) {
        this.nowShowing = null;
    }

    private void fillText(String containerName) {
        short ind;
        String text = "";
        int rows = 0;
        LinkedList<Batch> visibleList = this.batchInContainer.get(containerName);
        if (visibleList != null && visibleList.size() != 0) {
            for (Batch batch : visibleList) {
                String requestID = (String)this.batchIdToRequestId.get(batch.getBatchid());
                if (requestID == null || !requestID.equals(this.nowShowing)) continue;
                text = String.valueOf(text) + batch.getComodityName() + " (" + batch.getCount() + ")<n>";
                ++rows;
            }
            if (rows != 0) {
                text = "<b>" + containerName + ":<n><r>" + text;
            }
        }
        if ((ind = this.slotIndexToVisioIndex[this.entityRecordByName.get((Object)containerName).indexToSlotArray]) != -1) {
            visio.sendBatchInfo(ind, text);
        }
    }

    private void fillStolenBatches(Position pos, LinkedList visibleList) {
        String text = "";
        int rows = 0;
        if (visibleList != null && visibleList.size() != 0) {
            for (Batch batch : visibleList) {
                text = String.valueOf(text) + batch.getComodityName() + " (" + batch.getCount() + ")<n>";
                ++rows;
            }
            if (rows != 0) {
                text = "<b>stolen <r>from <b>" + pos.containerName + ":<n><r>" + text;
            }
            visio.sendBatchInfo(pos.x, pos.y, text);
        }
    }

    private void displayBatchList() {
        Set<String> keys = this.batchInContainer.keySet();
        for (String container : keys) {
            this.fillText(container);
        }
        for (Position pos : this.leftBatches) {
            LinkedList completeBatchList = pos.batchList;
            LinkedList<Batch> stolenToDisplay = new LinkedList<Batch>();
            for (Batch b : completeBatchList) {
                String reqId = (String)this.batchIdToRequestId.get(b.getBatchid());
                if (reqId == null || !reqId.equals(this.nowShowing)) continue;
                stolenToDisplay.add(b);
            }
            this.fillStolenBatches(pos, stolenToDisplay);
        }
    }

    private LinkedList convertBatches(LinkedList batches) {
        LinkedList<Batch> val = new LinkedList<Batch>();
        Iterator i = batches.iterator();
        while (i.hasNext()) {
            val.addLast(this.convertLoadBatch((Batch)i.next()));
        }
        return val;
    }

    public synchronized void batchesLeft(LinkedList stolenBatches, String containerName) {
        stolenBatches = this.convertBatches(stolenBatches);
        EntityRecord entity = this.entityRecordByName.get(containerName);
        if (entity == null) {
            this.owner.logSevere("Unknown container: " + containerName);
            return;
        }
        Position pos = new Position(this.lastPos.y[entity.indexToSlotArray], this.lastPos.x[entity.indexToSlotArray], containerName, stolenBatches);
        this.leftBatches.add(pos);
        LinkedList<Batch> batchesInContainer = this.batchInContainer.get(containerName);
        for (Batch b : stolenBatches) {
            Batch unloadedBatch = null;
            if (batchesInContainer == null) continue;
            for (Batch b2 : batchesInContainer) {
                if (b2.getBatchid() != b.getBatchid() || b2.getCount() != b.getCount()) continue;
                unloadedBatch = b2;
                break;
            }
            if (unloadedBatch != null) {
                batchesInContainer.remove(unloadedBatch);
                continue;
            }
            System.out.println("no such batch error");
        }
        this.displayBatchList();
    }

    public synchronized void addNewContract(TransportCfp tcfp) {
        HashSet<Long> batches;
        if (!this.contractIdsForDisplay.contains(tcfp.getRequestid())) {
            this.contractIdsForDisplay.addLast(tcfp.getRequestid());
            if (this.contractIdsForDisplay.size() > 15) {
                this.contractIdsForDisplay.removeFirst();
                this.contracts.remove(tcfp.getRequestid());
            }
            if (this.contractsIdsVisible) {
                this.visioSendRequestsIDs();
            }
        }
        if ((batches = this.contracts.get(tcfp.getRequestid())) == null) {
            batches = new HashSet();
            this.contracts.put(tcfp.getRequestid(), batches);
        }
        for (TransportBatch b2 : tcfp.getTransportBatch()) {
            Batch b = new Batch();
            b.setBatchid(b2.getBatchid());
            b.setComodityName(b2.getComodityName());
            b.setCount(b2.getCount());
            b = this.convertLoadBatch(b);
            this.batchIdToRequestId.put(b.getBatchid(), tcfp.getRequestid());
            batches.add(b.getBatchid());
            if (this.humagentAddress == null || !this.humagentAddress.equals(b2.getStartAddress())) continue;
            LinkedList<Batch> bts = this.batchInContainer.get(this.humagentContainer);
            if (bts == null) {
                bts = new LinkedList();
                this.batchInContainer.put(this.humagentContainer, bts);
            }
            bts.add(b);
        }
        this.displayBatchList();
    }

    public synchronized void addNewContract(List batchList, String requestID) {
        HashSet<Long> batches;
        if (!this.contractIdsForDisplay.contains(requestID)) {
            this.contractIdsForDisplay.addLast(requestID);
            if (this.contractIdsForDisplay.size() > 15) {
                this.contractIdsForDisplay.removeFirst();
                this.contracts.remove(requestID);
            }
            if (this.contractsIdsVisible) {
                this.visioSendRequestsIDs();
            }
        }
        if ((batches = this.contracts.get(requestID)) == null) {
            batches = new HashSet();
            this.contracts.put(requestID, batches);
        }
        for (TransportBatch b2 : batchList) {
            Batch b = new Batch();
            b.setBatchid(b2.getBatchid());
            b.setComodityName(b2.getComodityName());
            b.setCount(b2.getCount());
            b = this.convertLoadBatch(b);
            this.batchIdToRequestId.put(b.getBatchid(), requestID);
            batches.add(b.getBatchid());
            if (this.humagentAddress == null || !this.humagentAddress.equals(b2.getStartAddress())) continue;
            LinkedList<Batch> bts = this.batchInContainer.get(this.humagentContainer);
            if (bts == null) {
                bts = new LinkedList();
                this.batchInContainer.put(this.humagentContainer, bts);
            }
            bts.add(b);
        }
        this.displayBatchList();
    }

    public synchronized void batchLoadedOnContainer(Batch b, String containerName) {
        b = this.convertLoadBatch(b);
        System.out.println("LOADED BATCH ON " + containerName + " " + b.toString());
        String request = (String)this.batchIdToRequestId.get(b.getBatchid());
        LinkedList<Batch> batchesInContainer = this.batchInContainer.get(containerName);
        if (batchesInContainer == null) {
            batchesInContainer = new LinkedList();
            this.batchInContainer.put(containerName, batchesInContainer);
        }
        batchesInContainer.add(b);
        this.displayBatchList();
    }

    private Batch convertLoadBatch(Batch b) {
        Batch val = new Batch();
        val.setCount(Math.abs(b.getCount()));
        val.setBatchid(b.getBatchid());
        val.setComodityName(b.getComodityName());
        return val;
    }

    private Batch convertUnloadBatch(Batch b) {
        Batch val = new Batch();
        val.setCount(-Math.abs(b.getCount()));
        val.setBatchid(b.getBatchid());
        val.setComodityName(b.getComodityName());
        return val;
    }

    public synchronized void batchUnloadedFromContainer(Batch b, String containerName) {
        b = this.convertUnloadBatch(b);
        String request = (String)this.batchIdToRequestId.get(b.getBatchid());
        LinkedList<Batch> batchesInContainer = this.batchInContainer.get(containerName);
        if (batchesInContainer == null) {
            batchesInContainer = new LinkedList();
            this.batchInContainer.put(containerName, batchesInContainer);
        }
        batchesInContainer.add(b);
        this.displayBatchList();
    }

    @Override
    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    @Override
    public void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    @Override
    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals("VISIO_REL_INFO")) {
            if (remoteContainerName != null) {
                this.parseRelInfoUpdate((RelationInfo)content, remoteContainerName);
            }
            return;
        }
        this.owner.logSevere("Unexpected incoming topic: " + topic);
    }

    @Override
    public void addEvent(Runnable e) {
        this.owner.addEvent(e);
    }

    @Override
    public void visioAircraftSelected(short containerID) {
        throw new RuntimeException("Don't use me!");
    }

    private class Position {
        public double x;
        public double y;
        public String containerName;
        public LinkedList batchList;

        public Position(double x, double y, String containerName, LinkedList batchList) {
            this.x = x;
            this.y = y;
            this.containerName = containerName;
            this.batchList = batchList;
        }
    }
}

