/*
 * Decompiled with CFR 0.152.
 */
package across.visio.oldvisio;

import across.data.Batch;
import across.data.Page;
import across.visio.oldvisio.Visualizer;
import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.CommunicationInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.visio3D.ontology.Chart;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.global.EntitiesPositionInfo;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.global.ServerServerTopicConstants;
import aglobex.simulation.ontology.Configuration;
import java.util.LinkedList;
import java.util.List;

public class VisioConnectionAgent
extends Agent
implements GISTopicServerListener,
ClientServerTopicConstants,
ServerServerTopicConstants {
    public static final String TOPIC_VISIO_INFO = "VISIO_INFO";
    public static final String TOPIC_PAGE_UPDATE = "PAGE_UPDATE";
    public static final String TOPIC_PAGE_REMOVED = "PAGE_REMOVED";
    public static final String TOPIC_LOAD_STATUS = "LOAD_STATUS";
    public static final String TOPIC_SET_CHART = "SET_CHART";
    public static final String TOPIC_REMOVE_CHART = "REMOVE_CHART";
    public static final String TOPIC_CODE_TRANSFER = "CODE_TRANSFER";
    public static final String TOPIC_VISIO_ACTION = "VISIO_ACTION";
    public static final String TOPIC_VISIO_REL_INFO = "VISIO_REL_INFO";
    public static final String TOPIC_NEW_CONTRACT = "NEW_CONTRACT";
    public static final String TOPIC_HUMAGENT_CONTAINER = "HUMAGENT_CONTAINER";
    public static final String TOPIC_BATCH_LOADED_ON_LOCATION = "BATCH_LOADED_ON_LOCATION";
    public static final String TOPIC_BATCH_UNLOADED_FROM_LOCATION = "BATCH_UNLOADED_FROM_LOCATION";
    public static final String TOPIC_BATCH_LOADED_ON_DRIVER = "BATCH_LOADED_ON_DRIVER";
    public static final String TOPIC_BATCH_UNLOADED_FROM_DRIVER = "BATCH_LOADED_FROM_DRIVER";
    public static final String TOPIC_BATCHES_LEFT_IN_SPACE = "BATCH_LEFT_IN_SPACE";
    public static final byte ACTION_LOAD = 1;
    public static final byte ACTION_UNLOAD = 2;
    public static final byte ACTION_CFP_GOODS = 11;
    public static final byte ACTION_CFP_TRANSPORT = 12;
    public static final byte ACTION_TRANSPORT_START = 21;
    public static final byte ACTION_GOODS_STOLEN = 41;
    public static final byte ACTION_VEHICLE_DESTROYED = 42;
    public static final byte ACTION_GOODS_FRAUDED = 45;
    public static final byte ACTION_STANDIN_CREATED = 51;
    public static final byte ACTION_STANDIN_KILLED = 52;
    public static final byte ACTION_STANDIN_MIG_OUT = 53;
    public static final byte ACTION_STANDIN_MIG_IN = 54;
    public static final byte ACTION_STANDIN_CLONNED = 55;
    public static final byte ACTION_POLL_START = 71;
    public static final byte ACTION_POLL_YES = 72;
    public static final byte ACTION_POLL_NO = 73;
    public static final byte ACTION_POLL_EXPELLED = 74;
    public static final byte ACTION_VEHICLE_STOPPED = 81;
    public static final byte ACTION_CONVOY_STARTED = 82;
    GISServerService.Shell gisShell;
    private Visualizer visualizer;
    private Configuration conf;

    @Override
    public void init(AgentInfo ai, int initState) {
        super.init(ai, initState);
        this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisShell != null) {
            this.gisShell.subscribeTopic(TOPIC_PAGE_UPDATE, this);
            this.gisShell.subscribeTopic(TOPIC_PAGE_REMOVED, this);
            this.gisShell.subscribeTopic("COMMUNICATION_INFO", this);
            this.gisShell.subscribeTopic(TOPIC_VISIO_INFO, this);
            this.gisShell.subscribeTopic(TOPIC_LOAD_STATUS, this);
            this.gisShell.subscribeTopic(TOPIC_VISIO_ACTION, this);
            this.gisShell.subscribeTopic(TOPIC_SET_CHART, this);
            this.gisShell.subscribeTopic(TOPIC_REMOVE_CHART, this);
            this.gisShell.subscribeTopic(TOPIC_CODE_TRANSFER, this);
            this.gisShell.subscribeTopic(TOPIC_HUMAGENT_CONTAINER, this);
            this.gisShell.subscribeTopic(TOPIC_NEW_CONTRACT, this);
            this.gisShell.subscribeTopic(TOPIC_BATCH_LOADED_ON_LOCATION, this);
            this.gisShell.subscribeTopic(TOPIC_BATCH_UNLOADED_FROM_LOCATION, this);
            this.gisShell.subscribeTopic(TOPIC_BATCH_LOADED_ON_DRIVER, this);
            this.gisShell.subscribeTopic(TOPIC_BATCH_UNLOADED_FROM_DRIVER, this);
            this.gisShell.subscribeTopic(TOPIC_BATCHES_LEFT_IN_SPACE, this);
        } else {
            this.logger.severe("VisioConnectionAgent must be started on the master container !!!");
        }
        this.gisShell.subscribeTopic("CONFIGURATION", this);
        this.gisShell.subscribeTopic("ENTITY_LOGGED", this);
        this.gisShell.subscribeTopic("ENTITY_LOGOUT", this);
        this.gisShell.subscribeTopic("POSITION_UPDATE", this);
        this.gisShell.subscribeTopic("ENTITY_CRASH", this);
        this.gisShell.sendTopicToLocal("CONFIGURATION_REQUEST", null, this.getName());
    }

    @Override
    protected void handleIncomingMessage(Message m) {
        this.logger.severe("Unexpected incoming message: " + m);
    }

    @Override
    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    @Override
    public void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    private void handleConfiguration() {
        if (this.conf == null) {
            this.logSevere("Null configuration!");
            throw new RuntimeException("Null configuration!");
        }
        if (this.visualizer == null) {
            this.visualizer = Visualizer.newInstance(this, this.conf);
            this.gisShell.sendTopicToLocal("CURRENT_ENTITIES_REQUEST", null, this.getName());
        }
    }

    @Override
    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equalsIgnoreCase("CONFIGURATION")) {
            this.conf = (Configuration)content;
            this.handleConfiguration();
        } else if (topic.equalsIgnoreCase("POSITION_UPDATE")) {
            this.visualizer.positionUpdate((EntitiesPositionInfo)content);
        } else if (!topic.equalsIgnoreCase("ENTITY_CRASH")) {
            if (topic.equalsIgnoreCase("ENTITY_LOGGED")) {
                this.visualizer.entityLogged((EntityRecord)content);
            } else if (topic.equalsIgnoreCase("ENTITY_LOGOUT")) {
                this.visualizer.entityLogout((EntityRecord)content);
            } else if (topic.equalsIgnoreCase("CURRENT_ENTITIES")) {
                this.visualizer.entityLogged((EntityRecord)content);
            } else if (topic.equalsIgnoreCase("COMMUNICATION_INFO")) {
                if (remoteContainerName != null && content instanceof CommunicationInfo) {
                    CommunicationInfo gi = (CommunicationInfo)content;
                    this.visualizer.incomingCommunication(gi.getFrom(), gi.getTo());
                }
            } else if (topic.equalsIgnoreCase(TOPIC_PAGE_UPDATE)) {
                if (content instanceof Page) {
                    this.visualizer.incomingAgentInfo((Page)content);
                } else {
                    this.logger.warning("Unknown type of agentInfo: " + content.getClass().getName());
                }
            } else if (topic.equalsIgnoreCase(TOPIC_VISIO_INFO) && (remoteContainerName != null || reason != null)) {
                if (remoteContainerName != null) {
                    this.visualizer.updateVisioInfo(remoteContainerName, (String)content);
                } else {
                    this.visualizer.updateVisioInfo(reason, (String)content);
                }
            } else if (topic.equalsIgnoreCase(TOPIC_LOAD_STATUS)) {
                byte load = 0;
                try {
                    load = Byte.parseByte((String)content);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.visualizer.updateVisioInfo(remoteContainerName, load);
            } else if (topic.equalsIgnoreCase(TOPIC_VISIO_ACTION) && remoteContainerName != null) {
                byte action = 0;
                try {
                    action = Byte.parseByte((String)content);
                }
                catch (NumberFormatException ex3) {
                    this.logger.warning("Bad action id: " + (String)content);
                    return;
                }
                Address agentAddress = Address.getAddress(reason);
                this.visualizer.showVisioAction(remoteContainerName, agentAddress, action);
            } else if (topic.equalsIgnoreCase(TOPIC_SET_CHART) && remoteContainerName != null) {
                this.visualizer.visioSetChart(remoteContainerName, reason, (Chart)content);
            } else if (topic.equalsIgnoreCase(TOPIC_SET_CHART) && remoteContainerName == null) {
                this.visualizer.visioSetChart(reason, reason, (Chart)content);
            } else if (topic.equalsIgnoreCase(TOPIC_REMOVE_CHART) && remoteContainerName != null) {
                this.visualizer.visioRemoveChart(remoteContainerName, reason);
            } else if (topic.equalsIgnoreCase(TOPIC_CODE_TRANSFER) && remoteContainerName != null) {
                this.visualizer.sendCodeTransferToVisio(remoteContainerName, Address.getAddress((String)content));
            } else if (topic.equalsIgnoreCase(TOPIC_NEW_CONTRACT) && remoteContainerName != null) {
                this.visualizer.addNewContract((List)content, reason);
            } else if (topic.equalsIgnoreCase(TOPIC_BATCH_LOADED_ON_DRIVER) && remoteContainerName != null) {
                Batch b = (Batch)content;
                this.visualizer.batchLoadedOnContainer(b, remoteContainerName);
            } else if (topic.equalsIgnoreCase(TOPIC_BATCH_UNLOADED_FROM_DRIVER) && remoteContainerName != null) {
                Batch b = (Batch)content;
                this.visualizer.batchUnloadedFromContainer(b, remoteContainerName);
            } else if (topic.equalsIgnoreCase(TOPIC_BATCH_LOADED_ON_LOCATION) && remoteContainerName != null) {
                Batch b = (Batch)content;
                this.visualizer.batchLoadedOnContainer(b, remoteContainerName);
            } else if (topic.equalsIgnoreCase(TOPIC_BATCH_UNLOADED_FROM_LOCATION) && remoteContainerName != null) {
                Batch b = (Batch)content;
                this.visualizer.batchUnloadedFromContainer(b, remoteContainerName);
            } else if (topic.equalsIgnoreCase(TOPIC_HUMAGENT_CONTAINER) && remoteContainerName != null) {
                this.visualizer.setHumanitarianContainer((Address)content, reason);
            } else if (topic.equalsIgnoreCase(TOPIC_BATCHES_LEFT_IN_SPACE) && remoteContainerName != null) {
                this.visualizer.batchesLeft((LinkedList)content, remoteContainerName);
            } else if (topic.equalsIgnoreCase(TOPIC_VISIO_REL_INFO)) {
                if (this.visualizer != null) {
                    this.visualizer.handleTopic(topic, content, reason, remoteContainerName, remoteClientAddress);
                }
            } else {
                this.logger.warning("Unexpected incoming topic: " + topic + " (" + remoteContainerName + ")");
            }
        }
    }
}

