/*
 * Decompiled with CFR 0.152.
 */
package across.visio;

import across.data.Batch;
import across.data.CoalitionDescription;
import across.data.Page;
import across.data.Param;
import across.data.Proposal;
import across.data.PublicParams;
import across.data.RequestList;
import across.data.TeamProposal;
import across.data.TransportCfp;
import across.visio.Config;
import across.visio.ont.AllianceDescription;
import across.visio.ont.CPlantAgentDescription;
import across.visio.ont.DFAgentDescription;
import across.visio.visual.Screen;
import across.visio.visual.VisAgent;
import across.visio.visual.Visualizer;
import aglobe.container.agent.CMAgent;
import aglobe.container.transport.Address;
import aglobe.container.transport.ContainerRecord;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class VisualAgent
extends CMAgent
implements MessageConstants,
GISTopicServerListener {
    public static final String TOPIC_NEW_COALITION = "NEW_COALITION";
    public static final String TOPIC_LOCATION_CFP_AND_PARTICIPANTS = "LOCATION_CFP_AND_PARTICIPANTS";
    public static final String TOPIC_LOCATION_RECEIVED_OFFER = "LOCATION_RECEIVED_OFFER";
    public static final String TOPIC_LOCATION_WINNER = "LOCATION_WINNER";
    public static final String TOPIC_LOCATION_REFUSED = "LOCATION_REFUSE";
    public static final String TOPIC_ACCEPTATION_RECEIVED = "ACCEPTATTION_RECEIVED";
    public static final String TOPIC_TEAM_MEMBER_PROPOSAL = "TEAM_MEMBER_PROPOSAL";
    public static final String TOPIC_TEAM_LEADER_PROPOSAL = "TEAM_LEADER_PROPOSAL";
    public static final String TOPIC_BEST_LEADER = "BEST_LEADER";
    public static final String TOPIC_COALITION_FINISHED = "COALITION_FINISHED";
    private static Config Configuration;
    private static String VISUALIZER;
    private boolean _quitting = false;
    int _replywith = 0;
    public String _name = "Visual Agent";
    boolean _down = false;
    public List citiesList = new LinkedList();
    private AgentInfo aInfo = new AgentInfo();
    private PublicParams publicParams = new PublicParams();
    private Visualizer visualizer;
    private List knownPlatforms = new LinkedList();
    private Set knownAgents = new HashSet();
    private Map fullNames = new HashMap();
    private GISServerService.Shell gisShell;
    private Map transportBatchesById = new HashMap();
    private Map locationBatches = new HashMap();
    private Map locationBatchesById = new HashMap();
    private Map locationNames = new HashMap();
    private Map refused = new HashMap();
    private Map receivedAcceptation = new HashMap();
    private Map bestProposals = new HashMap();
    private Map coalitions = new HashMap();
    public Screen gui;
    private Map alliances = new HashMap();
    Map visualPages = new HashMap();
    int iniMessagesNo = 0;

    static {
        VISUALIZER = "Visio";
    }

    public VisualAgent() {
        try {
            Configuration = new Config("xml/alianvisiocfg.xml");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void init(AgentInfo a, int initState) {
        super.init(a, initState);
        this.aInfo = a;
        this.visualizer = new Visualizer(this);
        this.gui = this.visualizer.getScreen();
        this.publicParams.setType("logickeVisio");
        this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisShell == null) {
            this.logger.severe("GISServerService not running");
            this.stop();
            return;
        }
        this.gisShell.subscribeTopic("PAGE_UPDATE", this);
        this.gisShell.subscribeTopic(TOPIC_NEW_COALITION, this);
        this.gisShell.subscribeTopic(TOPIC_TEAM_LEADER_PROPOSAL, this);
        this.gisShell.subscribeTopic(TOPIC_LOCATION_CFP_AND_PARTICIPANTS, this);
        this.gisShell.subscribeTopic(TOPIC_LOCATION_RECEIVED_OFFER, this);
        this.gisShell.subscribeTopic(TOPIC_LOCATION_WINNER, this);
        this.gisShell.subscribeTopic(TOPIC_LOCATION_REFUSED, this);
        this.gisShell.subscribeTopic(TOPIC_ACCEPTATION_RECEIVED, this);
        this.gisShell.subscribeTopic(TOPIC_TEAM_MEMBER_PROPOSAL, this);
        this.gisShell.subscribeTopic(TOPIC_BEST_LEADER, this);
        this.gisShell.subscribeTopic(TOPIC_COALITION_FINISHED, this);
    }

    public void newVisibleUpdateSet(List newSet) {
        newSet.removeAll(this.knownPlatforms);
        for (ContainerRecord containerRecord : newSet) {
        }
        this.knownPlatforms.addAll(newSet);
    }

    private boolean isVisible(List visPlatforms, Page agent) {
        for (ContainerRecord pr : visPlatforms) {
            Address addr = agent.getAddress();
            Address platformAddr = Address.getContainerAddress(addr.getHost(), addr.getPort(), addr.getContainerName());
            if (!platformAddr.equals(pr.address)) continue;
            this.visualizer.setVisibility(agent.getName(), true);
            return true;
        }
        return false;
    }

    public static Config getConfig() {
        return Configuration;
    }

    public void quit() {
        this.shutdown();
        this.kill();
    }

    public void shutdown() {
        this.visualizer.shutdown();
        this._down = true;
        Screen s = this.visualizer.getScreen();
        if (s != null) {
            s.dispose();
        }
    }

    public int getReplyWith() {
        return ++this._replywith;
    }

    public String getFullNameByType(String type) {
        for (VisAgent va : this.visualizer._agents) {
            if (!va.getType().equalsIgnoreCase(type)) continue;
            return va.getName();
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public void registerAgent(DFAgentDescription dfad, CPlantAgentDescription cpad) {
        this.visualizer.registerAgent(dfad, cpad);
    }

    public static String getPageValue(Page page, String paramName) {
        return VisualAgent.getParamValue(page.getPublicParams().getParam(), paramName);
    }

    public static String getAlliance(Page page) {
        String alliance = VisualAgent.getPageValue(page, "alliance-name");
        if (alliance == null) {
            alliance = "no-alliance";
        }
        return alliance;
    }

    public static String getParamValue(List params, String paramName) {
        for (Param param : params) {
            if (!paramName.equalsIgnoreCase(param.getName())) continue;
            return param.getValue();
        }
        return null;
    }

    public void removeEmptyAlliances() {
        for (String key : this.alliances.keySet()) {
            AllianceDescription ad = (AllianceDescription)this.alliances.get(key);
            if (ad.getMembers().size() != 0) continue;
            this.alliances.remove(key);
        }
    }

    public void registerAgent(Page p) {
        Page previous = (Page)this.visualPages.get(p.getName());
        if (previous != null && !VisualAgent.getAlliance(previous).equalsIgnoreCase(VisualAgent.getAlliance(p))) {
            AllianceDescription alliDesc = (AllianceDescription)this.alliances.get(VisualAgent.getAlliance(previous));
            List members = alliDesc.getMembers();
            members.remove(p.getName());
        }
        this.registerAgent(new DFAgentDescription(p.getName(), VisualAgent.getParamValue(p.getPublicParams().getParam(), "tribe"), "no owner"), new CPlantAgentDescription(p.getName(), VisualAgent.getParamValue(p.getPublicParams().getParam(), "location"), VisualAgent.getParamValue(p.getPublicParams().getParam(), "region")));
        String alli = VisualAgent.getAlliance(p);
        if (alli != null) {
            AllianceDescription alliDesc = (AllianceDescription)this.alliances.get(alli);
            if (alliDesc == null) {
                LinkedList<String> list = new LinkedList<String>();
                list.add(p.getName());
                alliDesc = new AllianceDescription();
                alliDesc.setMembers(list);
                alliDesc.setName(alli);
                this.alliances.put(alli, alliDesc);
            } else {
                alliDesc.getMembers().add(p.getName());
            }
            this.newAlliance(alliDesc);
        }
        if (this.knownAgents.contains(p.getName())) {
            return;
        }
        this.fullNames.put(p.getAddress(), p.getName());
        this.knownAgents.add(p.getName());
        this.visualPages.put(p.getAddress(), p);
    }

    public void deregisterAgent(DFAgentDescription dfad) {
        this.visualizer.deregisterAgent(dfad);
    }

    public void newAlliance(final AllianceDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    VisualAgent.this.visualizer.newAlliance(ad);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void newCoalition(CoalitionDescription cd, String locationInitiatorName, String id) {
        if (cd == null || locationInitiatorName == null) {
            System.out.println("cd " + cd);
            System.out.println("locationName " + locationInitiatorName);
            return;
        }
        if (this.visualizer.newCoalition(cd, locationInitiatorName, Visualizer.parseId(id, 0), Visualizer.parseId(id, 1))) {
            this.coalitions.remove(id);
        } else {
            System.out.println("coalition wasn't displayed");
        }
    }

    public void dlog(String str) {
        System.out.println(str);
    }

    public void incIniMessCount() {
        ++this.iniMessagesNo;
    }

    public String getFullName(String name) {
        return (String)this.fullNames.get(name);
    }

    @Override
    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    @Override
    public void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    @Override
    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        String transporterInitiator;
        String locationInitiator;
        Proposal p;
        List data;
        if (topic.equalsIgnoreCase("PAGE_UPDATE")) {
            final Page p2 = (Page)content;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VisualAgent.this.registerAgent(p2);
                }
            });
        }
        if (topic.equalsIgnoreCase(TOPIC_NEW_COALITION)) {
            data = (List)content;
            this.coalitions.put((String)data.get(0), (CoalitionDescription)data.get(1));
        }
        if (topic.equalsIgnoreCase(TOPIC_TEAM_LEADER_PROPOSAL)) {
            data = (List)content;
            p = (Proposal)data.get(0);
            TransportCfp tcfp = (TransportCfp)data.get(1);
            String transporter = (String)data.get(2);
            Proposal myProposal = (Proposal)data.get(3);
            TeamProposal teamProposal = (TeamProposal)data.get(4);
            if (Visualizer.parseId(tcfp.getRequestid(), 2) == null) {
                this.addTransportLeaderProposal(p, transporter, tcfp, myProposal, teamProposal);
            } else {
                String transporterInitiator2 = Visualizer.parseId(tcfp.getRequestid(), 2);
                tcfp.setRequestid(Visualizer.parseId(tcfp.getRequestid(), 0));
                p.setRequestid(Visualizer.parseId(p.getRequestid(), 0));
                this.addTransportLeaderSubcontractProposal(p, transporter, tcfp, transporterInitiator2, myProposal, teamProposal);
            }
        }
        if (topic.equalsIgnoreCase(TOPIC_LOCATION_CFP_AND_PARTICIPANTS)) {
            this.addLocationCFP((List)content);
        }
        if (topic.equalsIgnoreCase(TOPIC_LOCATION_RECEIVED_OFFER)) {
            this.newLocationOffer((List)content);
        }
        if (topic.equalsIgnoreCase(TOPIC_LOCATION_WINNER)) {
            this.locationWinner((Message)content);
        }
        if (topic.equalsIgnoreCase(TOPIC_LOCATION_REFUSED)) {
            this.locationRefused((Message)content);
        }
        if (topic.equalsIgnoreCase(TOPIC_ACCEPTATION_RECEIVED)) {
            this.acceptationReceived((Message)content);
        }
        if (topic.equalsIgnoreCase(TOPIC_TEAM_MEMBER_PROPOSAL) && (p = (Proposal)(data = (List)content).get(0)) != null) {
            String proposer;
            TeamProposal tp;
            if (Visualizer.parseId(p.getRequestid(), 2) == null) {
                tp = (TeamProposal)data.get(1);
                locationInitiator = Visualizer.parseId(p.getRequestid(), 1);
                proposer = (String)data.get(2);
                this.visualizer.addTeamMemberProposal(p, proposer, locationInitiator, tp, this.locationNames, this.locationBatches);
            } else {
                tp = (TeamProposal)data.get(1);
                transporterInitiator = Visualizer.parseId(p.getRequestid(), 2);
                proposer = (String)data.get(2);
                tp.getTransportCfp().setRequestid(Visualizer.parseId(tp.getTransportCfp().getRequestid(), 0));
                this.visualizer.addTeamMemberSubcontractProposal(p, proposer, transporterInitiator, tp, this.locationNames, this.locationBatches);
            }
        }
        if (topic.equalsIgnoreCase(TOPIC_BEST_LEADER)) {
            CoalitionDescription cd;
            data = (List)content;
            TransportCfp cfp = (TransportCfp)data.get(0);
            String name = (String)data.get(1);
            if (Visualizer.parseId(cfp.getRequestid(), 2) == null) {
                locationInitiator = Visualizer.parseId(cfp.getRequestid(), 1);
                this.visualizer.setBestLeader(cfp, name, locationInitiator, this.locationNames);
                cd = (CoalitionDescription)this.coalitions.get(cfp.getRequestid());
                if (cd != null) {
                    this.newCoalition(cd, (String)this.locationNames.get(Visualizer.parseId(cfp.getRequestid(), 0)), cfp.getRequestid());
                }
            } else {
                transporterInitiator = Visualizer.parseId(cfp.getRequestid(), 2);
                this.visualizer.setBestSubcontractLeader(cfp, name, transporterInitiator, this.locationNames);
                cd = (CoalitionDescription)this.coalitions.get(cfp.getRequestid());
                if (cd != null) {
                    this.newCoalition(cd, (String)this.locationNames.get(Visualizer.parseId(cfp.getRequestid(), 0)), cfp.getRequestid());
                }
            }
        }
        if (topic.equalsIgnoreCase(TOPIC_COALITION_FINISHED)) {
            this.visualizer.finishCoalition((String)content, this.locationNames);
        }
    }

    private void addTransportLeaderProposal(Proposal prop, String name, TransportCfp cfp, Proposal myProposal, TeamProposal teamProposal) {
        this.visualizer.addTransporLeaderProposal(prop, name, cfp, this.transportBatchesById, this.locationNames, this.locationBatches, myProposal, teamProposal);
    }

    private void addTransportLeaderSubcontractProposal(Proposal prop, String name, TransportCfp cfp, String transporterInitiator, Proposal myProposal, TeamProposal teamProposal) {
        this.visualizer.addTransportLeaderSubcontractProposal(prop, name, transporterInitiator, cfp, this.transportBatchesById, this.locationNames, this.locationBatches, myProposal, teamProposal);
    }

    private void addLocationCFP(List data) {
        RequestList requestList = (RequestList)data.get(0);
        Collection participants = (Collection)data.get(1);
        String name = (String)data.get(2);
        if (this.locationBatches.get(requestList.getRequestid()) == null) {
            Proposal bestProposal;
            this.locationNames.put(requestList.getRequestid(), name);
            this.visualizer.newLocCFPRequest(requestList, participants, name);
            this.locationBatches.put(requestList.getRequestid(), requestList.getBatch());
            for (Batch b : requestList.getBatch()) {
                this.locationBatchesById.put(Long.toString(b.getBatchid()), b);
            }
            Message m = (Message)this.bestProposals.get(requestList.getRequestid());
            if (m != null && this.visualizer.bestLocationOffer(name = m.getSender().getName(), bestProposal = (Proposal)m.getContent(), (String)this.locationNames.get(bestProposal.getRequestid()))) {
                this.bestProposals.remove(requestList.getRequestid());
            }
            if ((m = (Message)this.refused.get(requestList.getRequestid())) != null) {
                String refusingLocation = m.getReceiver().getName();
                RequestList rl = (RequestList)m.getContent();
                this.visualizer.locationRefused(refusingLocation, rl.getRequestid(), (String)this.locationNames.get(rl.getRequestid()));
                this.refused.remove(rl.getRequestid());
            }
            if ((m = (Message)this.receivedAcceptation.get(requestList.getRequestid())) != null) {
                RequestList rl = (RequestList)m.getContent();
                name = m.getReceiver().getName();
                this.visualizer.acceptationReceived(name, rl.getRequestid(), (String)this.locationNames.get(rl.getRequestid()));
                this.receivedAcceptation.remove(requestList.getRequestid());
            }
        } else {
            this.logger.warning("two location contracts has the same requestID");
        }
    }

    private void newLocationOffer(List data) {
        Proposal proposal = (Proposal)data.get(0);
        String locationName = (String)data.get(1);
        this.visualizer.newLocationOffer(proposal, locationName, this.locationBatchesById, (String)this.locationNames.get(proposal.getRequestid()));
    }

    private void locationWinner(Message m) {
        Proposal bestProposal;
        String name = m.getSender().getName();
        if (!this.visualizer.bestLocationOffer(name, bestProposal = (Proposal)m.getContent(), (String)this.locationNames.get(bestProposal.getRequestid()))) {
            this.bestProposals.put(bestProposal.getRequestid(), m);
        }
    }

    private void locationRefused(Message m) {
        String refusingLocation = m.getReceiver().getName();
        RequestList requestList = (RequestList)m.getContent();
        if (this.locationBatches.get(requestList.getRequestid()) == null) {
            this.refused.put(requestList.getRequestid(), m);
        } else {
            this.visualizer.locationRefused(refusingLocation, requestList.getRequestid(), (String)this.locationNames.get(requestList.getRequestid()));
        }
    }

    private void acceptationReceived(Message m) {
        RequestList requestList = (RequestList)m.getContent();
        String name = m.getReceiver().getName();
        if (this.locationBatches.get(requestList.getRequestid()) == null) {
            this.receivedAcceptation.put(requestList.getRequestid(), m);
        } else {
            this.visualizer.acceptationReceived(name, requestList.getRequestid(), (String)this.locationNames.get(requestList.getRequestid()));
        }
    }
}

