/*
 * Decompiled with CFR 0.152.
 */
package across.visio;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Config {
    private static final String CONFIGURATION = "CONFIGURATION";
    private static final String AGENT = "AGENT";
    private static final String WIDTH = "WIDTH";
    private static final String HEIGHT = "HEIGHT";
    private static final String SHADOW = "SHADOW";
    private static final String HGAP = "HGAP";
    private static final String VGAP = "VGAP";
    private static final String PREFIX = "PREFIX";
    private static final String SUFFIX = "SUFFIX";
    private static final String AUTOARRANGE = "AUTOARRANGE";
    private static final String TILE = "TILE";
    private static final String CASCADE = "CASCADE";
    private static final String NONE = "NONE";
    private static final String COLORS = "COLORS";
    private static final String COLOR = "COLOR";
    private static final String RED = "RED";
    private static final String GREEN = "GREEN";
    private static final String BLUE = "BLUE";
    private static final String NAMES = "NAMES";
    private static final String NAME = "NAME";
    private static final String LONG = "LONG";
    private static final String SHORT = "SHORT";
    private int Width;
    private int Height;
    private int Shadow;
    private int HGap;
    private int VGap;
    private String Prefix;
    private String Suffix;
    private boolean AutoArrange;
    private boolean TileArrange;
    private List Colors = new LinkedList();
    private Map Names = new TreeMap();

    public Config() throws IOException {
        this.init(Config.class.getResource("Config.xml").openStream());
    }

    public Config(String filename) throws FileNotFoundException {
        this.init(new FileInputStream(filename));
    }

    private void init(InputStream is) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            System.err.println(pce);
            System.exit(1);
        }
        Document doc = null;
        try {
            doc = db.parse(is);
        }
        catch (SAXException se) {
            System.err.println(se.getMessage());
            System.exit(1);
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            System.exit(1);
        }
        Element root = doc.getDocumentElement();
        if (root.getTagName().equals(CONFIGURATION)) {
            Element agent = this.getChildElement(root, AGENT);
            Element colors = this.getChildElement(root, COLORS);
            Element names = this.getChildElement(root, NAMES);
            this.Width = Integer.parseInt(this.getChildElement(agent, WIDTH).getFirstChild().getNodeValue());
            this.Height = Integer.parseInt(this.getChildElement(agent, HEIGHT).getFirstChild().getNodeValue());
            this.Shadow = Integer.parseInt(this.getChildElement(agent, SHADOW).getFirstChild().getNodeValue());
            this.HGap = Integer.parseInt(this.getChildElement(agent, HGAP).getFirstChild().getNodeValue());
            this.VGap = Integer.parseInt(this.getChildElement(agent, VGAP).getFirstChild().getNodeValue());
            this.Prefix = this.getChildElement(agent, PREFIX).getFirstChild().getNodeValue();
            this.Suffix = this.getChildElement(agent, SUFFIX).getFirstChild().getNodeValue();
            String Arrange = this.getChildElement(agent, AUTOARRANGE).getFirstChild().getNodeValue();
            if (Arrange.equalsIgnoreCase(TILE)) {
                this.AutoArrange = true;
                this.TileArrange = true;
            } else if (Arrange.equalsIgnoreCase(CASCADE)) {
                this.AutoArrange = true;
                this.TileArrange = false;
            } else if (Arrange.equalsIgnoreCase(NONE)) {
                this.AutoArrange = false;
                this.TileArrange = true;
            } else {
                System.out.println("Wrong AUTOARRANGE value in .xml config");
                this.AutoArrange = false;
                this.TileArrange = false;
            }
            Node c = colors.getFirstChild();
            while (c != null) {
                if (c instanceof Element && ((Element)c).getTagName().equals(COLOR)) {
                    Element col = (Element)c;
                    int r = Integer.parseInt(this.getChildElement(col, RED).getFirstChild().getNodeValue());
                    int g = Integer.parseInt(this.getChildElement(col, GREEN).getFirstChild().getNodeValue());
                    int b = Integer.parseInt(this.getChildElement(col, BLUE).getFirstChild().getNodeValue());
                    this.Colors.add(new Color(r, g, b));
                }
                c = c.getNextSibling();
            }
            if (names != null) {
                Node n = names.getFirstChild();
                while (n != null) {
                    if (n instanceof Element && ((Element)n).getTagName().equals(NAME)) {
                        Element name = (Element)n;
                        String longn = this.getChildElement(name, LONG).getFirstChild().getNodeValue();
                        String shortn = this.getChildElement(name, SHORT).getFirstChild().getNodeValue();
                        this.Names.put(longn, shortn);
                    }
                    n = n.getNextSibling();
                }
            }
        }
    }

    private Element getChildElement(Element e, String ch) {
        Node n = e.getFirstChild();
        while (n != null) {
            if (n instanceof Element && ((Element)n).getTagName().equals(ch)) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public List getColors() {
        return this.Colors;
    }

    public int getHeight() {
        return this.Height;
    }

    public int getHGap() {
        return this.HGap;
    }

    public Map getNames() {
        return this.Names;
    }

    public String getPrefix() {
        return this.Prefix;
    }

    public int getShadow() {
        return this.Shadow;
    }

    public String getSuffix() {
        return this.Suffix;
    }

    public int getVGap() {
        return this.VGap;
    }

    public int getWidth() {
        return this.Width;
    }

    public boolean getAutoArrange() {
        return this.AutoArrange;
    }

    public boolean getTileArrange() {
        return this.TileArrange;
    }

    public static void main(String[] args) throws Exception {
        Config c = new Config("c:/petr/projekty/across/xml/alianvisiocfg.xml");
    }
}

