/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.util.membership.iterative;

import across.data.trust.AgentTrustfulness;
import across.util.skn.util.membership.FuzzyNumberMembership;
import across.util.skn.util.membership.IterativeFuzzyMembership;
import across.util.skn.util.membership.SimpleFuzzyMembership;
import across.util.skn.util.membership.iterative.AboveAvgMembership;
import across.util.skn.util.membership.iterative.UnderAvgMembership;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class IterativeTwoCategories
extends IterativeFuzzyMembership {
    AboveAvgMembership<Object> high = new AboveAvgMembership<Object>(null, null);
    UnderAvgMembership<Object> low = new UnderAvgMembership<Object>(null, null);

    public IterativeTwoCategories() {
        super(null, null);
    }

    public IterativeTwoCategories(IterativeFuzzyMembership trust) {
        super(null, null);
        super.setData(trust);
        this.high = new AboveAvgMembership(trust);
        this.low = new UnderAvgMembership(trust);
    }

    @Override
    public void newSample(double value) {
        super.newSample(value);
        this.high.newSample(value);
        this.low.newSample(value);
    }

    @Override
    public void setData(AgentTrustfulness agt) {
        this.high.setData(agt);
        this.low.setData(agt);
    }

    public boolean isHigherThanLower(IterativeFuzzyMembership trustedEntity) {
        if (trustedEntity instanceof FuzzyNumberMembership) {
            return this.isHigherThanLower((FuzzyNumberMembership)trustedEntity);
        }
        if (trustedEntity instanceof SimpleFuzzyMembership) {
            return this.isHigherThanLower((SimpleFuzzyMembership)trustedEntity);
        }
        throw new ClassCastException("Can not compute the intersection with this membership type.");
    }

    public boolean isHigherThanLower(SimpleFuzzyMembership trustedEntity) {
        double lowIntersection;
        double highIntersection = this.high.getIntersectionHeight(trustedEntity);
        return highIntersection >= (lowIntersection = this.low.getIntersectionHeight(trustedEntity));
    }

    public boolean isHigherThanLower(FuzzyNumberMembership trustedEntity) {
        double highIntersection = this.high.getIntersectionHeight(trustedEntity);
        if (1.0 == highIntersection) {
            return true;
        }
        double lowIntersection = this.low.getIntersectionHeight(trustedEntity);
        return highIntersection >= lowIntersection;
    }

    public AboveAvgMembership getHigh() {
        return this.high;
    }

    public UnderAvgMembership getLow() {
        return this.low;
    }

    @Override
    public void applyChangesToShape() {
    }

    @Override
    public int compareWithCoefficient(double coeff, IterativeFuzzyMembership other) {
        throw new NotImplementedException();
    }

    @Override
    public int compareTo(Object o) {
        throw new NotImplementedException();
    }

    @Override
    public boolean isMember() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isCoreMember() {
        throw new NotImplementedException();
    }

    @Override
    public double getMembershipFunctionCenter() {
        throw new NotImplementedException();
    }

    @Override
    public double getMembershipFunctionUncertainity() {
        throw new NotImplementedException();
    }
}

