/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.util.membership;

import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.IterativeFuzzyMembership;

public class SimpleFuzzyMembership<MemberObject>
extends IterativeFuzzyMembership<MemberObject> {
    double membership;

    public double getMembership() {
        return this.membership;
    }

    public void setMembership(double membership) {
        this.membership = membership;
    }

    @Override
    public boolean isMember() {
        return this.membership > 0.0;
    }

    @Override
    public boolean isCoreMember() {
        return this.membership == 1.0;
    }

    @Override
    public double getMembershipFunctionCenter() {
        return this.membership;
    }

    @Override
    public double getMembershipFunctionUncertainity() {
        return 0.0;
    }

    public SimpleFuzzyMembership(MemberObject member, FuzzySet set) {
        super(member, set);
    }

    @Override
    public void applyChangesToShape() {
        this.membership = this.avg;
    }

    @Override
    public int compareWithCoefficient(double coeff, IterativeFuzzyMembership other) {
        double omem = ((SimpleFuzzyMembership)other).membership;
        if (this.membership * coeff == omem) {
            return 0;
        }
        if (this.membership * coeff > omem) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof SimpleFuzzyMembership) {
            double omem = ((SimpleFuzzyMembership)o).getMembership();
            if (this.membership == omem) {
                return 0;
            }
            if (this.membership > omem) {
                return 1;
            }
            return -1;
        }
        throw new ClassCastException("Cannot compare with incompatible membership function.");
    }
}

