/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.util.membership;

import across.data.trust.AgentTrustfulness;
import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.Membership;

public abstract class IterativeFuzzyMembership<MemberObject>
extends Membership<MemberObject> {
    protected long n = 0L;
    protected double avg = 0.5;
    protected double avg2 = 0.25;
    protected double min = 1.0;
    protected double max = 0.0;

    public void newSample(double value) {
        this.avg = (this.avg * (double)this.n + value) / (double)(this.n + 1L);
        this.avg2 = (this.avg2 * (double)this.n + value * value) / (double)(this.n + 1L);
        ++this.n;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
        this.applyChangesToShape();
    }

    public void setData(AgentTrustfulness agt) {
        this.avg = agt.getAvg();
        this.avg2 = agt.getAvg2();
        this.n = agt.getNumOfObservations();
        this.min = agt.getMin();
        this.max = agt.getMax();
        this.applyChangesToShape();
    }

    public void setData(IterativeFuzzyMembership original) {
        this.n = original.n;
        this.avg = original.avg;
        this.avg2 = original.avg2;
        this.min = original.min;
        this.max = original.max;
        this.applyChangesToShape();
    }

    protected abstract void applyChangesToShape();

    public double getVariance() {
        return Math.abs(this.avg2 - this.avg * this.avg);
    }

    @Override
    public boolean hasEnoughData() {
        return this.n >= 5L;
    }

    public abstract int compareWithCoefficient(double var1, IterativeFuzzyMembership var3);

    public IterativeFuzzyMembership(MemberObject memberObject, FuzzySet set) {
        super(memberObject, set);
    }

    public IterativeFuzzyMembership(MemberObject o, FuzzySet set, IterativeFuzzyMembership<MemberObject> original) {
        super(o, set);
        this.setData(original);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("avg: ");
        sb.append(this.avg);
        sb.append(" sigma :");
        sb.append(Math.sqrt(this.getVariance()));
        sb.append(" min :");
        sb.append(this.min);
        sb.append(" max :");
        sb.append(this.max);
        return sb.toString();
    }

    public AgentTrustfulness getAgentTrustfulness(String name, long currentTime) {
        AgentTrustfulness res = new AgentTrustfulness();
        res.setAgentName(name);
        res.setCurrentTime(currentTime);
        res.setNumOfObservations(this.n);
        res.setAvg(this.avg);
        res.setAvg2(this.avg2);
        res.setMin(this.min);
        res.setMax(this.max);
        return res;
    }
}

