/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.util.membership;

import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.IterativeFuzzyMembership;
import across.util.skn.util.membership.PairDouble;
import across.util.skn.util.membership.Point;
import across.util.skn.util.membership.SimpleFuzzyMembership;
import java.util.ArrayList;

public class FuzzyNumberMembership<MemberObject>
extends IterativeFuzzyMembership<MemberObject> {
    protected ArrayList<Point> points = new ArrayList();

    public FuzzyNumberMembership(MemberObject o, FuzzySet set, Point ... shape) {
        super(o, set);
        if (shape != null) {
            Point[] pointArray = shape;
            int n = 0;
            int n2 = pointArray.length;
            while (n < n2) {
                Point cpoint = pointArray[n];
                this.points.add(cpoint);
                ++n;
            }
        }
    }

    public FuzzyNumberMembership(MemberObject o, FuzzySet set, IterativeFuzzyMembership<MemberObject> original) {
        super(o, set, original);
    }

    @Override
    public void applyChangesToShape() {
    }

    @Override
    public boolean isMember() {
        if (this.points.size() > 0) {
            for (Point point : this.points) {
                if (!(point.getX() > 0.0) || !(point.getY() > 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCoreMember() {
        return this.points.size() > 0 && this.points.get(this.points.size() - 1).getX() == 1.0 && this.points.get(this.points.size() - 1).getY() == 1.0;
    }

    @Override
    public double getMembershipFunctionCenter() {
        return this.getCoreCenter();
    }

    @Override
    public double getMembershipFunctionUncertainity() {
        return this.getTotalSurface();
    }

    public double getCenter() {
        return this.getCoreCenter();
    }

    public double getCoreCenter() {
        PairDouble coreStart = null;
        PairDouble coreEnd = null;
        for (Point point : this.points) {
            if (coreStart == null && point.getY() == 1.0) {
                coreStart = point;
                coreEnd = point;
                continue;
            }
            if (coreEnd != null && point.getY() == 1.0) {
                coreEnd = point;
                continue;
            }
            if (coreEnd != null && point.getY() < 1.0) break;
        }
        if (coreEnd != null) {
            return (coreEnd.getX() - coreStart.getX()) / 2.0 + coreStart.getX();
        }
        return 0.0;
    }

    public Point getMin() {
        if (this.points.size() > 0) {
            return this.points.get(0);
        }
        return new Point(0.0, 0.0);
    }

    public Point getMax() {
        if (this.points.size() > 0) {
            return this.points.get(this.points.size() - 1);
        }
        return new Point(0.0, 0.0);
    }

    public double getTotalSurface() {
        return this.getSurfaceUnder(1.0);
    }

    public double getSurfaceUnder(double limit) {
        double surface = 0.0;
        Point last = null;
        for (Point point : this.points) {
            if (last != null) {
                surface += FuzzyNumberMembership.computeSurface(last, point, limit);
                if (point.getX() >= limit) break;
            }
            last = point;
        }
        return surface;
    }

    public PairDouble getSurfaceUnderAbove(double limit) {
        double surfaceUnder = 0.0;
        double surfaceAbove = 0.0;
        Point last = null;
        for (Point point : this.points) {
            if (last != null) {
                double surf = FuzzyNumberMembership.computeSurface(last, point);
                double sl = FuzzyNumberMembership.computeSurface(last, point, limit);
                surfaceUnder += sl;
                surfaceAbove += surf - sl;
            }
            last = point;
        }
        return new PairDouble(surfaceUnder, surfaceAbove);
    }

    private static double computeSurface(Point left, Point right) {
        if (left.getX() > right.getX()) {
            return FuzzyNumberMembership.computeSurface(right, left);
        }
        double minp = Math.min(left.getY(), right.getY());
        double maxp = Math.max(left.getY(), right.getY());
        double res = (minp + (maxp - minp) / 2.0) * (right.getX() - left.getX());
        return res;
    }

    private static double computeSurface(Point left, Point right, double limit) {
        if (left.getX() > right.getX()) {
            return FuzzyNumberMembership.computeSurface(right, left, limit);
        }
        if (limit < left.getX()) {
            return 0.0;
        }
        if (limit > right.getX()) {
            return FuzzyNumberMembership.computeSurface(left, right);
        }
        double limVal = left.getY() + (right.getY() - left.getY()) * (limit - left.getX());
        return FuzzyNumberMembership.computeSurface(left, new Point(limit, limVal));
    }

    private static double getLinearFunctionValueAtPoint(Point left, Point right, double xValue) {
        if (left.getX() > right.getX()) {
            return FuzzyNumberMembership.getLinearFunctionValueAtPoint(right, left, xValue);
        }
        if (left.getX() <= xValue && xValue <= right.getX()) {
            if (right.getX() - left.getX() < 1.0E-7) {
                return Math.max(left.getY(), right.getY());
            }
            return left.getY() + (right.getY() - left.getY()) / (right.getX() - left.getX()) * (xValue - left.getX());
        }
        return 0.0;
    }

    private static Point getMaxCrossing(Point left1, Point right1, Point left2, Point right2) {
        double a2;
        double b1 = left1.getY();
        double c1 = left1.getX();
        double b2 = left2.getY();
        double c2 = left2.getX();
        if (left1.getX() == right1.getX()) {
            if (left2.getX() == right2.getX()) {
                if (c1 == c2) {
                    return new Point(c1, Math.min(Math.max(b1, right1.getY()), Math.max(b2, right2.getY())));
                }
                return null;
            }
            if (c2 <= c1 && c1 <= right2.getX()) {
                return new Point(c1, Math.min(FuzzyNumberMembership.getLinearFunctionValueAtPoint(left2, right2, c1), Math.max(b1, right1.getY())));
            }
            return null;
        }
        if (left2.getX() == right2.getX()) {
            if (c1 <= c2 && c2 <= right1.getX()) {
                return new Point(c1, Math.min(FuzzyNumberMembership.getLinearFunctionValueAtPoint(left1, right1, c1), Math.max(b2, right2.getY())));
            }
            return null;
        }
        double a1 = (right1.getY() - left1.getY()) / (right1.getX() - c1);
        if (a1 == (a2 = (right2.getY() - left2.getY()) / (right2.getX() - c2))) {
            if (b1 - a1 * c1 == b2 - a2 * c2) {
                if (left1.getY() > right1.getY()) {
                    return left1;
                }
                return right1;
            }
            return null;
        }
        double resx = (a1 * c1 - a2 * c2 - b1 + b2) / (a1 - a2);
        if (left1.getX() <= resx && right1.getX() >= resx && left2.getX() <= resx && right2.getX() >= resx) {
            double y1 = FuzzyNumberMembership.getLinearFunctionValueAtPoint(left1, right1, resx);
            double y2 = FuzzyNumberMembership.getLinearFunctionValueAtPoint(left2, right2, resx);
            if (Math.abs(a1) > 1000000.0 || Math.abs(a2) > 1000000.0) {
                if (Math.abs(a2) < 1000000.0) {
                    y1 = y2;
                } else {
                    y2 = Math.abs(a1) < 1000000.0 ? y1 : (y1 = Math.min(Math.max(left2.getY(), right2.getY()), Math.max(left2.getY(), right2.getY())));
                }
            }
            if (!(Math.abs(y1 - y2) < 2.0E-5)) {
                System.out.println("Bad EQUATION: " + left1 + right1 + left2 + right2 + " res: " + resx + y1 + y2);
                System.out.println("Bad EQUATION details: " + left1 + right1 + left2 + right2 + " res: " + resx + " a1: " + a1 + " a2: " + a2);
            }
            return new Point(resx, y1);
        }
        return null;
    }

    public double getIntersectionHeight(FuzzyNumberMembership other) {
        ArrayList<Point> opoints = other.points;
        double maxLeft = Math.max(this.points.get(0).getX(), opoints.get(0).getX());
        double minRight = Math.min(this.points.get(this.points.size() - 1).getX(), opoints.get(other.points.size() - 1).getX());
        double sup = 0.0;
        Point left = null;
        for (Point right : this.points) {
            if (left != null) {
                if (right.getX() < maxLeft || left.getX() > minRight) continue;
                if (1.0 == (sup = Math.max(sup, other.getMaxCrossingWithLine(left, right)))) {
                    return 1.0;
                }
            }
            left = right;
        }
        return sup;
    }

    private double getMaxCrossingWithLine(Point left, Point right) {
        double sup = 0.0;
        Point oleft = null;
        for (Point oright : this.points) {
            if (oleft != null) {
                Point cross;
                if (left.getX() > oright.getX() || right.getX() < oleft.getX()) continue;
                if (left.getX() > right.getX()) {
                    System.out.println("######## Left on the Right: l: " + left + " r: " + right);
                }
                if (oleft.getX() > oright.getX()) {
                    System.out.println("######## Left on the Right: l: " + oleft + " r: " + oright + " in: " + this);
                }
                if ((cross = FuzzyNumberMembership.getMaxCrossing(left, right, oleft, oright)) != null && 1.0 == (sup = Math.max(sup, cross.getY()))) {
                    return 1.0;
                }
            }
            oleft = oright;
        }
        return sup;
    }

    public double getIntersectionHeight(SimpleFuzzyMembership other) {
        PairDouble last = null;
        for (Point point : this.points) {
            if (last != null && last.getX() <= other.membership && point.getX() >= other.membership) {
                return FuzzyNumberMembership.getLinearFunctionValueAtPoint((Point)last, point, other.membership);
            }
            last = point;
        }
        return 0.0;
    }

    @Override
    public int compareWithCoefficient(double coeff, IterativeFuzzyMembership other) {
        FuzzyNumberMembership<MemberObject> shifted = this.shiftByMultiplication(coeff);
        return shifted.compareTo(other);
    }

    protected FuzzyNumberMembership<MemberObject> shiftByMultiplication(double coeff) {
        ArrayList<Point> np = new ArrayList<Point>();
        for (Point point : this.points) {
            np.add(new Point(point.getX() * coeff, point.getY()));
        }
        Point[] npa = null;
        np.toArray(npa);
        return new FuzzyNumberMembership<Object>(this.member, null, npa);
    }

    @Override
    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof SimpleFuzzyMembership) {
            SimpleFuzzyMembership sfm = (SimpleFuzzyMembership)o;
            if (sfm.getMembershipFunctionCenter() <= this.getCenter()) {
                return 1;
            }
            return -1;
        }
        if (o instanceof FuzzyNumberMembership) {
            double mySurfaceUnder;
            FuzzyNumberMembership fnm = (FuzzyNumberMembership)o;
            if (fnm.getMax().getX() < this.getMin().getX()) {
                return 1;
            }
            if (fnm.getMin().getX() > this.getMax().getX()) {
                return -1;
            }
            double othersSurfaceUnder = fnm.getSurfaceUnder(this.getCenter());
            if (othersSurfaceUnder > (mySurfaceUnder = this.getSurfaceUnder(fnm.getCenter()))) {
                return 1;
            }
            if (mySurfaceUnder == othersSurfaceUnder) {
                return 0;
            }
            return -1;
        }
        throw new ClassCastException("Can not compare with this class: " + o.getClass().getName());
    }
}

