/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.util;

import across.util.skn.util.membership.Membership;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class FuzzySet<MemberObject> {
    protected ArrayList<Membership<MemberObject>> members = new ArrayList();

    public void removeAllMembers() {
        this.members = new ArrayList();
    }

    public List<MemberObject> getAllMembers() {
        LinkedList<MemberObject> res = new LinkedList<MemberObject>();
        for (Membership<MemberObject> member : this.members) {
            if (!member.isMember()) continue;
            res.add(member.getMember());
        }
        return res;
    }

    public List<MemberObject> getAllCoreMembers() {
        LinkedList<MemberObject> res = new LinkedList<MemberObject>();
        for (Membership<MemberObject> member : this.members) {
            if (!member.isCoreMember()) continue;
            res.add(member.getMember());
        }
        return res;
    }

    public List<MemberObject> getAllMembersAbove(Membership<MemberObject> alphaLevel) {
        LinkedList<MemberObject> res = new LinkedList<MemberObject>();
        for (Membership<MemberObject> member : this.members) {
            if (member.compareTo(alphaLevel) <= 0) continue;
            res.add(member.getMember());
        }
        return res;
    }

    public long getMembersCount(Membership<MemberObject> alphaLevel) {
        if (this.members.size() > 0) {
            long count = 0L;
            for (Membership<MemberObject> member : this.members) {
                if (member.compareTo(alphaLevel) <= 0) continue;
                ++count;
            }
            return count;
        }
        return 0L;
    }

    public long getAllMembersCount() {
        if (this.members.size() > 0) {
            long count = 0L;
            for (Membership<MemberObject> member : this.members) {
                if (!member.isMember()) continue;
                ++count;
            }
            return count;
        }
        return 0L;
    }

    public long getCoreMembersCount() {
        if (this.members.size() > 0) {
            long count = 0L;
            for (Membership<MemberObject> member : this.members) {
                if (!member.isCoreMember()) continue;
                ++count;
            }
            return count;
        }
        return 0L;
    }

    public MemberObject pickRandomMember() {
        if (this.members.size() > 0) {
            long rand = Math.round(Math.floor(Math.random() * (double)(this.members.size() - 1)));
            return this.members.get((int)rand).getMember();
        }
        return null;
    }

    public MemberObject pickBestMember() {
        Membership<MemberObject> res = null;
        if (this.members.size() > 0) {
            for (Membership<MemberObject> membership : this.members) {
                if (membership.compareTo(res) <= 0) continue;
                res = membership;
            }
        }
        return res.getMember();
    }

    public void addMember(Membership<MemberObject> membership) {
        this.removeMember(membership.getMember());
        this.members.add(membership);
    }

    public boolean removeMember(Membership<MemberObject> membership) {
        return this.members.remove(membership);
    }

    public boolean removeMember(MemberObject member) {
        Membership<MemberObject> membership = this.getMembership(member);
        if (membership != null) {
            return this.members.remove(membership);
        }
        return false;
    }

    public Membership<MemberObject> getMembership(MemberObject queriedMember) {
        for (Membership<MemberObject> membership : this.members) {
            if (!membership.getMember().equals(queriedMember)) continue;
            return membership;
        }
        return null;
    }

    public boolean containsMember(MemberObject queriedMember) {
        for (Membership<MemberObject> membership : this.members) {
            if (!membership.getMember().equals(queriedMember)) continue;
            return true;
        }
        return false;
    }

    public ListIterator<Membership<MemberObject>> getMembershipIterator() {
        return this.members.listIterator();
    }
}

