/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.util;

import across.util.skn.AgentKnowledge;
import aglobe.container.transport.Address;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AgentListTools {
    public static AgentKnowledge pickRandomAgent(List<AgentKnowledge> agentList) {
        if (agentList != null && agentList.size() > 0) {
            long rand = Math.round(Math.random() * (double)agentList.size());
            return agentList.get((int)rand);
        }
        return null;
    }

    public static AgentKnowledge pickMostRelevantAgent(Collection<AgentKnowledge> agentList) {
        AgentKnowledge res = null;
        if (agentList != null && agentList.size() > 0) {
            Iterator<AgentKnowledge> iterator = agentList.iterator();
            res = iterator.next();
            while (iterator.hasNext()) {
                AgentKnowledge cak = iterator.next();
                if (!(res.getInterest() < cak.getInterest())) continue;
                res = cak;
            }
        }
        return res;
    }

    public static Collection<AgentKnowledge> getAccessibleAgents(Collection<AgentKnowledge> agentList, Address agentToAvoid) {
        LinkedList<AgentKnowledge> res = new LinkedList<AgentKnowledge>();
        if (agentList != null) {
            for (AgentKnowledge agent : agentList) {
                if (agent.container == null || !agent.isAccessible() || agentToAvoid == agent.address) continue;
                res.add(agent);
            }
        }
        return res;
    }

    public static Collection<Address> getAccessibleAgentsAddress(Collection<AgentKnowledge> agentList, Address agentToAvoid) {
        LinkedList<Address> res = new LinkedList<Address>();
        if (agentList != null) {
            for (AgentKnowledge agent : agentList) {
                if (agent.container == null || !agent.isAccessible() || agentToAvoid == agent.address) continue;
                res.add(agent.address);
            }
        }
        return res;
    }

    public static Collection<Address> addressExcludeAgentFromTheList(Collection<AgentKnowledge> agentList, Address agentToAvoid) {
        LinkedList<Address> res = new LinkedList<Address>();
        if (agentList != null) {
            for (AgentKnowledge agent : agentList) {
                if (agentToAvoid == agent.address) continue;
                res.add(agent.address);
            }
        }
        return res;
    }

    public static Collection<AgentKnowledge> excludeAgentFromTheList(Collection<AgentKnowledge> agentList, Address agentToAvoid) {
        LinkedList<AgentKnowledge> res = new LinkedList<AgentKnowledge>();
        if (agentList != null) {
            for (AgentKnowledge agent : agentList) {
                if (agentToAvoid == agent.address) continue;
                res.add(agent);
            }
        }
        return res;
    }
}

