/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.update;

import across.util.skn.CommunityKnowledge;
import aglobe.container.EventReceiver;
import aglobe.container.sysservice.directory.DirectoryListener;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.ontology.VisibilityUpdate;
import aglobe.service.gis.client.GISTopicListener;

public class UpdateListener
implements DirectoryListener,
GISTopicListener {
    private final CommunityKnowledge ckn;
    private final EventReceiver owner;

    public UpdateListener(CommunityKnowledge ckn, EventReceiver owner) {
        this.ckn = ckn;
        this.owner = owner;
    }

    @Override
    public void handleNewRegister(String containerName, DirectoryRecord[] records, String matchingFilter) {
        int i = 0;
        while (i < records.length) {
            DirectoryRecord record = records[i];
            this.ckn.agentRegistered(record);
            ++i;
        }
    }

    @Override
    public void handleDeregister(String containerName, DirectoryRecord[] records, String matchingFilter) {
        int i = 0;
        while (i < records.length) {
            DirectoryRecord record = records[i];
            this.ckn.agentDeRegistered(record);
            ++i;
        }
    }

    @Override
    public void handleVisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleInvisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equalsIgnoreCase("VISIBILITY_UPDATES")) {
            VisibilityUpdate gi = (VisibilityUpdate)content;
            this.ckn.updateContainerVisibility(gi.getVisibleContainerAddress());
        }
    }

    @Override
    public void addEvent(Runnable e) {
        this.owner.addEvent(e);
    }
}

