/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.plan.across;

import across.data.Node;
import across.data.Resource;
import across.data.TransportPlan;
import across.data.TransportPlanBase;
import across.util.skn.AgentKnowledge;
import across.util.skn.CommunityKnowledge;
import across.util.skn.plan.Action;
import across.util.skn.plan.ActionType;
import across.util.skn.plan.ResourceKnowledge;
import across.util.skn.plan.across.AcPlanTemplate;
import across.util.skn.plan.across.AcTransport;
import across.util.skn.plan.across.ObGoodsStored;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class PlanBase {
    protected LinkedList<AcPlanTemplate> templates = new LinkedList();
    protected LinkedHashMap<String, ActionType> actions = new LinkedHashMap();
    protected LinkedHashMap<String, ResourceKnowledge> resources = new LinkedHashMap();
    private CommunityKnowledge caller;
    protected HashMap<String, Node> nodes = null;

    public void loadFromXml(TransportPlanBase tpb) {
        for (TransportPlan tpxml : tpb.getTransportPlan()) {
            AcPlanTemplate acpt = new AcPlanTemplate(tpxml);
            this.templates.add(acpt);
        }
    }

    public List<AcPlanTemplate> selectPlans(String startNode, String targetNode) {
        LinkedList<AcPlanTemplate> res = new LinkedList<AcPlanTemplate>();
        for (AcPlanTemplate pt : this.templates) {
            for (ObGoodsStored obGoodsStored : pt.getPrerequisites()) {
                if (!obGoodsStored.getStorageNode().equalsIgnoreCase(startNode)) continue;
                for (ObGoodsStored obGoodsStored2 : pt.getAllows()) {
                    if (!obGoodsStored2.getStorageNode().equalsIgnoreCase(targetNode)) continue;
                    res.add(pt);
                }
            }
        }
        return res;
    }

    public AcPlanTemplate combinePlans(List<AcPlanTemplate> plansToCombine) {
        LinkedHashMap<String, List<Action>> actionsByDescriptor = new LinkedHashMap<String, List<Action>>();
        LinkedHashMap<String, List<Action>> objectivesByDescriptor = new LinkedHashMap<String, List<Action>>();
        for (AcPlanTemplate pt : plansToCombine) {
            List<Action> collection;
            for (Action ac : pt.getActions()) {
                collection = (LinkedList<Action>)actionsByDescriptor.get(ac.getActionDescriptor());
                if (collection != null) {
                    collection.add(ac);
                    continue;
                }
                collection = new LinkedList<Action>();
                collection.add(ac);
                actionsByDescriptor.put(ac.getActionDescriptor(), collection);
            }
            for (Action ob : pt.getObjectives()) {
                collection = (List)objectivesByDescriptor.get(ob.getActionDescriptor());
                if (collection != null) {
                    collection.add(ob);
                    continue;
                }
                collection = new LinkedList();
                collection.add(ob);
                objectivesByDescriptor.put(ob.getActionDescriptor(), collection);
            }
        }
        LinkedHashMap<String, AcTransport> uniqueActions = new LinkedHashMap<String, AcTransport>();
        LinkedHashMap<String, ObGoodsStored> uniqueObjectives = new LinkedHashMap<String, ObGoodsStored>();
        for (List abd : actionsByDescriptor.values()) {
            uniqueActions.put(((Action)abd.get(0)).getActionDescriptor(), new AcTransport(abd));
        }
        for (List obd : objectivesByDescriptor.values()) {
            uniqueObjectives.put(((Action)obd.get(0)).getActionDescriptor(), new ObGoodsStored(obd));
        }
        return new AcPlanTemplate(uniqueActions.values(), uniqueObjectives.values());
    }

    public PlanBase(CommunityKnowledge caller) {
        this.caller = caller;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AcPlanTemplate acp : this.templates) {
            sb.append(acp.toString());
        }
        return sb.toString();
    }

    public ActionType updateOrCreateActionType(String ad, ResourceKnowledge knowledge) {
        ActionType act = this.actions.get(ad);
        if (act == null) {
            act = new ActionType(ad, knowledge);
            this.actions.put(ad, act);
        } else {
            act.addCompatibleResource(knowledge);
        }
        return act;
    }

    public ResourceKnowledge updateOrCreateResource(AgentKnowledge ak, Resource res, boolean isAvailable) {
        ResourceKnowledge rk = this.resources.get(res.getResid());
        if (rk == null) {
            rk = new ResourceKnowledge(this, ak, res, isAvailable);
            this.resources.put(res.getResid(), rk);
        } else {
            rk.updateResource(res, isAvailable);
        }
        return rk;
    }

    public LinkedHashMap<String, ResourceKnowledge> getResources() {
        return this.resources;
    }

    public LinkedHashMap<String, ActionType> getActions() {
        return this.actions;
    }

    public ActionType getActionType(String descriptor) {
        return this.actions.get(descriptor);
    }

    public List<ResourceKnowledge> getActionTypeResources(String descriptor) {
        ActionType actionType = this.actions.get(descriptor);
        if (actionType != null) {
            return actionType.getCompatibleResourcesList();
        }
        return new LinkedList<ResourceKnowledge>();
    }

    public CommunityKnowledge getCommunity() {
        return this.caller;
    }

    public double getDistanceEstimate(String startNode, String targetNode) {
        if (this.nodes != null) {
            Node start = this.nodes.get(startNode);
            Node target = this.nodes.get(targetNode);
            if (start != null && target != null) {
                return Math.sqrt((start.getX() - target.getX()) * (start.getX() - target.getX()) + (start.getY() - target.getY()) * (start.getY() - target.getY()));
            }
        }
        return 5000000.0;
    }

    public double getDistanceEstimate(AcTransport transAction) {
        return this.getDistanceEstimate(transAction.getStartNode(), transAction.getTargetNode());
    }

    public void setupNodes(HashMap<String, Node> nodes2) {
        this.nodes = nodes2;
    }
}

