/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.plan.across;

import across.data.TransportBatch;
import across.util.skn.AgentKnowledge;
import across.util.skn.plan.Action;
import across.util.skn.plan.Commitment;
import across.util.skn.plan.across.AcPlan;
import across.util.skn.plan.across.AcTransCommitment;
import across.util.skn.plan.across.AcTransport;
import across.util.skn.util.membership.SimpleFuzzyMembership;
import aglobe.container.transport.Address;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class AcTaskTransport
extends Commitment {
    List<TransportBatch> batches = new LinkedList<TransportBatch>();
    List<AcTransCommitment> commitments = new LinkedList<AcTransCommitment>();
    AcTransport actionReference;
    AcPlan plan;

    public AcTaskTransport(AgentKnowledge responsible) {
        super(responsible);
    }

    public AcTaskTransport(AcTransport ac, AcPlan plan) {
        super(null);
        this.actionReference = ac;
        this.plan = plan;
    }

    @Override
    public SimpleFuzzyMembership getCompleted() {
        return null;
    }

    public Action getActionReference() {
        return this.actionReference;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TASK: ");
        sb.append(this.actionReference.toString());
        sb.append("Batches: ");
        for (TransportBatch batch : this.batches) {
            sb.append(batch.getBatchid());
            sb.append(" ");
            sb.append(batch.getComodityName());
            sb.append(" ");
            sb.append(batch.getCount());
            sb.append(" % ");
        }
        sb.append("\nRes: ");
        for (AcTransCommitment comm : this.commitments) {
            sb.append(comm.toString());
            sb.append(" ");
        }
        sb.append("\n");
        return sb.toString();
    }

    public void addBatches(List<TransportBatch> allocated) {
        this.batches.addAll(allocated);
    }

    public void addBatch(TransportBatch batch) {
        this.batches.add(batch);
    }

    public long increaseBatch(TransportBatch tb) {
        for (TransportBatch cb : this.batches) {
            if (tb.getBatchid() != cb.getBatchid()) continue;
            cb.setCount(cb.getCount() + tb.getCount());
            return tb.getCount();
        }
        this.batches.add(tb);
        return tb.getCount();
    }

    public List<TransportBatch> getBatches() {
        return this.batches;
    }

    public void addCommitments(List<AcTransCommitment> comms) {
        this.commitments.addAll(comms);
    }

    public void addCommitments(AcTransCommitment comm) {
        this.commitments.add(comm);
    }

    public List<AcTransCommitment> getCommitments() {
        return this.commitments;
    }

    public Address getStartAddress() {
        Collection<Action> prer = this.actionReference.getPrerequisites();
        if (!prer.iterator().next().hasPrerequisites()) {
            return this.plan.planBase.getCommunity().getOwnerAgentKnowledge().address;
        }
        return this.plan.planBase.getCommunity().getAgent((String)this.actionReference.getStartNode()).address;
    }

    public Address getTargetAddress() {
        AgentKnowledge tagent = this.plan.planBase.getCommunity().getAgent(this.actionReference.getTargetNode());
        if (tagent != null) {
            return tagent.address;
        }
        Address ownA = this.plan.planBase.getCommunity().getOwnerAgent().getAddress();
        return Address.getAgentAddress(ownA.getHost(), ownA.getPort(), this.actionReference.getTargetNode(), this.actionReference.getTargetNode());
    }

    public Collection<Address> getStartNodeIntrveningAgents() {
        HashSet<Address> res = new HashSet<Address>();
        Collection<Action> prerList = this.getActionReference().getPrerequisites();
        for (Action action : prerList) {
            AcTaskTransport task = this.plan.getTask(action.getActionDescriptor());
            if (task == null) continue;
            task.writeNodeIntrveningAgents(res);
        }
        return res;
    }

    public Collection<Address> getTargetNodeIntrveningAgents() {
        HashSet<Address> res = new HashSet<Address>();
        Collection<Action> allList = this.getActionReference().getAllows();
        for (Action action : allList) {
            AcTaskTransport task = this.plan.getTask(action.getActionDescriptor());
            if (task == null) continue;
            task.writeNodeIntrveningAgents(res);
        }
        return res;
    }

    private void writeNodeIntrveningAgents(Collection<Address> res) {
        for (Action act : this.getActionReference().getPrerequisites()) {
            AcTaskTransport tsk = this.plan.getTask(act.getActionDescriptor());
            if (tsk == null) continue;
            for (AcTransCommitment com : tsk.commitments) {
                res.add(com.getAgent().address);
            }
        }
    }

    public Collection<AgentKnowledge> getCommitedTeam() {
        HashSet<AgentKnowledge> res = new HashSet<AgentKnowledge>();
        for (Commitment commitment : this.commitments) {
            if (res.contains(commitment.getAgent())) continue;
            res.add(commitment.getAgent());
        }
        return res;
    }
}

