/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.plan.across;

import across.data.AdvTeamProposal;
import across.data.Node;
import across.data.TeamProposal;
import across.data.TransportCfp;
import across.data.TransportPlanBase;
import across.util.skn.CommunityKnowledge;
import across.util.skn.plan.Planner;
import across.util.skn.plan.across.AcPlan;
import across.util.skn.plan.across.AcPlanTemplate;
import across.util.skn.plan.across.AcTaskTransport;
import across.util.skn.plan.across.AcTransCommitment;
import across.util.skn.plan.across.PlanBase;
import aglobe.container.transport.Address;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AcPlanner
implements Planner {
    private PlanBase planBase;
    private CommunityKnowledge community;

    public AcPlanner(CommunityKnowledge community, TransportPlanBase tpb) {
        this.community = community;
        this.planBase = new PlanBase(community);
        this.planBase.loadFromXml(tpb);
    }

    protected CommunityKnowledge getCommunity() {
        return this.community;
    }

    @Override
    public PlanBase getPlanBase() {
        return this.planBase;
    }

    public void setupNodes(HashMap<String, Node> nodes) {
        this.planBase.setupNodes(nodes);
    }

    @Override
    public AcPlanTemplate producePlanTemplate(TransportCfp cfp) {
        String targetLoc;
        String startLoc = cfp.getTransportBatch().get(0).getStart();
        List<AcPlanTemplate> selectedPlans = this.planBase.selectPlans(startLoc, targetLoc = cfp.getTransportBatch().get(0).getTarget());
        if (!selectedPlans.isEmpty()) {
            return this.getPlanBase().combinePlans(selectedPlans);
        }
        return null;
    }

    @Override
    public AcPlan producePlanInstance(TransportCfp cfp) {
        AcPlanTemplate pt = this.producePlanTemplate(cfp);
        if (pt != null) {
            AcPlan plan = new AcPlan(pt, cfp, this.getPlanBase());
            return plan;
        }
        return null;
    }

    @Override
    public LinkedHashMap<Address, AdvTeamProposal> prepareTeamProposals(AcPlan plan) {
        LinkedHashMap<Address, AdvTeamProposal> res = new LinkedHashMap<Address, AdvTeamProposal>();
        if (plan != null) {
            for (AcTaskTransport task : plan.getTaskList()) {
                LinkedHashMap<Address, TeamProposal> actionRes = new LinkedHashMap<Address, TeamProposal>();
                for (AcTransCommitment comm : task.getCommitments()) {
                    TeamProposal tp = (TeamProposal)actionRes.get(comm.getAgent().address);
                    if (tp == null) {
                        tp = new TeamProposal();
                        TransportCfp atcfp = new TransportCfp();
                        atcfp.setRequestid(task.getActionReference().getActionDescriptor());
                        atcfp.setRequestTime(plan.tcfp.getRequestTime());
                        tp.setRequestedServices(atcfp);
                        tp.setTransportCfp(plan.tcfp);
                        actionRes.put(comm.getAgent().address, tp);
                    }
                    tp.getRequestedServices().getTransportBatch().add(comm.getBatch());
                }
                Collection<Address> startAgents = task.getStartNodeIntrveningAgents();
                Collection<Address> targetAgents = task.getTargetNodeIntrveningAgents();
                for (Map.Entry pair : actionRes.entrySet()) {
                    TeamProposal tp = (TeamProposal)pair.getValue();
                    tp.setTeamLeader(this.community.getOwnerAgentKnowledge().address);
                    tp.getTeamMember().addAll(actionRes.keySet());
                    tp.getStartNodeTeamMember().addAll(startAgents);
                    tp.getTargetNodeTeamMember().addAll(targetAgents);
                    this.updateAdvProposal(res, (Address)pair.getKey(), tp);
                }
            }
            for (AdvTeamProposal atp : res.values()) {
                atp.getTeamMember().addAll((Collection<Address>)res.keySet());
            }
        }
        return res;
    }

    private void updateAdvProposal(Map<Address, AdvTeamProposal> res, Address key, TeamProposal tp) {
        AdvTeamProposal atp = res.get(key);
        if (atp == null) {
            atp = new AdvTeamProposal();
            atp.setTeamLeader(this.community.getOwnerAgentKnowledge().address);
            atp.setThisMember(key);
            res.put(key, atp);
        }
        atp.getTask().add(tp);
    }
}

