/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.plan.across;

import across.data.TransportAction;
import across.data.TransportPlan;
import across.util.skn.plan.Action;
import across.util.skn.plan.PlanTemplate;
import across.util.skn.plan.across.AcTransport;
import across.util.skn.plan.across.ObGoodsStored;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class AcPlanTemplate
extends PlanTemplate {
    public AcPlanTemplate() {
    }

    public AcPlanTemplate(TransportPlan tpxml) {
        this.loadFromXml(tpxml);
    }

    public AcPlanTemplate(Collection<AcTransport> actions, Collection<AcTransport> objectives) {
        super(actions, objectives);
        this.identifyPrersResults();
    }

    public void loadFromXml(TransportPlan tp) {
        for (TransportAction ta : tp.getTransportAction()) {
            if (ta.getActionType().equalsIgnoreCase("TRANSPORT")) {
                AcTransport acTransport = new AcTransport(ta.getStartLocation(), ta.getTargetLocation());
                this.actions.add(acTransport);
                continue;
            }
            if (!ta.getActionType().equalsIgnoreCase("STORAGE")) continue;
            ObGoodsStored obgs = new ObGoodsStored(ta.getTargetLocation());
            this.objectives.add(obgs);
        }
        for (AcTransport act : this.actions) {
            for (ObGoodsStored obj : this.objectives) {
                if (obj.getStorageNode().equalsIgnoreCase(act.getStartNode())) {
                    act.addPrerequisite(obj);
                    obj.addAllows(act);
                    continue;
                }
                if (!obj.getStorageNode().equalsIgnoreCase(act.getTargetNode())) continue;
                act.addAllows(obj);
                obj.addPrerequisite(act);
            }
        }
        this.identifyPrersResults();
    }

    private void identifyPrersResults() {
        for (AcTransport obj : this.objectives) {
            if (obj.isPlanStart()) {
                this.prerequisites.add(obj);
            }
            if (!obj.isPlanTarget()) continue;
            this.allows.add(obj);
        }
    }

    public List<Action> getActionIntersection(AcPlanTemplate otherPlan) {
        LinkedList<Action> res = new LinkedList<Action>();
        for (AcTransport act1 : this.actions) {
            for (AcTransport act2 : otherPlan.actions) {
                if (!act1.equivalentTo(act2)) continue;
                res.add(act1);
            }
        }
        return res;
    }

    @Override
    public String getActionDescriptor() {
        return String.valueOf(this.getActionType()) + this.hashCode();
    }
}

