/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.plan.across;

import across.data.TransportBatch;
import across.data.TransportCfp;
import across.util.ListBatchTools;
import across.util.skn.plan.Action;
import across.util.skn.plan.across.AcPlanTemplate;
import across.util.skn.plan.across.AcTaskTransport;
import across.util.skn.plan.across.AcTransport;
import across.util.skn.plan.across.PlanBase;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class AcPlan {
    protected AcPlanTemplate planTemplate;
    protected TransportCfp tcfp;
    protected PlanBase planBase;
    protected LinkedHashMap<String, AcTaskTransport> tasks = new LinkedHashMap();
    public double objectiveValueLp = Double.NEGATIVE_INFINITY;

    public AcPlan(AcPlanTemplate template, TransportCfp tcfp, PlanBase pb) {
        this.planBase = pb;
        this.planTemplate = template;
        this.tcfp = tcfp;
        this.allocateTasksToActions();
    }

    protected void allocateTasksToActions() {
        LinkedList<AcTaskTransport> openActions = new LinkedList<AcTaskTransport>();
        this.expandList(this.planTemplate.getPrerequisites(), this.tcfp.getTransportBatch(), openActions);
        while (!openActions.isEmpty()) {
            AcTaskTransport task = (AcTaskTransport)openActions.remove(0);
            this.expandTask(task, openActions);
            this.tasks.put(task.getActionReference().getActionDescriptor(), task);
        }
    }

    private void expandTask(AcTaskTransport task, List<AcTaskTransport> openList) {
        this.expandList(task.actionReference.getAllows(), task.batches, openList);
    }

    private void expandList(Collection<Action> actions, List<TransportBatch> batches, List<AcTaskTransport> openList) {
        double ratio = 1.0 / (double)actions.size();
        for (AcTransport acTransport : actions) {
            AcTaskTransport nt = this.getTaskForAction(acTransport);
            this.allocatePartToTask(nt, batches, ratio);
            openList.add(nt);
        }
    }

    protected AcTaskTransport getTaskForAction(AcTransport ac) {
        AcTaskTransport res = this.tasks.get(ac.getActionDescriptor());
        if (res == null) {
            res = new AcTaskTransport(ac, this);
            this.tasks.put(ac.getActionDescriptor(), res);
        }
        return res;
    }

    private void allocatePartToTask(AcTaskTransport ac, List<TransportBatch> batches, double ratio) {
        long totcount = ListBatchTools.getTotalCount(batches);
        long alloc = Math.round((double)totcount * ratio);
        LinkedList<TransportBatch> allocated = new LinkedList<TransportBatch>();
        for (TransportBatch batch : batches) {
            if (alloc <= 0L) break;
            long bsize = Math.min(alloc, batch.getCount());
            TransportBatch copied = ListBatchTools.copyTransportBatch(batch, bsize);
            allocated.add(copied);
            alloc -= bsize;
        }
        ac.addBatches(allocated);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TaskedPlan: ");
        sb.append(this.tasks.size());
        sb.append(" from: ");
        sb.append(ListBatchTools.getTransportCfpStart(this.tcfp));
        sb.append(" to: ");
        sb.append(ListBatchTools.getTransportCfpTarget(this.tcfp));
        sb.append(" ID: ");
        sb.append(this.tcfp.getRequestid());
        sb.append(" tasks \n");
        for (AcTaskTransport actt : this.tasks.values()) {
            sb.append(actt);
        }
        return sb.toString();
    }

    public Collection<AcTaskTransport> getTaskList() {
        return this.tasks.values();
    }

    public AcTaskTransport getTask(String actionDescriptor) {
        return this.tasks.get(actionDescriptor);
    }

    public AcPlanTemplate getTemplate() {
        return this.planTemplate;
    }

    public TransportCfp getTcfp() {
        return this.tcfp;
    }
}

