/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.plan;

import across.data.Resource;
import across.data.TransportBatch;
import across.util.GoodsConstants;
import across.util.ListBatchTools;
import across.util.skn.AgentKnowledge;
import across.util.skn.SocialSubject;
import across.util.skn.plan.ActionType;
import across.util.skn.plan.across.PlanBase;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ResourceKnowledge
extends SocialSubject {
    PlanBase planBase;
    AgentKnowledge resourceOwner;
    AgentKnowledge resourceAgent;
    String resourceID;
    long maxCapacity = 0L;
    long capacity = 0L;
    boolean isAvailable = false;
    Resource resInfo;
    List<ActionType> applicableActions = new LinkedList<ActionType>();

    public ResourceKnowledge(PlanBase planBase, AgentKnowledge owner, Resource xmlInfo, boolean resourceAvailable) {
        this.planBase = planBase;
        this.updateResource(xmlInfo, resourceAvailable);
        this.resourceOwner = owner;
        this.resourceOwner.addResource(this);
        for (String ad : xmlInfo.getAvailableAction()) {
            ActionType at = planBase.updateOrCreateActionType(ad, this);
            this.applicableActions.add(at);
        }
    }

    public ResourceKnowledge(PlanBase planBase, AgentKnowledge owner, AgentKnowledge resourceAg, Resource xmlInfo, boolean resourceAvailable) {
        this.planBase = planBase;
        this.updateResource(xmlInfo, resourceAvailable);
        this.resourceOwner = owner;
        this.resourceOwner.addResource(this);
        for (String ad : xmlInfo.getAvailableAction()) {
            ActionType at = planBase.updateOrCreateActionType(ad, this);
            this.applicableActions.add(at);
        }
        this.resourceAgent = resourceAg;
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    public void updateResource(Resource res, boolean resourceAvailable) {
        this.resourceID = res.getResid();
        long rescap = res.getCapacity();
        if (rescap > this.maxCapacity) {
            this.maxCapacity = rescap;
        }
        this.capacity = rescap;
        this.resInfo = res;
        this.isAvailable = resourceAvailable;
        for (String ad : res.getAvailableAction()) {
            ActionType at = this.planBase.updateOrCreateActionType(ad, this);
            this.applicableActions.add(at);
        }
    }

    public List<ActionType> getApplicableActions() {
        return this.applicableActions;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public String getType() {
        return this.resInfo.getType();
    }

    public AgentKnowledge getResourceOwner() {
        return this.resourceOwner;
    }

    public double getTrustworthiness() {
        return this.resourceOwner.getApplicableTrustworthiness().getMembershipFunctionCenter();
    }

    public double getDistrustfulness() {
        return 1.0 - this.resourceOwner.getApplicableTrustworthiness().getMembershipFunctionCenter();
    }

    public boolean canCarryType(TransportBatch batch) {
        return this.getType().equalsIgnoreCase(GoodsConstants.resolveType(batch.getComodityName()));
    }

    public boolean isCompatibleWith(String desc) {
        for (ActionType action : this.applicableActions) {
            if (!action.actionDescriptor.equalsIgnoreCase(desc)) continue;
            return true;
        }
        return false;
    }

    public void setAvailable(boolean newAvailability) {
        this.isAvailable = newAvailability;
    }

    public class ResourceAssignment {
        protected long assignedCapacity;

        public ResourceAssignment(long capacity) {
            this.assignedCapacity = capacity;
        }

        public ResourceAssignment() {
        }

        public long getAssignedCapacity() {
            return this.assignedCapacity;
        }

        public void setAssignedCapacity(long assignedCapacity) {
            this.assignedCapacity = assignedCapacity;
        }

        public long getMaxCapacity() {
            return ResourceKnowledge.this.maxCapacity;
        }

        public long getFreeCapacity() {
            return ResourceKnowledge.this.maxCapacity - this.assignedCapacity;
        }

        public ResourceKnowledge getRk() {
            return ResourceKnowledge.this;
        }
    }

    public class BatchResourceAssignment
    extends ResourceAssignment {
        LinkedHashMap<TransportBatch, Long> batches = new LinkedHashMap();

        public BatchResourceAssignment(TransportBatch firstBatch, long batchAssigned) {
            this.assignBatch(firstBatch, batchAssigned);
        }

        public BatchResourceAssignment() {
        }

        public long assignBatch(TransportBatch tb, long batchAssigned) {
            batchAssigned = Math.min(this.getFreeCapacity(), batchAssigned);
            this.batches.put(tb, batchAssigned);
            this.assignedCapacity += batchAssigned;
            return batchAssigned;
        }

        public LinkedHashMap<TransportBatch, Long> getBatches() {
            return this.batches;
        }

        public LinkedList<TransportBatch> getBatchesWithAssignedQuantities() {
            LinkedList<TransportBatch> res = new LinkedList<TransportBatch>();
            for (Map.Entry<TransportBatch, Long> ent : this.batches.entrySet()) {
                res.add(ListBatchTools.copyTransportBatch(ent.getKey(), ent.getValue()));
            }
            return res;
        }
    }
}

