/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.plan;

import across.util.skn.plan.across.AcTransport;
import across.util.skn.util.membership.SimpleFuzzyMembership;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class Action {
    protected Collection<Action> prerequisites = new LinkedList<Action>();
    protected Collection<Action> allows = new LinkedList<Action>();
    private String actionType;
    SimpleFuzzyMembership trustfulness;

    public Collection<Action> getPrerequisites() {
        return this.prerequisites;
    }

    public Collection<Action> getAllows() {
        return this.allows;
    }

    public void setPrerequisites(Collection<Action> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public boolean requires(Action requiredAction) {
        for (Action pit : this.prerequisites) {
            if (!pit.equivalentTo(requiredAction)) continue;
            return true;
        }
        return false;
    }

    public boolean allows(Action allowedAction) {
        for (Action ait : this.allows) {
            if (!ait.equivalentTo(allowedAction)) continue;
            return true;
        }
        return false;
    }

    public void addPrerequisite(Action act) {
        this.prerequisites.add(act);
    }

    public void addAllows(Action act) {
        this.allows.add(act);
    }

    private static Collection<Action> gatherActionLists(Collection<Collection<Action>> actionLists) {
        LinkedHashMap<String, Action> uniqueActions = new LinkedHashMap<String, Action>();
        for (Collection<Action> alist : actionLists) {
            for (Action action : alist) {
                String ad = action.getActionDescriptor();
                if (uniqueActions.containsKey(ad)) continue;
                uniqueActions.put(ad, action);
            }
        }
        return new LinkedList<Action>(uniqueActions.values());
    }

    protected void prerequisiteActionsMerged(Action newAction, Collection<Action> oldActions) {
        this.actionsMerged(this.prerequisites, newAction, oldActions);
    }

    protected void allowsActionsMerged(Action newAction, Collection<Action> oldActions) {
        this.actionsMerged(this.allows, newAction, oldActions);
    }

    private void actionsMerged(Collection<Action> listName, Action newAction, Collection<Action> oldActions) {
        for (Action oaction : oldActions) {
            if (!listName.remove(oaction) || listName.contains(newAction)) continue;
            listName.add(newAction);
        }
    }

    public boolean isPlanStart() {
        return this.prerequisites.isEmpty();
    }

    public boolean isPlanTarget() {
        return this.allows.isEmpty();
    }

    public boolean equivalentTo(Action otherAction) {
        if (!(otherAction instanceof AcTransport)) {
            return false;
        }
        return this.getActionDescriptor().equalsIgnoreCase(otherAction.getActionDescriptor());
    }

    public abstract String getActionDescriptor();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("## Action: ");
        sb.append(this.getActionDescriptor());
        sb.append("\n");
        sb.append("Requires: ");
        for (Action act : this.prerequisites) {
            sb.append(act.getActionDescriptor());
            sb.append(" # ");
        }
        sb.append("\nAllows: ");
        for (Action act : this.allows) {
            sb.append(act.getActionDescriptor());
            sb.append(" # ");
        }
        sb.append("\n");
        return sb.toString();
    }

    protected String getActionType() {
        return this.actionType;
    }

    public Action(String type) {
        this.actionType = type;
    }

    public Action(List<Action> actions) {
        this.actionType = actions.get(0).getActionType();
        LinkedList<Collection<Action>> prerLists = new LinkedList<Collection<Action>>();
        LinkedList<Collection<Action>> allowsLists = new LinkedList<Collection<Action>>();
        for (Action sac : actions) {
            prerLists.add(sac.prerequisites);
            allowsLists.add(sac.allows);
        }
        this.prerequisites = Action.gatherActionLists(prerLists);
        this.allows = Action.gatherActionLists(allowsLists);
        for (Action prer : this.prerequisites) {
            prer.allowsActionsMerged(this, actions);
        }
        for (Action all : this.allows) {
            all.prerequisiteActionsMerged(this, actions);
        }
    }

    public boolean hasPrerequisites() {
        return !this.prerequisites.isEmpty();
    }

    public boolean hasAllows() {
        return !this.allows.isEmpty();
    }
}

