/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.gui;

import across.data.Param;
import across.data.PublicParams;
import across.data.Resource;
import across.data.SemiPrivateParams;
import across.util.skn.AgentKnowledge;
import across.util.skn.ServiceKnowledge;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ServiceProvidersDataModel {
    HashMap services = new HashMap();
    DefaultMutableTreeNode root;
    DefaultTreeModel treeModel;

    public ServiceProvidersDataModel(DefaultTreeModel _treeModel, DefaultMutableTreeNode _root) {
        this.root = _root;
        this.treeModel = _treeModel;
    }

    public void update(ServiceKnowledge sk) {
        String name = sk.serviceName;
        if (!this.services.containsKey(name)) {
            DefaultMutableTreeNode newService = new DefaultMutableTreeNode(name);
            this.services.put(name, newService);
            this.root.add(newService);
            this.addProviders(newService, sk.getAllMembers());
        } else {
            DefaultMutableTreeNode oldService = (DefaultMutableTreeNode)this.services.get(name);
            oldService.removeAllChildren();
            this.addProviders(oldService, sk.getAllMembers());
        }
        this.treeModel.reload(this.root);
    }

    private void addProviders(DefaultMutableTreeNode myRoot, List providers) {
        for (AgentKnowledge ak : providers) {
            DefaultMutableTreeNode agentNode = new DefaultMutableTreeNode(ak.address.getName());
            myRoot.add(agentNode);
            DefaultMutableTreeNode publicParamsNode = new DefaultMutableTreeNode("public params");
            agentNode.add(publicParamsNode);
            this.addPublicParamsToTree(ak.publicParams, publicParamsNode);
            DefaultMutableTreeNode semiPrivateParamsNode = new DefaultMutableTreeNode("semi-private params");
            agentNode.add(semiPrivateParamsNode);
            this.addSemiPrivateParamsToTree(ak.semiPrivateParams, semiPrivateParamsNode);
        }
    }

    private void addPublicParamsToTree(PublicParams pp, DefaultMutableTreeNode myRoot) {
        if (pp != null) {
            List<Param> namesValues = pp.getParam();
            int size = namesValues.size();
            int i = 0;
            while (i < size) {
                Param p = namesValues.get(i);
                myRoot.add(new DefaultMutableTreeNode(String.valueOf(p.getName()) + " = " + p.getValue()));
                ++i;
            }
        }
    }

    private void addSemiPrivateParamsToTree(SemiPrivateParams sp, DefaultMutableTreeNode myRoot) {
        if (sp != null) {
            List<Param> namesValues = sp.getParam();
            int size = namesValues.size();
            int i = 0;
            while (i < size) {
                Param p = namesValues.get(i);
                myRoot.add(new DefaultMutableTreeNode(String.valueOf(p.getName()) + " = " + p.getValue()));
                ++i;
            }
            List<Resource> rList = sp.getResource();
            for (Resource r : rList) {
                myRoot.add(new DefaultMutableTreeNode("Type: " + r.getType() + " Capacity: " + r.getCapacity()));
            }
        }
    }
}

