/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn.gui;

import across.data.Param;
import across.data.PublicParams;
import across.data.Resource;
import across.data.SemiPrivateParams;
import across.util.skn.AgentKnowledge;
import across.util.skn.AllianceKnowledge;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class AlliancesDataModel {
    private HashMap alliancesNodes = new HashMap();
    private String alliance;
    private DefaultTreeModel alliancesTreeModel;
    private DefaultMutableTreeNode alliancesRoot;
    private Boolean myAlliance;

    public AlliancesDataModel(DefaultTreeModel _alliancesTreeModel, DefaultMutableTreeNode _alliancesRoot, Boolean _myAlliance) {
        this.alliancesTreeModel = _alliancesTreeModel;
        this.alliancesRoot = _alliancesRoot;
        this.myAlliance = _myAlliance;
    }

    public void update(AllianceKnowledge ak) {
        if (ak == null) {
            return;
        }
        String name = ak.getName();
        if (!this.alliancesNodes.containsKey(name)) {
            if (ak.getName().equalsIgnoreCase(this.alliance) & this.myAlliance || !this.myAlliance.booleanValue()) {
                DefaultMutableTreeNode newAlliance = new DefaultMutableTreeNode(name);
                this.alliancesNodes.put(name, newAlliance);
                this.alliancesRoot.add(newAlliance);
                for (AgentKnowledge agk : ak.getAllMembers()) {
                    DefaultMutableTreeNode newAgentNode = new DefaultMutableTreeNode(agk.address.getName());
                    newAlliance.add(newAgentNode);
                    DefaultMutableTreeNode publicParamsNode = new DefaultMutableTreeNode("public params");
                    newAgentNode.add(publicParamsNode);
                    this.addPublicParamsToTree(agk.publicParams, publicParamsNode);
                    DefaultMutableTreeNode semiPrivateParamsNode = new DefaultMutableTreeNode("semi-private params");
                    newAgentNode.add(semiPrivateParamsNode);
                    this.addSemiPrivateParamsToTree(agk.semiPrivateParams, semiPrivateParamsNode);
                }
            }
        } else {
            DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)this.alliancesNodes.get(name);
            oldNode.removeAllChildren();
            for (AgentKnowledge agk : ak.getAllMembers()) {
                DefaultMutableTreeNode agentNode = new DefaultMutableTreeNode(agk.address.getName());
                oldNode.add(agentNode);
                DefaultMutableTreeNode publicParamsNode = new DefaultMutableTreeNode("public params");
                agentNode.add(publicParamsNode);
                this.addPublicParamsToTree(agk.publicParams, publicParamsNode);
                DefaultMutableTreeNode semiPrivateParamsNode = new DefaultMutableTreeNode("semi-private params");
                agentNode.add(semiPrivateParamsNode);
                this.addSemiPrivateParamsToTree(agk.semiPrivateParams, semiPrivateParamsNode);
            }
        }
        this.alliancesTreeModel.reload(this.alliancesRoot);
    }

    private void addPublicParamsToTree(PublicParams pp, DefaultMutableTreeNode myRoot) {
        if (pp != null) {
            List<Param> namesValues = pp.getParam();
            int size = namesValues.size();
            int i = 0;
            while (i < size) {
                Param p = namesValues.get(i);
                myRoot.add(new DefaultMutableTreeNode(String.valueOf(p.getName()) + " = " + p.getValue()));
                ++i;
            }
        }
    }

    private void addSemiPrivateParamsToTree(SemiPrivateParams sp, DefaultMutableTreeNode myRoot) {
        if (sp != null) {
            List<Param> namesValues = sp.getParam();
            int size = namesValues.size();
            int i = 0;
            while (i < size) {
                Param p = namesValues.get(i);
                myRoot.add(new DefaultMutableTreeNode(String.valueOf(p.getName()) + " = " + p.getValue()));
                ++i;
            }
            List<Resource> rList = sp.getResource();
            for (Resource r : rList) {
                myRoot.add(new DefaultMutableTreeNode("Type: " + r.getType() + " Capacity: " + r.getCapacity()));
            }
        }
    }

    public void remove(AgentKnowledge ak) {
        this.update(ak.alliance);
        if (ak.alliance.getAllMembersCount() == 0L) {
            this.remove(ak.alliance);
        }
    }

    public void remove(AllianceKnowledge ak) {
        DefaultMutableTreeNode removedAlliance = (DefaultMutableTreeNode)this.alliancesNodes.get(ak.getName());
        if (removedAlliance != null) {
            MutableTreeNode parent = (MutableTreeNode)removedAlliance.getParent();
            parent.remove(removedAlliance);
            this.alliancesTreeModel.reload(this.alliancesRoot);
            this.alliancesNodes.remove(ak.getName());
        }
    }

    public void setAlliance(String _alliance) {
        this.alliance = _alliance;
    }
}

