/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn;

import across.util.skn.AgentKnowledge;
import across.util.skn.SocialSubject;
import aglobe.container.transport.Address;
import java.util.LinkedList;
import java.util.List;

public class ContainerKnowledge
extends SocialSubject {
    protected Address address;
    private boolean isAccessible;
    public List surveyedAgentList = new LinkedList();
    public List otherAgentList = new LinkedList();

    public ContainerKnowledge(Address containerAddress) {
        this.address = containerAddress;
    }

    public ContainerKnowledge(Address containerAddress, boolean isAccessible) {
        this.address = containerAddress;
        this.isAccessible = isAccessible;
    }

    public void addAgent(AgentKnowledge knownAgentOnContainer) {
        if (knownAgentOnContainer != null && knownAgentOnContainer.publicParams != null && "Transporter".equalsIgnoreCase(knownAgentOnContainer.publicParams.getType())) {
            if (!this.surveyedAgentList.contains(knownAgentOnContainer)) {
                this.surveyedAgentList.add(knownAgentOnContainer);
            }
        } else if (!this.otherAgentList.contains(knownAgentOnContainer)) {
            this.otherAgentList.add(knownAgentOnContainer);
        }
    }

    public void removeAgent(AgentKnowledge removedAgent) {
        if (removedAgent.publicParams != null && "Transporter".equalsIgnoreCase(removedAgent.publicParams.getType())) {
            this.surveyedAgentList.remove(removedAgent);
        } else {
            this.otherAgentList.remove(removedAgent);
        }
    }

    @Override
    public boolean isAccessible() {
        return this.isAccessible;
    }

    public void setAccessible(boolean b) {
        this.isAccessible = b;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getName() {
        return this.address.getContainerName();
    }
}

