/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn;

import across.agents.transporter.TransporterAgent;
import across.data.PublicParams;
import across.data.Resource;
import across.data.trust.AgentTrustfulness;
import across.data.trust.Trustfulness;
import across.data.trust.TrustworthinessObservation;
import across.data.trust.TrustworthinessObservationList;
import across.util.skn.AcrossCoalitionKnowledge;
import across.util.skn.AgentKnowledge;
import across.util.skn.AllianceKnowledge;
import across.util.skn.ContainerKnowledge;
import across.util.skn.ServiceKnowledge;
import across.util.skn.gui.AlliancesDataModel;
import across.util.skn.gui.ServiceProvidersDataModel;
import across.util.skn.listeners.NewAgentRegisteredListener;
import across.util.skn.listeners.TrustReputationListener;
import across.util.skn.plan.Planner;
import across.util.skn.plan.ResourceKnowledge;
import across.util.skn.util.AgentSet;
import across.util.skn.util.membership.CrispMembership;
import across.util.skn.util.membership.iterative.IterativeTwoCategories;
import across.util.skn.util.membership.iterative.agent.AgentSigmaMinMaxMembership;
import aglobe.container.agent.Agent;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CommunityKnowledge {
    private DefaultMutableTreeNode alliRoot = new DefaultMutableTreeNode("Alliances");
    private DefaultTreeModel alliTreeModel = new DefaultTreeModel(this.alliRoot);
    private DefaultMutableTreeNode myAllianceRoot = new DefaultMutableTreeNode("My Alliance Members");
    private DefaultTreeModel myAllianceTreeModel = new DefaultTreeModel(this.myAllianceRoot);
    AlliancesDataModel alliDataModel = new AlliancesDataModel(this.alliTreeModel, this.alliRoot, new Boolean(false));
    AlliancesDataModel myAllianceDataModel = new AlliancesDataModel(this.myAllianceTreeModel, this.myAllianceRoot, new Boolean(true));
    private DefaultMutableTreeNode serviceProvidersRootNode = new DefaultMutableTreeNode("Services");
    private DefaultTreeModel serviceProvidersTreeModel = new DefaultTreeModel(this.serviceProvidersRootNode);
    ServiceProvidersDataModel serviceProvidersDataModel = new ServiceProvidersDataModel(this.serviceProvidersTreeModel, this.serviceProvidersRootNode);
    public Map<String, AgentKnowledge> agents = new HashMap<String, AgentKnowledge>();
    public Map<String, AllianceKnowledge> alliances = new HashMap<String, AllianceKnowledge>();
    public Map<Address, ContainerKnowledge> containers = new HashMap<Address, ContainerKnowledge>();
    public Map<String, ServiceKnowledge> services = new HashMap<String, ServiceKnowledge>();
    protected Map<String, AcrossCoalitionKnowledge> coalitions = new HashMap<String, AcrossCoalitionKnowledge>();
    protected AgentSet trustedAgents = new AgentSet();
    protected AgentSet aggregateReputationAgents = new AgentSet();
    protected LinkedHashMap<String, AgentSet> reputationAgents = new LinkedHashMap();
    protected Planner planner;
    private String myAlliance;
    private List<NewAgentRegisteredListener> newAgentRegisteredListeners = new LinkedList<NewAgentRegisteredListener>();
    protected List<TrustReputationListener> trustReputationListeners = new LinkedList<TrustReputationListener>();
    private Agent ownerAgent;
    private AgentKnowledge ownerAgentKnowledge;
    protected IterativeTwoCategories trustCategories = new IterativeTwoCategories();

    public CommunityKnowledge(Agent ownerAgent) {
        this.ownerAgent = ownerAgent;
    }

    protected void sendMessage(Message m) throws InvisibleContainerException {
        this.ownerAgent.sendMessage(m);
    }

    protected void submitTopic(String topic, Object content, String reason) {
        if (this.ownerAgent instanceof TransporterAgent) {
            ((TransporterAgent)this.ownerAgent).gisShell.submitTopic(topic, content, reason);
        }
    }

    public synchronized void agentPageUpdated(Address agentAddress, PublicParams publicParams) {
        AgentKnowledge ag = this.agents.get(agentAddress.getName());
        if (ag == null) {
            ag = new AgentKnowledge(agentAddress, publicParams, this);
            this.agents.put(agentAddress.getName(), ag);
        } else {
            ag.publicInfoUpdated(agentAddress, publicParams, null);
        }
    }

    public synchronized void agentPageUpdated(Address agentAddress, PublicParams publicParams, String contName) {
        AgentKnowledge ag = this.agents.get(agentAddress.getName());
        if (ag == null) {
            ag = new AgentKnowledge(agentAddress, publicParams, contName, this);
            this.agents.put(agentAddress.getName(), ag);
        } else {
            ag.publicInfoUpdated(agentAddress, publicParams, contName);
        }
    }

    public AgentKnowledge agentFound(Address sender) {
        AgentKnowledge ag = this.agents.get(sender.getName());
        if (ag == null) {
            ag = new AgentKnowledge(sender, this);
            this.agents.put(sender.getName(), ag);
        }
        return ag;
    }

    public synchronized void agentRegistered(DirectoryRecord dr) {
        AgentKnowledge ag = this.agents.get(dr.address.getName());
        if (ag == null) {
            ag = new AgentKnowledge(dr, this);
            this.agents.put(dr.address.getName(), ag);
            for (NewAgentRegisteredListener listener : this.newAgentRegisteredListeners) {
                listener.handleNewAgentRegistered(ag);
            }
        } else {
            ag.directoryRegistration(dr);
        }
    }

    public synchronized void agentDeRegistered(DirectoryRecord dr) {
        AgentKnowledge ag = this.agents.get(dr.address.getName());
        if (ag != null) {
            ag.directoryDeRegistration(dr);
        }
    }

    public synchronized ContainerKnowledge updateOrCreateContainer(Address containerAddress, AgentKnowledge knownAgentOnContainer) {
        ContainerKnowledge cont = this.containers.get(containerAddress);
        if (cont == null) {
            cont = new ContainerKnowledge(containerAddress, true);
            this.containers.put(containerAddress, cont);
        } else {
            cont.setAccessible(true);
        }
        cont.addAgent(knownAgentOnContainer);
        return cont;
    }

    public synchronized void updateContainerVisibility(List<Address> containerRecords) {
        HashSet<Address> vc = new HashSet<Address>(containerRecords);
        for (ContainerKnowledge ckn : this.containers.values()) {
            if (vc.contains(ckn.address)) {
                ckn.setAccessible(true);
                continue;
            }
            ckn.setAccessible(false);
        }
    }

    public synchronized ServiceKnowledge updateOrCreateService(String serviceName, AgentKnowledge serviceProvider) {
        ServiceKnowledge sk = this.services.get(serviceName);
        if (sk == null) {
            sk = new ServiceKnowledge(serviceName, serviceProvider);
            this.services.put(serviceName, sk);
        } else {
            sk.addMember(serviceProvider);
        }
        this.serviceProvidersDataModel.update(sk);
        return sk;
    }

    public synchronized AllianceKnowledge updateOrCreateAlliance(String allianceName, AgentKnowledge knownMember) {
        if (allianceName != null) {
            AllianceKnowledge alli = this.alliances.get(allianceName);
            if (alli == null) {
                alli = new AllianceKnowledge(allianceName);
                this.alliances.put(allianceName, alli);
            }
            alli.addMember(new CrispMembership<AgentKnowledge>(knownMember, alli));
            this.alliDataModel.update(alli);
            this.myAllianceDataModel.update(alli);
            return alli;
        }
        return null;
    }

    public List<ContainerKnowledge> findUnoccupiedContainers(AllianceKnowledge alliance) {
        LinkedList<ContainerKnowledge> conts = new LinkedList<ContainerKnowledge>();
        block0: for (ContainerKnowledge record : this.containers.values()) {
            conts.add(record);
            for (AgentKnowledge agent : record.surveyedAgentList) {
                if (agent.alliance == null || !alliance.equals(alliance)) continue;
                conts.remove(record);
                continue block0;
            }
        }
        return conts;
    }

    public synchronized Collection<Address> removeAgentsFromSameCoalition(Collection<Address> transporters) {
        LinkedList<Address> retVal = new LinkedList<Address>();
        LinkedHashMap coalitionMembers = new LinkedHashMap();
        for (Address item : transporters) {
            AgentKnowledge akn = this.getAgent(item.getName());
            if (akn != null && akn.alliance != null) {
                if (!coalitionMembers.containsKey(akn.alliance.getName())) {
                    coalitionMembers.put(akn.alliance.getName(), new ArrayList());
                }
                ((List)((HashMap)coalitionMembers).get(akn.alliance.getName())).add(item);
                continue;
            }
            retVal.add(item);
        }
        if (coalitionMembers.size() != 0) {
            Random rnd = new Random(System.currentTimeMillis());
            for (Map.Entry elem : ((HashMap)coalitionMembers).entrySet()) {
                retVal.add((Address)((List)elem.getValue()).get(rnd.nextInt(((List)elem.getValue()).size())));
            }
        }
        return retVal;
    }

    public synchronized Map getAlliances() {
        return this.alliances;
    }

    public synchronized Map getContainers() {
        return this.containers;
    }

    public Map getAgents() {
        return this.agents;
    }

    public Map getServices() {
        return this.services;
    }

    public synchronized void subscribeNewAgentRegisteredListener(NewAgentRegisteredListener list) {
        if (!this.newAgentRegisteredListeners.contains(list)) {
            this.newAgentRegisteredListeners.add(list);
        }
    }

    public synchronized void unsubscribeNewAgentRegisteredListener(NewAgentRegisteredListener list) {
        this.newAgentRegisteredListeners.remove(list);
    }

    public synchronized void subscribeTrustReputationListeners(TrustReputationListener list) {
        if (!this.trustReputationListeners.contains(list)) {
            this.trustReputationListeners.add(list);
        }
    }

    public synchronized void unsubscribeTrustReputationListeners(TrustReputationListener list) {
        this.trustReputationListeners.remove(list);
    }

    public AgentKnowledge getAgent(String name) {
        return this.agents.get(name);
    }

    public AllianceKnowledge getAlliance(String name) {
        return this.alliances.get(name);
    }

    public ServiceKnowledge getService(String name) {
        return this.services.get(name);
    }

    public AgentKnowledge getOwnerAgentKnowledge() {
        if (this.ownerAgentKnowledge == null) {
            this.ownerAgentKnowledge = this.getAgent(this.ownerAgent.getAddress().getName());
        }
        return this.ownerAgentKnowledge;
    }

    public boolean appendCoalition(String coalkey, AcrossCoalitionKnowledge ckn) {
        boolean added = false;
        if (!this.coalitions.containsKey(coalkey)) {
            this.coalitions.put(coalkey, ckn);
            if (this.ownerAgent instanceof TransporterAgent) {
                ((TransporterAgent)this.ownerAgent).gui.addColaition(coalkey);
                added = true;
            }
        }
        return added;
    }

    public void removeCoalition(String coalkey) {
        this.coalitions.remove(coalkey);
    }

    public AcrossCoalitionKnowledge getCoalition(String requestid) {
        return this.coalitions.get(requestid);
    }

    public Class getTrustMembership() {
        String param = this.ownerAgent.getContainer().getProperty("membership");
        if (param != null) {
            try {
                Class<?> c = Class.forName(param);
                return c;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return AgentSigmaMinMaxMembership.class;
    }

    public DefaultTreeModel getAlliancesTreeModel() {
        return this.alliTreeModel;
    }

    public DefaultTreeModel getMyAllianceTreeModel() {
        return this.myAllianceTreeModel;
    }

    public DefaultTreeModel getServiceProvidersTreeModel() {
        return this.serviceProvidersTreeModel;
    }

    public void setAlliance(String _myAlliance) {
        this.myAlliance = _myAlliance;
        this.myAllianceDataModel.setAlliance(this.myAlliance);
        this.myAllianceDataModel.update((AllianceKnowledge)this.getAlliances().get(this.myAlliance));
    }

    public Agent getOwnerAgent() {
        return this.ownerAgent;
    }

    public void handleTrustfulnessValues(Address sender, Trustfulness trustfulness) {
        AgentKnowledge ak = this.getAgent(sender.getName());
        if (ak != null) {
            for (AgentTrustfulness agtf : trustfulness.getAgentTrustfulness()) {
                ak.reputationReceivedFromAgent(agtf);
            }
        } else {
            this.ownerAgent.getLogger().severe(String.valueOf(this.ownerAgent.getName()) + " : reputation values received from unknown agent: " + sender);
        }
    }

    public void handleTrustworthinessObservation(Address sender, TrustworthinessObservationList twlist) {
        AgentKnowledge agent = this.getAgent(sender.getName());
        if (agent != null) {
            Trustfulness tfln = new Trustfulness();
            List<TrustworthinessObservation> tol = twlist.getTrustworthinessObservation();
            for (TrustworthinessObservation obs : tol) {
                AgentKnowledge evaluated = this.getAgent(obs.getAgentName());
                if (evaluated != null) {
                    agent.reputationObservationReceivedFromAgent(evaluated, obs.getTrust());
                    evaluated.getAggregateReputation().newSample(obs.getTrust());
                    if (!evaluated.getAggregateReputation().hasEnoughData()) continue;
                    tfln.getAgentTrustfulness().add(evaluated.getAggregateReputation().getAgentTrustfulness(evaluated.getName(), 1L));
                    continue;
                }
                this.getOwnerAgent().getLogger().severe("Reputation observation received for unknown agent: " + obs.getAgentName() + " \n\n" + sender + " \n" + twlist);
            }
            if (tfln.getAgentTrustfulness().size() > 0) {
                for (TrustReputationListener list : this.trustReputationListeners) {
                    list.handleNewReputationValues(tfln);
                }
            }
        } else {
            this.ownerAgent.getLogger().severe(String.valueOf(this.ownerAgent.getName()) + " : reputation observation received from unknown agent: " + sender);
        }
    }

    public Planner getPlanner() {
        return this.planner;
    }

    public void setPlanner(Planner planner) {
        this.planner = planner;
    }

    public ResourceKnowledge updateOrCreateResource(AgentKnowledge ownerAgent, Resource res, boolean isAvailable) {
        if (this.planner != null && this.planner.getPlanBase() != null) {
            return this.planner.getPlanBase().updateOrCreateResource(ownerAgent, res, isAvailable);
        }
        return null;
    }
}

