/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn;

import across.data.trust.Trustfulness;
import across.util.skn.AgentKnowledge;
import across.util.skn.CommunityKnowledge;
import across.util.skn.listeners.TrustReputationListener;
import across.util.skn.util.AgentSet;
import across.util.skn.util.membership.Membership;

public abstract class CoalitionKnowledge<CoalitionDefinition>
extends AgentSet {
    double maxPayoff;
    double minPayoff;
    double actualPayoff;
    protected CommunityKnowledge caller;
    Strategy trustUpdateStrategy = Strategy.FLAT;
    CoalitionDefinition requestObject;

    public abstract double getTrustfulness();

    public void updateMemberTrust() {
        double trustfulness = this.getTrustfulness();
        long memCount = this.getAllMembersCount();
        switch (this.trustUpdateStrategy) {
            case FLAT: {
                for (Membership membership : this.members) {
                    ((AgentKnowledge)membership.getMember()).updateTrustWithNewEvent(trustfulness);
                }
                break;
            }
            case TRUST_PROPORTIONAL: {
                if (0L >= memCount) break;
                double avgTrustCenter = 0.0;
                for (Membership membership : this.members) {
                    avgTrustCenter += ((AgentKnowledge)membership.getMember()).trust.getMembershipFunctionCenter();
                }
                avgTrustCenter /= (double)memCount;
                for (Membership membership : this.members) {
                    ((AgentKnowledge)membership.getMember()).updateTrustWithNewEvent(trustfulness * ((AgentKnowledge)membership.getMember()).trust.getMembershipFunctionCenter() / avgTrustCenter);
                }
                break;
            }
            case UNC_PROPORTIONAL: {
                if (0L >= memCount) break;
                double avgTrustUnc = 0.0;
                for (Membership membership : this.members) {
                    avgTrustUnc += ((AgentKnowledge)membership.getMember()).trust.getMembershipFunctionUncertainity();
                }
                avgTrustUnc /= (double)this.members.size();
                for (Membership membership : this.members) {
                    ((AgentKnowledge)membership.getMember()).updateTrustWithNewEvent(trustfulness * ((AgentKnowledge)membership.getMember()).trust.getMembershipFunctionUncertainity() / avgTrustUnc);
                }
                break;
            }
            case TRUST_UNC_PROPORTIONAL: {
                if (0L >= memCount) break;
                double avgTrustUnc = 0.0;
                double avgTrustCenter = 0.0;
                for (Membership membership : this.members) {
                    avgTrustUnc += ((AgentKnowledge)membership.getMember()).trust.getMembershipFunctionUncertainity();
                    avgTrustCenter += ((AgentKnowledge)membership.getMember()).trust.getMembershipFunctionCenter();
                }
                avgTrustUnc /= (double)memCount;
                avgTrustCenter /= (double)memCount;
                for (Membership membership : this.members) {
                    double tct = trustfulness * ((AgentKnowledge)membership.getMember()).trust.getMembershipFunctionCenter() / avgTrustCenter;
                    double tuc = trustfulness * ((AgentKnowledge)membership.getMember()).trust.getMembershipFunctionUncertainity() / avgTrustUnc;
                    ((AgentKnowledge)membership.getMember()).updateTrustWithNewEvent((tct + tuc) / 2.0);
                }
                break;
            }
        }
        Trustfulness trfln = new Trustfulness();
        for (Membership membership : this.members) {
            AgentKnowledge ak = (AgentKnowledge)membership.getMember();
            trfln.getAgentTrustfulness().add(ak.getTrust().getAgentTrustfulness(ak.getName(), 1L));
        }
        for (TrustReputationListener list : this.caller.trustReputationListeners) {
            list.handleNewTrustValues(trfln);
        }
    }

    public CoalitionKnowledge(CoalitionDefinition requestObject, Strategy strategy, CommunityKnowledge caller) {
        this.requestObject = requestObject;
        this.trustUpdateStrategy = strategy;
        this.caller = caller;
    }

    public static enum Strategy {
        FLAT,
        TRUST_PROPORTIONAL,
        UNC_PROPORTIONAL,
        TRUST_UNC_PROPORTIONAL;

    }
}

