/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn;

import across.data.Param;
import across.data.PublicParams;
import across.data.Resource;
import across.data.SemiPrivateParams;
import across.data.trust.AgentTrustfulness;
import across.util.skn.AllianceKnowledge;
import across.util.skn.CommunityKnowledge;
import across.util.skn.ContainerKnowledge;
import across.util.skn.ServiceKnowledge;
import across.util.skn.SocialSubject;
import across.util.skn.plan.ResourceKnowledge;
import across.util.skn.util.AgentSet;
import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.CrispMembership;
import across.util.skn.util.membership.IterativeFuzzyMembership;
import across.util.skn.util.membership.Membership;
import across.util.skn.util.membership.iterative.IterativeTwoCategories;
import across.util.skn.util.membership.iterative.SigmaMembership;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.transport.Address;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class AgentKnowledge
extends SocialSubject {
    public Address address;
    public PublicParams publicParams;
    public SemiPrivateParams semiPrivateParams;
    public PublicParams privateParams;
    public ContainerKnowledge container;
    public AllianceKnowledge alliance;
    public List<ServiceKnowledge> servicesProvided = new LinkedList<ServiceKnowledge>();
    public List<ResourceKnowledge> resources = new LinkedList<ResourceKnowledge>();
    private final CommunityKnowledge caller;
    protected IterativeFuzzyMembership<AgentKnowledge> trust;
    protected IterativeFuzzyMembership<AgentKnowledge> aggregateReputation;
    protected AgentSet reputationSources = new AgentSet();
    protected AgentSet reputation = new AgentSet();
    protected IterativeTwoCategories reputationCategories = new IterativeTwoCategories();

    public AgentKnowledge(Address agentAddress, PublicParams pp, CommunityKnowledge caller) {
        this.caller = caller;
        this.address = agentAddress;
        this.publicInfoUpdated(agentAddress, pp, null);
        this.initTrust();
    }

    public AgentKnowledge(Address agentAddress, PublicParams pp, String containerName, CommunityKnowledge caller) {
        this.caller = caller;
        this.address = agentAddress;
        this.publicInfoUpdated(agentAddress, pp, containerName);
        this.initTrust();
    }

    public AgentKnowledge(DirectoryRecord dr, CommunityKnowledge caller) {
        this.caller = caller;
        this.address = dr.address;
        this.container = caller.updateOrCreateContainer(this.address.deriveContainerAddress(), this);
        int i = 0;
        while (i < dr.getServices().length) {
            this.servicesProvided.add(caller.updateOrCreateService(dr.getServices()[i], this));
            ++i;
        }
        this.initTrust();
    }

    public AgentKnowledge(Address sender, CommunityKnowledge caller) {
        this.caller = caller;
        this.address = sender;
        this.initTrust();
    }

    public void directoryRegistration(DirectoryRecord dr) {
        if (this.container != null) {
            if (!this.container.address.equals(dr.address.deriveContainerAddress())) {
                this.container.removeAgent(this);
                this.container = this.caller.updateOrCreateContainer(this.address.deriveContainerAddress(), this);
            }
        } else {
            this.container = this.caller.updateOrCreateContainer(this.address.deriveContainerAddress(), this);
        }
        int i = 0;
        while (i < dr.getServices().length) {
            String sname = dr.getServices()[i];
            boolean match = false;
            for (ServiceKnowledge sk : this.servicesProvided) {
                if (!sname.equalsIgnoreCase(sk.serviceName)) continue;
                match = true;
                break;
            }
            if (!match) {
                this.servicesProvided.add(this.caller.updateOrCreateService(dr.getServices()[i], this));
            }
            ++i;
        }
    }

    public void directoryDeRegistration(DirectoryRecord dr) {
        int i = 0;
        while (i < dr.getServices().length) {
            String sname = dr.getServices()[i];
            Iterator<ServiceKnowledge> sit = this.servicesProvided.iterator();
            while (sit.hasNext()) {
                ServiceKnowledge sk = sit.next();
                if (!sname.equalsIgnoreCase(sk.serviceName)) continue;
                sk.removeMember(this);
                this.caller.serviceProvidersDataModel.update(sk);
                sit.remove();
                break;
            }
            ++i;
        }
        if (this.container != null && !this.container.address.equals(this.address.deriveContainerAddress())) {
            this.container.removeAgent(this);
            this.container = this.caller.updateOrCreateContainer(this.address.deriveContainerAddress(), this);
        }
    }

    public void addServiceProvided(String serviceDescriptor) {
        this.servicesProvided.add(this.caller.updateOrCreateService(serviceDescriptor, this));
    }

    public void publicInfoUpdated(Address address, PublicParams publicParams, String containerName) {
        for (ServiceKnowledge item : this.servicesProvided) {
            this.caller.serviceProvidersDataModel.update(item);
        }
        Address cad = address.deriveContainerAddress();
        if (this.container != null && !this.container.address.equals(cad)) {
            this.container.removeAgent(this);
            this.container = this.caller.updateOrCreateContainer(cad, this);
        } else {
            this.container = this.caller.updateOrCreateContainer(cad, this);
        }
        String currentAlliance = null;
        for (Param param : publicParams.getParam()) {
            if (!param.getName().equalsIgnoreCase("TRANSPORTER_PARAM_ALLIANCE_NAME")) continue;
            currentAlliance = param.getValue();
            break;
        }
        this.enterAlliance(currentAlliance);
        this.publicIdentity = publicParams;
        this.publicParams = publicParams;
    }

    public void initTrust() {
        try {
            Constructor con = this.caller.getTrustMembership().getConstructor(AgentKnowledge.class, FuzzySet.class);
            this.trust = (IterativeFuzzyMembership)con.newInstance(this, this.caller.trustedAgents);
        }
        catch (Exception e) {
            this.trust = new SigmaMembership<AgentKnowledge>(this, this.caller.trustedAgents);
        }
        this.aggregateReputation = this.initTrust(this, this.caller.aggregateReputationAgents);
    }

    public IterativeFuzzyMembership<AgentKnowledge> initTrust(AgentKnowledge trustedAgent, AgentSet trustSet) {
        try {
            Constructor con = this.caller.getTrustMembership().getConstructor(AgentKnowledge.class, FuzzySet.class);
            return (IterativeFuzzyMembership)con.newInstance(trustedAgent, trustSet);
        }
        catch (Exception e) {
            return new SigmaMembership<AgentKnowledge>(trustedAgent, trustSet);
        }
    }

    public void updateSemiPrivateParams(SemiPrivateParams sp) {
        this.semiPrivateParams = sp;
        if (this.alliance != null) {
            this.caller.alliDataModel.update(this.alliance);
            this.caller.myAllianceDataModel.update(this.alliance);
        }
        for (ServiceKnowledge item : this.servicesProvided) {
            this.caller.serviceProvidersDataModel.update(item);
        }
        if (!this.isOwner()) {
            LinkedList<Resource> ress = new LinkedList<Resource>(sp.getResource());
            for (ResourceKnowledge rk : this.getResources()) {
                boolean upd = false;
                Iterator iter = ress.iterator();
                while (iter.hasNext()) {
                    Resource res = (Resource)iter.next();
                    if (!rk.getResourceID().equalsIgnoreCase(res.getResid())) continue;
                    rk.updateResource(res, true);
                    upd = true;
                    iter.remove();
                    break;
                }
                if (upd) continue;
                rk.setAvailable(false);
            }
            Iterator iter = ress.iterator();
            while (iter.hasNext()) {
                Resource res;
                this.caller.updateOrCreateResource(this, res, (res = (Resource)iter.next()).getCapacity() > 0L);
            }
        }
    }

    public void enterAlliance(String newAlliance) {
        if (newAlliance != null) {
            if (this.alliance != null) {
                if (!newAlliance.equalsIgnoreCase(this.alliance.name)) {
                    this.alliance.removeMember(this);
                    this.caller.alliDataModel.remove(this);
                    this.caller.myAllianceDataModel.remove(this);
                    if (this.alliance.getAllMembersCount() == 0L) {
                        this.caller.alliances.remove(this.alliance.name);
                        this.caller.alliDataModel.remove(this.alliance);
                        this.caller.myAllianceDataModel.remove(this.alliance);
                    }
                    this.alliance = this.caller.updateOrCreateAlliance(newAlliance, this);
                }
            } else {
                this.alliance = this.caller.updateOrCreateAlliance(newAlliance, this);
            }
        } else if (this.alliance != null) {
            this.alliance.removeMember(this);
            this.caller.alliDataModel.remove(this);
            if (this.alliance.getAllMembersCount() == 0L) {
                this.caller.alliances.remove(this.alliance.name);
                this.caller.alliDataModel.remove(this.alliance);
                this.caller.myAllianceDataModel.remove(this.alliance);
            }
        }
    }

    @Override
    public boolean isAccessible() {
        if (this.container != null) {
            return this.container.isAccessible();
        }
        return false;
    }

    public void updateTrustWithNewEvent(double eventTrust) {
        eventTrust = Math.min(1.0, eventTrust);
        this.trust.newSample(eventTrust);
        if (this.isOwner()) {
            this.caller.trustCategories.newSample(eventTrust);
        }
        LinkedList<String> data = new LinkedList<String>();
        data.add(this.caller.getOwnerAgentKnowledge().address.getName());
        data.add(this.address.getName());
        data.add(Double.toString(this.trust.getMembershipFunctionCenter()));
        data.add(Double.toString(this.trust.getMembershipFunctionUncertainity()));
        data.add(this.isTrusted() == TrustDecision.TRUSTED ? "Y" : "N");
    }

    public void reputationObservationReceivedFromAgent(AgentKnowledge evaluatedAgent, double observedEventTrust) {
        IterativeFuzzyMembership<AgentKnowledge> mem = (IterativeFuzzyMembership<AgentKnowledge>)this.reputation.getMembership(evaluatedAgent);
        if (mem == null) {
            mem = this.initTrust(evaluatedAgent, this.reputation);
            evaluatedAgent.registerReputationOpinion(this);
        }
        mem.newSample(observedEventTrust);
        if (evaluatedAgent.equals(this)) {
            this.reputationCategories.newSample(observedEventTrust);
        }
    }

    public void reputationReceivedFromAgent(AgentTrustfulness agt) {
        AgentKnowledge evaluatedAgent = this.caller.getAgent(agt.getAgentName());
        if (evaluatedAgent != null) {
            IterativeFuzzyMembership<AgentKnowledge> mem = (IterativeFuzzyMembership<AgentKnowledge>)this.reputation.getMembership(evaluatedAgent);
            if (mem == null) {
                mem = this.initTrust(evaluatedAgent, this.reputation);
                evaluatedAgent.registerReputationOpinion(this);
            }
            mem.setData(agt);
            if (evaluatedAgent.equals(this)) {
                this.reputationCategories.setData(agt);
            }
        } else {
            this.caller.getOwnerAgent().getLogger().severe(String.valueOf(this.caller.getOwnerAgent().getName()) + " : reputation values received for unknown agent: " + agt.getAgentName());
        }
    }

    public void registerReputationOpinion(AgentKnowledge appraisingAgent) {
        if (!this.reputationSources.containsMember(appraisingAgent)) {
            new CrispMembership<AgentKnowledge>(appraisingAgent, this.reputationSources);
        }
    }

    public IterativeFuzzyMembership<AgentKnowledge> getTrust() {
        return this.trust;
    }

    public IterativeFuzzyMembership<AgentKnowledge> getAggregateReputation() {
        return this.aggregateReputation;
    }

    public boolean equals(Object obj) {
        AgentKnowledge other = (AgentKnowledge)obj;
        return this.address.getName().equalsIgnoreCase(other.address.getName());
    }

    public String getName() {
        return this.address.getName();
    }

    public boolean isOwner() {
        return this.caller.getOwnerAgentKnowledge() == this;
    }

    public boolean providesService(String serviceName) {
        for (ServiceKnowledge service : this.servicesProvided) {
            if (!service.serviceName.equalsIgnoreCase(serviceName)) continue;
            return true;
        }
        return false;
    }

    public TrustDecision isTrusted() {
        if (this.trust.hasEnoughData()) {
            if (this.caller.trustCategories.isHigherThanLower(this.trust)) {
                return TrustDecision.TRUSTED;
            }
            return TrustDecision.DISTRUSTED;
        }
        return TrustDecision.NOT_ENOUGH_DATA;
    }

    public TrustDecision trusts(AgentKnowledge trustedAgent) {
        if (this.hasEnoughTrustDataAbout(trustedAgent)) {
            if (this.reputationCategories.hasEnoughData()) {
                if (this.reputationCategories.isHigherThanLower((IterativeFuzzyMembership)this.reputation.getMembership(trustedAgent))) {
                    return TrustDecision.TRUSTED;
                }
                return TrustDecision.DISTRUSTED;
            }
            return TrustDecision.NO_GAUGE_DATA;
        }
        return TrustDecision.NOT_ENOUGH_DATA;
    }

    public TrustDecision shouldTrust(AgentKnowledge trustedAgent) {
        if (this.trust.hasEnoughData()) {
            if (this.hasEnoughTrustDataAbout(trustedAgent)) {
                IterativeTwoCategories repCat = new IterativeTwoCategories(this.trust);
                if (repCat.isHigherThanLower((IterativeFuzzyMembership)this.reputation.getMembership(trustedAgent))) {
                    return TrustDecision.TRUSTED;
                }
                return TrustDecision.DISTRUSTED;
            }
            return TrustDecision.NOT_ENOUGH_DATA;
        }
        return TrustDecision.NO_GAUGE_DATA;
    }

    public boolean hasEnoughTrustDataAbout(AgentKnowledge trustedAgent) {
        IterativeFuzzyMembership mem = (IterativeFuzzyMembership)this.reputation.getMembership(trustedAgent);
        return mem != null && mem.hasEnoughData();
    }

    public TrustDecision hasGoodReputation() {
        double trustingWeight = 0.0;
        double distrustingWeight = 0.0;
        ListIterator it = this.reputationSources.getMembershipIterator();
        while (it.hasNext()) {
            IterativeFuzzyMembership sourceMem = (IterativeFuzzyMembership)it.next();
            AgentKnowledge trustor = (AgentKnowledge)sourceMem.getMember();
            double indWeight = 0.0;
            IterativeFuzzyMembership trusteeEval = (IterativeFuzzyMembership)trustor.reputation.getMembership(this);
            TrustDecision td = trustor.trusts(this);
            indWeight = trustor.trust.getMembershipFunctionCenter() * trusteeEval.getMembershipFunctionUncertainity();
            block0 : switch (td) {
                case TRUSTED: {
                    trustingWeight += indWeight;
                    break;
                }
                case DISTRUSTED: {
                    distrustingWeight += indWeight;
                    break;
                }
                case NOT_ENOUGH_DATA: {
                    break;
                }
                case NO_GAUGE_DATA: {
                    TrustDecision etd = trustor.shouldTrust(this);
                    switch (etd) {
                        case TRUSTED: {
                            trustingWeight += 0.5 * indWeight;
                            break block0;
                        }
                        case DISTRUSTED: {
                            distrustingWeight += 0.5 * indWeight;
                        }
                    }
                }
            }
        }
        if (trustingWeight + distrustingWeight > 0.0) {
            if (trustingWeight >= distrustingWeight) {
                return TrustDecision.TRUSTED;
            }
            return TrustDecision.DISTRUSTED;
        }
        return TrustDecision.NOT_ENOUGH_DATA;
    }

    public double getAverageReputation() {
        double sampleUnc = 0.0;
        double cummulatedAvgValue = 0.0;
        ListIterator it = this.reputationSources.getMembershipIterator();
        while (it.hasNext()) {
            IterativeFuzzyMembership sourceMem = (IterativeFuzzyMembership)it.next();
            AgentKnowledge trustor = (AgentKnowledge)sourceMem.getMember();
            IterativeFuzzyMembership trusteeEval = (IterativeFuzzyMembership)trustor.reputation.getMembership(this);
            cummulatedAvgValue += trusteeEval.getMembershipFunctionCenter() / trusteeEval.getMembershipFunctionUncertainity();
            sampleUnc += 1.0 / trusteeEval.getMembershipFunctionUncertainity();
        }
        if (sampleUnc > 0.0) {
            return cummulatedAvgValue / sampleUnc;
        }
        return 0.5;
    }

    public Membership getApplicableTrustworthiness() {
        return this.getTrust();
    }

    public List<ResourceKnowledge> getResources() {
        return this.resources;
    }

    public void addResource(ResourceKnowledge knowledge) {
        if (!this.resources.contains(knowledge)) {
            this.resources.add(knowledge);
        }
    }

    public static enum TrustDecision {
        TRUSTED,
        DISTRUSTED,
        NOT_ENOUGH_DATA,
        NO_GAUGE_DATA;

    }
}

