/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn;

import across.data.Batch;
import across.data.CooperationResult;
import across.data.RequestList;
import across.data.TransportRequest;
import across.util.skn.AcrossCoalitionKnowledge;
import across.util.skn.AgentKnowledge;
import across.util.skn.CoalitionKnowledge;
import across.util.skn.CommunityKnowledge;
import across.util.skn.util.membership.CrispMembership;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;

public class AcrossCoalitionMemberKnowledge
extends AcrossCoalitionKnowledge<TransportRequest> {
    AgentKnowledge leader;

    public AcrossCoalitionMemberKnowledge(TransportRequest transportRequest, CoalitionKnowledge.Strategy strategy, CommunityKnowledge caller) {
        super(transportRequest, strategy, caller);
        this.leader = caller.getAgent(transportRequest.getTeamLeader().getName());
        this.maxPayoff = transportRequest.getProposal().getTotalPrice();
        this.minPayoff = 0.0;
    }

    @Override
    public void transportCompleted(Batch batch) {
        Message m = Message.newInstance("INFORM-DONE", this.caller.getOwnerAgentKnowledge().address, this.leader.address);
        m.setProtocol("INFORM");
        m.setContent(batch);
        m.setReason(((TransportRequest)this.requestObject).getTransportCfp().getRequestid());
        try {
            this.caller.sendMessage(m);
        }
        catch (InvisibleContainerException invisibleContainerException) {
            // empty catch block
        }
    }

    @Override
    public void transportCompleted(RequestList req) {
        for (Batch batch : req.getBatch()) {
            this.transportCompleted(batch);
        }
    }

    @Override
    public void transportFailed(Batch batch) {
        Message m = Message.newInstance("FAILURE", this.caller.getOwnerAgentKnowledge().address, this.leader.address);
        m.setProtocol("INFORM");
        m.setContent(batch);
        m.setReason(((TransportRequest)this.requestObject).getTransportCfp().getRequestid());
        try {
            this.caller.sendMessage(m);
        }
        catch (InvisibleContainerException invisibleContainerException) {
            // empty catch block
        }
    }

    @Override
    public void transportFailed(RequestList req) {
        for (Batch batch : req.getBatch()) {
            this.transportFailed(batch);
        }
    }

    @Override
    public double getTrustfulness() {
        double rat = this.actualPayoff / this.maxPayoff;
        return rat * rat;
    }

    public void handleCoalitionTerminated(CooperationResult coor) {
        this.actualPayoff = coor.getPayement();
        for (Address o : coor.getTeamMember()) {
            AgentKnowledge m = this.caller.getAgent(o.getName());
            if (m == null) continue;
            new CrispMembership<AgentKnowledge>(m, this);
        }
        this.updateMemberTrust();
        this.caller.removeCoalition(((TransportRequest)this.requestObject).getTransportCfp().getRequestid());
    }

    public Address getLeaderAddress() {
        return this.leader.address;
    }
}

