/*
 * Decompiled with CFR 0.152.
 */
package across.util.skn;

import across.data.Batch;
import across.data.CooperationResult;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.data.TransportRequest;
import across.util.skn.AcrossCoalitionKnowledge;
import across.util.skn.AgentKnowledge;
import across.util.skn.CoalitionKnowledge;
import across.util.skn.CommunityKnowledge;
import across.util.skn.util.membership.CrispMembership;
import across.util.skn.util.membership.Membership;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import java.util.Collection;
import java.util.HashMap;
import java.util.ListIterator;

public class AcrossCoalitionLeaderKnowledge
extends AcrossCoalitionKnowledge<TransportCfp> {
    Proposal proposal;
    long totalCount;
    long completed = 0L;
    long lost = 0L;
    HashMap<String, TransportRequest> requests = new HashMap();
    AgentKnowledge meLeader;

    public void appendMember(AgentKnowledge member, TransportRequest tr) {
        if (!this.meLeader.equals(member)) {
            new CrispMembership<AgentKnowledge>(member, this);
        }
        this.requests.put(member.getName(), tr);
    }

    @Override
    public void transportCompleted(Batch batch) {
        this.completed += Math.abs(batch.getCount());
        if (this.totalCount <= this.completed + this.lost) {
            this.calculatePayoff();
            this.distributePayoffToMembers();
        }
    }

    @Override
    public void transportCompleted(RequestList req) {
        for (Batch batch : req.getBatch()) {
            this.transportCompleted(batch);
        }
    }

    @Override
    public void transportFailed(Batch batch) {
        this.lost += Math.abs(batch.getCount());
        if (this.totalCount <= this.completed + this.lost) {
            this.calculatePayoff();
            this.distributePayoffToMembers();
        }
    }

    @Override
    public void transportFailed(RequestList req) {
        for (Batch batch : req.getBatch()) {
            this.transportFailed(batch);
        }
    }

    private void distributePayoffToMembers() {
        String requestid = ((TransportCfp)this.requestObject).getRequestid();
        double gt = this.getTrustfulness();
        new CrispMembership<AgentKnowledge>(this.meLeader, this);
        this.updateMemberTrust();
        Collection<Address> allAgentsAddress = this.getAllAgentsAddress(null);
        for (Membership membership : this.members) {
            if (((AgentKnowledge)membership.getMember()).equals(this.meLeader)) continue;
            CooperationResult cr = new CooperationResult();
            cr.setRequestid(requestid);
            cr.setGlobalTrust(gt);
            cr.setPayement(Math.round((double)this.requests.get(((AgentKnowledge)membership.getMember()).getName()).getProposal().getTotalPrice() * this.actualPayoff));
            cr.setTeamLeader(this.meLeader.address);
            cr.getTeamMember().addAll(allAgentsAddress);
            Address ad = ((AgentKnowledge)membership.getMember()).address;
            Message m = Message.newInstance("INFORM-RESULT", this.meLeader.address, ad);
            m.setProtocol("INFORM");
            m.setContent(cr);
            try {
                this.caller.sendMessage(m);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
        }
        this.caller.removeCoalition(requestid);
        this.caller.submitTopic("COALITION_FINISHED", requestid, null);
    }

    public double calculatePayoff() {
        this.actualPayoff = 0L < this.totalCount ? (double)this.completed / (double)this.totalCount : 1.0;
        return this.actualPayoff;
    }

    @Override
    public double getTrustfulness() {
        return this.actualPayoff * this.actualPayoff;
    }

    public AcrossCoalitionLeaderKnowledge(TransportCfp transportCfp, Proposal prop, CoalitionKnowledge.Strategy strategy, CommunityKnowledge caller) {
        super(transportCfp, strategy, caller);
        this.proposal = prop;
        this.meLeader = caller.getOwnerAgentKnowledge();
        if (this.meLeader == null) {
            throw new RuntimeException("Agent knowledge of the owner not available during coalition negotiation.");
        }
        this.totalCount = 0L;
        ListIterator<TransportBatch> i = ((TransportCfp)this.requestObject).getTransportBatch().listIterator();
        block0: while (i.hasNext()) {
            TransportBatch tb = i.next();
            for (ItemCoverage ic : prop.getItemCoverage()) {
                if (ic.getItemid() != tb.getBatchid()) continue;
                this.totalCount += Math.round(Math.floor(ic.getCoverage() * (double)tb.getCount()));
                continue block0;
            }
        }
    }
}

