/*
 * Decompiled with CFR 0.152.
 */
package across.util.pathfinding;

import across.agents.driver.data.NodeValue;
import across.agents.driver.data.RoadInfo;
import across.agents.driver.data.Route;
import across.agents.driver.data.RouteInfo;
import across.data.Waypoint;
import across.util.pathfinding.Pathfinding;
import java.util.LinkedList;

public class DijkstraPathfinding
implements Pathfinding {
    private LinkedList<String> indexedLocations;
    private RoadInfo[][] roads;

    public DijkstraPathfinding(LinkedList<String> indexedLocations, RoadInfo[][] roads) {
        this.indexedLocations = indexedLocations;
        this.roads = roads;
    }

    @Override
    public Route planRoute(String from, String to, double weightTime, double weightPrice) {
        LinkedList<NodeValue> open = new LinkedList<NodeValue>();
        LinkedList<NodeValue> closed = new LinkedList<NodeValue>();
        Route route = new Route();
        int fromIndex = this.indexedLocations.indexOf(from);
        int toIndex = this.indexedLocations.indexOf(to);
        if (fromIndex == -1 || toIndex == -1) {
            return null;
        }
        int i = 0;
        while (i < this.indexedLocations.size()) {
            NodeValue nodeVal = new NodeValue(i);
            if (i == fromIndex) {
                nodeVal.setValue(0.0);
            }
            open.add(nodeVal);
            ++i;
        }
        while (open.size() > 0) {
            NodeValue minValNode = (NodeValue)open.getFirst();
            for (NodeValue node : open) {
                if (minValNode.getValue() != -1.0 && (!(node.getValue() >= 0.0) || !(node.getValue() < minValNode.getValue()))) continue;
                minValNode = node;
            }
            if (minValNode.getValue() == -1.0) {
                return null;
            }
            if (minValNode.getNodeIndex() == toIndex) {
                LinkedList<Waypoint> wplist = new LinkedList<Waypoint>();
                wplist.add(new Waypoint(this.indexedLocations.get(toIndex)));
                NodeValue node = minValNode;
                double time = 0.0;
                double price = 0.0;
                while (node.previous != -1) {
                    RoadInfo arc = this.roads[node.getNodeIndex()][node.getPrevious()];
                    time += arc.time;
                    price += arc.price;
                    if (!this.indexedLocations.get(node.previous).equalsIgnoreCase(from)) {
                        wplist.addFirst(new Waypoint(this.indexedLocations.get(node.previous)));
                    }
                    for (NodeValue value : closed) {
                        if (value.getNodeIndex() != node.getPrevious()) continue;
                        node = value;
                    }
                }
                route.addWaypoints(wplist);
                RouteInfo routeInfo = new RouteInfo(time, price);
                route.setRouteInfo(routeInfo);
                return route;
            }
            open.remove(minValNode);
            closed.add(minValNode);
            int i2 = 0;
            while (i2 < this.indexedLocations.size()) {
                RoadInfo arc = this.roads[minValNode.getNodeIndex()][i2];
                if (arc != null && arc.passable) {
                    NodeValue endPoint = null;
                    for (NodeValue node : open) {
                        if (node.getNodeIndex() != i2) continue;
                        endPoint = node;
                        break;
                    }
                    if (endPoint != null) {
                        double arcValue = weightPrice * arc.price + weightTime * arc.time;
                        double currentValue = endPoint.getValue();
                        if (endPoint.getValue() == -1.0 || currentValue > minValNode.getValue() + arcValue) {
                            endPoint.setValue(minValNode.getValue() + arcValue);
                            endPoint.setPrevious(minValNode.getNodeIndex());
                        }
                    }
                }
                ++i2;
            }
        }
        return null;
    }
}

