/*
 * Decompiled with CFR 0.152.
 */
package across.util.pathfinding;

import across.agents.driver.data.NodeValue;
import across.agents.driver.data.Route;
import across.agents.driver.data.RouteInfo;
import across.data.Arc;
import across.data.Node;
import across.data.Waypoint;
import across.util.pathfinding.Pathfinding;
import across.util.pathfinding.RoadEvaluator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AStarModPathfinding
implements Pathfinding {
    private List<Node> acrossMapNodes;
    private List<Arc> acrossMapArcs;
    private RoadEvaluator roadEvaluator;
    private Arc[][] arcsBetweenNodes;
    private Map<Integer, Node> nodesByIndex = new HashMap<Integer, Node>();
    private int toIndex;
    private int fromIndex;
    private double[][] distances;
    private List<Arc> barredRoads;

    public AStarModPathfinding(List<Node> acrossMapNodes, List<Arc> acrossMapArcs, double[][] acrossMapDistances, RoadEvaluator re, List<Arc> barredRoads) {
        this.acrossMapNodes = acrossMapNodes;
        this.acrossMapArcs = acrossMapArcs;
        this.roadEvaluator = re;
        this.distances = acrossMapDistances;
        this.arcsBetweenNodes = new Arc[acrossMapNodes.size()][acrossMapNodes.size()];
        this.barredRoads = barredRoads;
        HashMap<String, Integer> indexesOfNodes = new HashMap<String, Integer>();
        for (Node nod : acrossMapNodes) {
            this.nodesByIndex.put(acrossMapNodes.indexOf(nod), nod);
            indexesOfNodes.put(nod.getName(), acrossMapNodes.indexOf(nod));
            this.arcsBetweenNodes[acrossMapNodes.indexOf((Object)nod)][acrossMapNodes.indexOf((Object)nod)] = null;
        }
        for (Arc arc : acrossMapArcs) {
            Integer i = (Integer)indexesOfNodes.get(arc.getFrom());
            Integer j = (Integer)indexesOfNodes.get(arc.getTo());
            this.arcsBetweenNodes[i.intValue()][j.intValue()] = arc;
            this.arcsBetweenNodes[j.intValue()][i.intValue()] = arc;
        }
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public Route planRoute(String from, String to, double weightTime, double weightPrice) {
        Route route = new Route();
        if (from.equalsIgnoreCase(to)) {
            Waypoint wp = new Waypoint(from);
            route.addWaypoint(wp);
            RouteInfo routeInfo = new RouteInfo(0.0, 0.0);
            route.setRouteInfo(routeInfo);
            return route;
        }
        int x = 0;
        this.fromIndex = 0;
        this.toIndex = 0;
        for (Node nod : this.acrossMapNodes) {
            if (nod.getName().equalsIgnoreCase(from)) {
                this.fromIndex = x;
            }
            if (nod.getName().equalsIgnoreCase(to)) {
                this.toIndex = x;
            }
            ++x;
        }
        LinkedList<Object> open = new LinkedList<Object>();
        LinkedList<NodeValue> closed = new LinkedList<NodeValue>();
        NodeValue nodval = new NodeValue(this.fromIndex);
        closed.add(nodval);
        int i = 0;
        while (i < this.acrossMapNodes.size()) {
            Arc arcBetweenNodes = this.arcsBetweenNodes[i][this.fromIndex];
            if (arcBetweenNodes != null && !this.barredRoads.contains(arcBetweenNodes)) {
                NodeValue target = new NodeValue(i);
                target.previous = this.fromIndex;
                target.setValue(weightPrice * this.roadEvaluator.getPrice(this.arcsBetweenNodes[i][this.fromIndex]) + weightTime * this.roadEvaluator.getTime(this.arcsBetweenNodes[i][this.fromIndex]) + this.getNodeHeuristicValue(i));
                open.add(target);
            }
            ++i;
        }
        while (open.size() > 0) {
            NodeValue minVal = (NodeValue)open.getFirst();
            for (NodeValue node : open) {
                if (minVal.getValue() != -1.0 && (!(node.getValue() >= 0.0) || !(node.getValue() < minVal.getValue()))) continue;
                minVal = node;
            }
            if (minVal.nodeIndex == this.toIndex) {
                LinkedList<Waypoint> wplist = new LinkedList<Waypoint>();
                wplist.add(new Waypoint(this.acrossMapNodes.get(this.toIndex).getName()));
                NodeValue node = minVal;
                double time = 0.0;
                double price = 0.0;
                while (node.previous != -1) {
                    price += this.roadEvaluator.getPrice(this.arcsBetweenNodes[node.getNodeIndex()][node.getPrevious()]);
                    time += this.roadEvaluator.getTime(this.arcsBetweenNodes[node.getNodeIndex()][node.getPrevious()]);
                    if (this.acrossMapNodes.get(node.previous) != this.acrossMapNodes.get(this.fromIndex)) {
                        wplist.addFirst(new Waypoint(this.acrossMapNodes.get(node.getPrevious()).getName()));
                    }
                    for (NodeValue value : closed) {
                        if (value.getNodeIndex() != node.getPrevious()) continue;
                        node = value;
                    }
                }
                route.addWaypoints(wplist);
                RouteInfo routeInfo = new RouteInfo(time, price);
                route.setRouteInfo(routeInfo);
                return route;
            }
            int i2 = 0;
            while (i2 < this.acrossMapNodes.size()) {
                Arc arc = null;
                if (this.arcsBetweenNodes[i2][minVal.getNodeIndex()] != null) {
                    arc = this.arcsBetweenNodes[i2][minVal.getNodeIndex()];
                    boolean nodeclosed = false;
                    for (NodeValue node : closed) {
                        if (i2 != node.nodeIndex) continue;
                        nodeclosed = true;
                    }
                    if (!nodeclosed) {
                        nodeclosed = false;
                        NodeValue openNode = null;
                        for (NodeValue node : open) {
                            if (i2 != node.nodeIndex) continue;
                            nodeclosed = true;
                            openNode = node;
                        }
                        if (nodeclosed) {
                            double value = minVal.value + weightPrice * this.roadEvaluator.getPrice(arc) + weightTime * this.roadEvaluator.getTime(arc) + this.getNodeHeuristicValue(i2);
                            if (value < openNode.value) {
                                openNode.value = value;
                                openNode.previous = minVal.nodeIndex;
                            }
                        } else {
                            NodeValue target = new NodeValue(i2);
                            target.previous = minVal.nodeIndex;
                            target.setValue(minVal.value + weightPrice * this.roadEvaluator.getPrice(arc) + weightTime * this.roadEvaluator.getTime(arc) + this.getNodeHeuristicValue(i2));
                            open.add(target);
                        }
                    }
                }
                ++i2;
            }
            open.remove(minVal);
            closed.add(minVal);
        }
        return null;
    }

    private double getNodeHeuristicValue(int i) {
        return this.distances[this.toIndex][i];
    }
}

