/*
 * Decompiled with CFR 0.152.
 */
package across.util.ixplanparser;

import across.agents.emergency.centre.AcrossActivity;
import across.agents.emergency.centre.AcrossPlan;
import across.util.ixplanparser.ParserKnowledge;
import iglobe.plan.AbstractActivity;
import iglobe.plan.OrderConstraint;
import iglobe.plan.PlanConstraint;
import iglobe.plan.RescueActivity;
import iglobe.plan.RescuePlan;
import iglobe.plan.TransportActivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IxPlanParser {
    private ParserKnowledge knowledge;

    public IxPlanParser(ParserKnowledge pk) {
        this.knowledge = pk;
    }

    public AcrossPlan ixToAcrossPlan(RescuePlan rp) {
        AcrossPlan acrossPlan = new AcrossPlan();
        HashMap<String, AcrossActivity> actsToIds = new HashMap<String, AcrossActivity>();
        List<RescueActivity> actList = rp.getActivities();
        LinkedList<TransportActivity> allActivities = new LinkedList<TransportActivity>();
        Iterator<RescueActivity> iter = actList.iterator();
        while (iter.hasNext()) {
            RescueActivity ra = iter.next();
            if (ra instanceof AbstractActivity) {
                iter.remove();
                Iterator<PlanConstraint> iterator = rp.getConstraints().iterator();
                while (iterator.hasNext()) {
                    Object oc;
                    PlanConstraint pc = iterator.next();
                    if (!(pc instanceof OrderConstraint) || !((OrderConstraint)(oc = (OrderConstraint)pc)).getFromId().equals(ra.getId()) && !((OrderConstraint)oc).getToId().equals(ra.getId())) continue;
                    iterator.remove();
                }
                continue;
            }
            TransportActivity ta = (TransportActivity)ra;
            allActivities.add(ta);
        }
        LinkedList<TransportActivity> vehicleActivities = new LinkedList<TransportActivity>();
        LinkedList<TransportActivity> materialPickActivities = new LinkedList<TransportActivity>();
        LinkedList<TransportActivity> materialDropActivities = new LinkedList<TransportActivity>();
        for (TransportActivity ta : allActivities) {
            if (this.knowledge.vehicles.contains(ta.getResource())) {
                vehicleActivities.add(ta);
                continue;
            }
            if (this.knowledge.pickupMaterials.contains(ta.getResource())) {
                materialPickActivities.add(ta);
                continue;
            }
            if (!this.knowledge.dropMaterials.contains(ta.getResource())) continue;
            materialDropActivities.add(ta);
        }
        LinkedList<OrderConstraint> ocList = new LinkedList<OrderConstraint>();
        for (PlanConstraint pc : rp.getConstraints()) {
            if (!(pc instanceof OrderConstraint)) continue;
            OrderConstraint oc = (OrderConstraint)pc;
            ocList.add(oc);
        }
        for (TransportActivity va : vehicleActivities) {
            if (this.knowledge.whichVehicleTransportWhichMaterial.get(va.getResource()) == null) {
                String dest = va.getDestination();
                AcrossActivity goA = this.newGoto(this.getTo(dest), this.getFrom(dest), this.getObjId(dest));
                actsToIds.put(va.getId(), goA);
                acrossPlan.getActivitiesHandlers().put(goA, va.getResource());
                AcrossActivity effA = this.newEff(this.getObjId(dest));
                String effId = "" + effA.hashCode();
                actsToIds.put(effId, effA);
                acrossPlan.getActivitiesHandlers().put(effA, va.getResource());
                this.putTwoActsInsteadOfOneFirstIx(ocList, va.getId(), goA, effId, effA);
                acrossPlan.getDrivers().put(va.getResource(), "Repair");
                continue;
            }
            Iterator iter2 = ocList.iterator();
            while (iter2.hasNext()) {
                OrderConstraint constraint = (OrderConstraint)iter2.next();
                if (!constraint.getFromId().equals(va.getId()) && !constraint.getToId().equals(va.getId())) continue;
                iter2.remove();
            }
        }
        String STORAGE = "STORAGE";
        String LOCATION = "LOCATION";
        int storCount = 0;
        for (TransportActivity pa : materialPickActivities) {
            for (TransportActivity va : vehicleActivities) {
                if (this.knowledge.whichVehicleTransportWhichMaterial.get(va.getResource()) == null || !this.knowledge.whichVehicleTransportWhichMaterial.get(va.getResource()).contains(pa.getResource())) continue;
                String dest = pa.getDestination();
                String thisStorage = String.valueOf(STORAGE) + storCount;
                String thisStorageLocation = String.valueOf(thisStorage) + LOCATION;
                ++storCount;
                AcrossActivity goToPica = this.newGoto(thisStorageLocation, null, null);
                String goToPicaId = "" + goToPica.hashCode();
                actsToIds.put(goToPicaId, goToPica);
                acrossPlan.getActivitiesHandlers().put(goToPica, va.getResource());
                AcrossActivity picA = this.newPick(thisStorage, pa.getResource(), pa.getAmount());
                String picaId = "" + picA.hashCode();
                actsToIds.put(picaId, picA);
                acrossPlan.getActivitiesHandlers().put(picA, va.getResource());
                acrossPlan.getMaterial().put(thisStorage, STORAGE);
                OrderConstraint oc = new OrderConstraint();
                oc.setFromId(goToPicaId);
                oc.setToId(picaId);
                ocList.add(oc);
                AcrossActivity goA = this.newGoto(this.getTo(dest), this.getFrom(dest), this.getObjId(dest));
                actsToIds.put(pa.getId(), goA);
                acrossPlan.getActivitiesHandlers().put(goA, va.getResource());
                this.putTwoActsInsteadOfOneLastIx(ocList, picaId, picA, pa.getId(), goA);
                AcrossActivity effA = this.newEff(this.getObjId(dest));
                String effId = "" + effA.hashCode();
                actsToIds.put(effId, effA);
                acrossPlan.getActivitiesHandlers().put(effA, va.getResource());
                this.putTwoActsInsteadOfOneFirstIx(ocList, pa.getId(), goA, effId, effA);
                acrossPlan.getDrivers().put(va.getResource(), "Repair");
            }
        }
        for (TransportActivity da : materialDropActivities) {
            for (TransportActivity va : vehicleActivities) {
                if (this.knowledge.whichVehicleTransportWhichMaterial.get(va.getResource()) == null || !this.knowledge.whichVehicleTransportWhichMaterial.get(va.getResource()).contains(da.getResource())) continue;
                String thisStorage = String.valueOf(STORAGE) + storCount;
                String thisStorageLocation = String.valueOf(thisStorage) + LOCATION;
                ++storCount;
                AcrossActivity dropA = this.newDrop(thisStorage, da.getResource(), da.getAmount());
                String dropId = "" + dropA.hashCode();
                actsToIds.put(dropId, dropA);
                acrossPlan.getActivitiesHandlers().put(dropA, va.getResource());
                acrossPlan.getMaterial().put(thisStorage, "Storage");
                AcrossActivity goA = this.newGoto(thisStorageLocation, null, null);
                actsToIds.put(da.getId(), goA);
                acrossPlan.getActivitiesHandlers().put(goA, va.getResource());
                this.putTwoActsInsteadOfOneFirstIx(ocList, da.getId(), goA, dropId, dropA);
                acrossPlan.getDrivers().put(va.getResource(), "Repair");
            }
        }
        for (OrderConstraint constraint : ocList) {
            AcrossActivity first = (AcrossActivity)actsToIds.get(constraint.getFromId());
            AcrossActivity last = (AcrossActivity)actsToIds.get(constraint.getToId());
            List<AcrossActivity> aaList = acrossPlan.getPrecedences().get(last);
            if (aaList == null) {
                aaList = new ArrayList<AcrossActivity>();
                acrossPlan.getPrecedences().put(last, aaList);
            }
            aaList.add(first);
        }
        return acrossPlan;
    }

    private void putTwoActsInsteadOfOneFirstIx(List<OrderConstraint> ocList, String firstId, AcrossActivity first, String lastId, AcrossActivity last) {
        for (OrderConstraint constraint : ocList) {
            if (!constraint.getFromId().equals(firstId)) continue;
            constraint.setFromId(lastId);
        }
        OrderConstraint flOc = new OrderConstraint();
        flOc.setFromId(firstId);
        flOc.setToId(lastId);
        ocList.add(flOc);
    }

    private void putTwoActsInsteadOfOneLastIx(List<OrderConstraint> ocList, String firstId, AcrossActivity first, String lastId, AcrossActivity last) {
        for (OrderConstraint constraint : ocList) {
            if (!constraint.getToId().equals(lastId)) continue;
            constraint.setToId(firstId);
        }
        OrderConstraint flOc = new OrderConstraint();
        flOc.setFromId(firstId);
        flOc.setToId(lastId);
        ocList.add(flOc);
    }

    private AcrossActivity newGoto(String to, String from, String objId) {
        AcrossActivity aa = new AcrossActivity();
        aa.setActivityType("ACTIVITY_GOTO");
        aa.getParams().put("TO", to);
        if (from != null && objId != null) {
            aa.getParams().put("FROM", from);
            aa.getParams().put("OBJECT", objId);
        }
        return aa;
    }

    private AcrossActivity newEff(String where) {
        AcrossActivity aa = new AcrossActivity();
        aa.setActivityType("ACTIVITY_EFFECT");
        aa.getParams().put("WHERE", where);
        return aa;
    }

    private AcrossActivity newPick(String where, String mat, int num) {
        AcrossActivity aa = new AcrossActivity();
        aa.setActivityType("ACTIVITY_PICKUP");
        aa.getParams().put("WHERE", where);
        aa.getParams().put("MATERIAL_ID", mat);
        aa.getParams().put("AMOUNT", num);
        return aa;
    }

    private AcrossActivity newDrop(String where, String mat, int num) {
        AcrossActivity aa = this.newPick(where, mat, num);
        aa.setActivityType("ACTIVITY_DROP");
        return aa;
    }

    private String getTo(String name) {
        if (name.indexOf("@") == -1) {
            return name;
        }
        return name.substring(name.indexOf("@") + "@".length(), name.indexOf("<->"));
    }

    private String getFrom(String name) {
        if (name.indexOf("@") == -1) {
            return null;
        }
        return name.substring(name.indexOf("<->") + "<->".length(), name.length());
    }

    private String getObjId(String name) {
        if (name.indexOf("@") == -1) {
            return null;
        }
        return name.substring(0, name.indexOf("@"));
    }
}

