/*
 * Decompiled with CFR 0.152.
 */
package across.util;

import across.data.AdvTeamProposal;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.util.GoodsConstants;
import aglobe.container.transport.Address;
import java.util.Collection;

public class ListBatchTools {
    public static TransportBatch copyTransportBatch(TransportBatch original) {
        if (original != null) {
            return ListBatchTools.copyTransportBatch(original, original.getCount());
        }
        return null;
    }

    public static TransportBatch copyTransportBatch(TransportBatch original, long newCount) {
        if (original != null) {
            TransportBatch ntb = new TransportBatch();
            ntb.setBatchid(original.getBatchid());
            ntb.setComodityName(original.getComodityName());
            ntb.setCount(newCount);
            ntb.setStart(original.getStart());
            ntb.setStartAddress(original.getStartAddress());
            ntb.setStartTime(original.getStartTime());
            ntb.setTarget(original.getTarget());
            ntb.setTargetAddress(original.getTargetAddress());
            ntb.setTargetTime(original.getTargetTime());
            return ntb;
        }
        return null;
    }

    public static TransportBatch copyTransportBatch(TransportBatch original, long newCount, String start, Address startAddress, String target, Address targetAddress) {
        if (original != null) {
            TransportBatch ntb = new TransportBatch();
            ntb.setBatchid(original.getBatchid());
            ntb.setComodityName(original.getComodityName());
            ntb.setCount(newCount);
            ntb.setStart(start);
            ntb.setStartAddress(startAddress);
            ntb.setStartTime(original.getStartTime());
            ntb.setTarget(target);
            ntb.setTargetAddress(targetAddress);
            ntb.setTargetTime(original.getTargetTime());
            return ntb;
        }
        return null;
    }

    public static TransportBatch copyTransportBatch(TransportBatch original, String start, Address startAddress, long startTime, String target, Address targetAddress, long targetTime) {
        if (original != null) {
            TransportBatch ntb = new TransportBatch();
            ntb.setBatchid(original.getBatchid());
            ntb.setComodityName(original.getComodityName());
            ntb.setCount(original.getCount());
            ntb.setStart(start);
            ntb.setStartAddress(startAddress);
            ntb.setStartTime(startTime);
            ntb.setTarget(target);
            ntb.setTargetAddress(targetAddress);
            ntb.setTargetTime(targetTime);
            return ntb;
        }
        return null;
    }

    public static TransportBatch copyTransportBatch(TransportBatch original, String start, Address startAddress, String target, Address targetAddress) {
        if (original != null) {
            return ListBatchTools.copyTransportBatch(original, original.getCount(), start, startAddress, target, targetAddress);
        }
        return null;
    }

    public static long getTotalCount(Collection<TransportBatch> batches) {
        long res = 0L;
        for (TransportBatch batch : batches) {
            res += batch.getCount();
        }
        return res;
    }

    public static long getTypeCount(Collection<TransportBatch> batches, String type) {
        long res = 0L;
        for (TransportBatch batch : batches) {
            if (!GoodsConstants.resolveType(batch.getComodityName()).equalsIgnoreCase(type)) continue;
            res += batch.getCount();
        }
        return res;
    }

    public static String getTransportCfpStart(TransportCfp tcpf) {
        if (tcpf.getTransportBatch().size() > 0) {
            return tcpf.getTransportBatch().get(0).getStart();
        }
        return null;
    }

    public static String getTransportCfpTarget(TransportCfp tcpf) {
        if (tcpf.getTransportBatch().size() > 0) {
            return tcpf.getTransportBatch().get(0).getTarget();
        }
        return null;
    }

    public static String getTransportCfpId(AdvTeamProposal atp) {
        if (atp.getTask().size() > 0) {
            return atp.getTask().get(0).getTransportCfp().getRequestid();
        }
        return null;
    }
}

